set more off

set linesize 120
log using "/home/projects/sehs/replication/logs/rdplot_tables4and5.log", replace

*******************************************************************************
*
* DATE:    June 16, 2019
*
* PROGRAM: rdplot_table4and5.do
*
* DATA:    "/home/projects/sehs/replication/data/fullestsample_max.dta"
*
* OUTPUT:  ${var}_outcome_tier1.gph
*          ${var}_outcome_tier4.gph
*
*******************************************************************************
#delimit;
tempfile temp1 temp2;

* ------  GENERATE THE RIGHT BANDWIDTH USING RDROBUST;

* GETTING BANDWITH FOR EACH EXPERIMENT -- UNIFORM KERNEL;

capture program drop rdplots14;

program def rdplots14;
use "/home/projects/sehs/replication/data/fullestsample_max.dta", clear;
label var distance "Distance from HS in miles";
label var verycompetitiveplus "Attends a selective college";
postfile dataNon tierschcoh N_l N_r h_bw coeff se_coeff tiernum using 
"/home/projects/sehs/replication/data/NonParResults.dta", replace;
forvalues i = 1/148 {;
capture rdrobust $var centered if tierschcoh==`i', kernel(uniform) p(1); 
capture local tierschcoh = `i';
capture local N_l = e(N_h_l);
capture local N_r = e(N_h_r);
capture local h_bw = e(h_l);
capture local coeff = e(tau_cl);
capture local se_coeff = e(se_tau_cl);
capture sum tier if tierschcoh == `i';
capture local tiernum = r(mean);
capture post dataNon (`tierschcoh') (`N_l') (`N_r') (`h_bw') (`coeff') 
     (`se_coeff') (`tiernum');
ereturn clear;
};
postclose dataNon;

merge m:1 tierschcoh using "/home/projects/sehs/replication/data/NonParResults.dta";
drop if N_l == .;
quietly tab tierschcoh, gen(tsc);

preserve;
quietly rdrobust $var centered if tier == 1, covs($tsc1) p(1) kernel(uniform);
scalar ehl = e(h_l);
quietly reg $var $tsc1 if tier1==1 & -ehl<=centered & centered<=ehl;
predict yadj if tier1==1, resid; 
quietly sum $var if -ehl<=centered & centered<=ehl & tier1==1;
scalar mean = r(mean);
replace yadj = yadj + mean;
rdplot yadj centered if tier1==1 & -ehl <= centered & centered <= ehl, 
  binselect(esmv) kernel(uniform) p(1) graph_options(legend(off) ylabel($yl) 
  title(`:variable label $var') subtitle("Tier 1") xtitle("Centered Application Score") scheme(sj));
graph save "/home/projects/sehs/replication/figures/${var}_outcome_tier1.gph", replace;
restore;

preserve;
quietly rdrobust $var centered if tier == 4, covs($tsc4) p(1) kernel(uniform);
scalar ehl = e(h_l);
quietly reg $var $tsc4 if tier4==1 & -ehl<=centered & centered<=ehl;
predict yadj if tier4==1, resid; 
quietly sum $var if -ehl<=centered & centered<=ehl & tier4==1;
scalar mean = r(mean);
replace yadj = yadj + mean;
rdplot yadj centered if tier4==1 & -ehl <= centered & centered <= ehl, 
  binselect(esmv) kernel(uniform) p(1) graph_options(legend(off) ylabel($yl) 
  title(`:variable label $var') subtitle("Tier 4") xtitle("Centered Application Score") scheme(sj));
graph save "/home/projects/sehs/replication/figures/${var}_outcome_tier4.gph", replace;

!rm "/home/projects/sehs/replication/data/NonParResults.dta";
end;

****;
* Variable stdcomp;
global var "stdcomp";
global tsc "tsc1-tsc92";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc67-tsc92";
global yl "-2(2)4";
rdplots14;

* Variable = stdactcomp;
global var "stdactcomp";
global tsc "tsc1-tsc91";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc91";
global yl "-2(2)4";
rdplots14;

* Variable = latent8pct;
global var "latent8pct";
global tsc "tsc1-tsc91";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc91";
global yl "0(20)100";
rdplots14;

* Variable = gpa_unwt2;
global var "gpa_unwt2";
global tsc "tsc1-tsc88";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc66-tsc88";
global yl "0(1)4";
rdplots14;

* Variable = gpa_unwt2_gr11;
global var "gpa_unwt2_gr11";
global tsc "tsc1-tsc90";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc67-tsc90";
global yl "0(1)4";
rdplots14;

* Variable = grad4yr;
global var "grad4yr";
global tsc "tsc1-tsc86";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc66-tsc86";
global yl "0(.2)1";
rdplots14;

* Variable = firstfall;
global var "firstfall";
global tsc "tsc1-tsc66";
global tsc1 "tsc1-tsc14";
global tsc4 "tsc49-tsc66";
global yl "0(.2)1";
rdplots14;

* Variable = verycompetitiveplus;
global var "verycompetitiveplus";
global tsc "tsc1-tsc64";
global tsc1 "tsc1-tsc13";
global tsc4 "tsc48-tsc64";
global yl "0(.2)1";
rdplots14;

* Variable = anyhonors;
global var "anyhonors";
global tsc "tsc1-tsc88";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc88";
global yl "0(.2)1";
rdplots14;

* Variable = hrsstdy10;
global var "hrsstdy10";
global tsc "tsc1-tsc90";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc66-tsc90";
global yl "0(.2)1";
rdplots14;

* Variable = stdoscie;
global var "stdoscie";
global tsc "tsc1-tsc89";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc66-tsc89";
global yl "-2(1)2";
rdplots14;

* Variable = stdossaf;
global var "stdossaf";
global tsc "tsc1-tsc88";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc66-tsc88";
global yl "-2(1)2";
rdplots14;

* Variable = stdopeer;
global var "stdopeer";
global tsc "tsc1-tsc90";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc67-tsc90";
global yl "-2(1)2";
rdplots14;

* Variable = stdotrts;
global var "stdotrts";
global tsc "tsc1-tsc90";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc67-tsc90";
global yl "-2(1)2";
rdplots14;

* Variable = stdopssm;
global var "stdopssm";
global tsc "tsc1-tsc91";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc67-tsc91";
global yl "-2(1)2";
rdplots14;

* Variable = distance;
global var "distance";
global tsc "tsc1-tsc94";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc94";
global yl "0(2)10";
rdplots14;

