log using "/home/projects/sehs/replication/logs/figure1.log", replace

clear
set more off

*created by: LB
*created on: 21 jan 2013 

use "/home/projects/sehs/replication/data/analytic_replication.dta", clear

**********************************
* Sample restrictions
drop if dsped8==1
drop if completeapp==0
*keep if sidtype=="both"
*dropping people missing tier
drop if inlist(tier, 0, .)
**********************************

*Create new "offer" variables given the rule offer.

gen brooks_offer=offerrule=="Brooks"
gen jones_offer=offerrule=="Jones"
gen king_offer=offerrule=="King"
gen lane_offer=offerrule=="Lane"
gen lindblom_offer=offerrule=="Lindblom"
gen northside_offer=offerrule=="Northside"
gen payton_offer=offerrule=="Payton"
gen southshore_offer=offerrule=="South Shore"
gen westinghouse_offer=offerrule=="Westinghouse"
gen young_offer=offerrule=="Young"

gen brooks_enroll=schlname9=="BROOKS COLL PREP"
gen jones_enroll=schlname9=="JONES COLL PREP HIGH"
gen king_enroll=schlname9=="KING HIGH"
gen lane_enroll=schlname9=="LANE TECH HIGH"
gen lindblom_enroll=schlname9=="LINDBLOM MATH/SCI"
gen northside_enroll=schlname9=="NORTHSIDE COLL PREP"
gen payton_enroll=schlname9=="PAYTON COLL PREP HS"
gen southshore_enroll=schlname9=="SOUTH SHORE INTL" & cohort9==2013
gen westing_enroll=schlname9=="WESTINGHOUSE HS"
gen young_enroll=schlname9=="YOUNG MAGNET HIGH"

expand 6

sort sid
by sid: gen numobs=_n

gen schoice=schoice1 if numobs==1
replace schoice=schoice2 if numobs==2
replace schoice=schoice3 if numobs==3
replace schoice=schoice4 if numobs==4
replace schoice=schoice5 if numobs==5
replace schoice=schoice6 if numobs==6
gen centered=.
replace centered=brooks_cut_centered if schoice=="Brooks"
replace centered=jones_cut_centered if schoice=="Jones"
replace centered=king_cut_centered if schoice=="King"
replace centered=lane_cut_centered if schoice=="Lane"
replace centered=lindblom_cut_centered if schoice=="Lindblom"
replace centered=northside_cut_centered if schoice=="Northside"
replace centered=payton_cut_centered if schoice=="Payton"
replace centered=southshore_cut_centered if schoice=="South Shore"
replace centered=westing_cut_centered if schoice=="Westinghouse"
replace centered=young_cut_centered if schoice=="Young"

*Drop excess choices for students who list fewer than 6 schools.
drop if centered==.

hist centered, xline(0) scheme(sj) saving("/home/projects/sehs/replication/figures/figure1.gph", replace) 
rddensity centered, plot genvars(temp) graph_options(title("Density Plot: Centered Application Score"))
drop temp_*
preserve
drop if pointstotal>894
hist centered, xline(0) scheme(sj) saving("/home/projects/sehs/replication/figures/figure1_ptstotlt895.gph", replace) 
rddensity centered, plot genvars(temp) graph_options(title("Density Plot: Centered Application Score"))


