set more off

set linesize 120
log using "/home/projects/sehs/replication/logs/appendix_table5.log", replace

*******************************************************************************
*
* DATE:    June 15, 2019
*
* PROGRAM: appendix_table5.do
*
* DATA:    "/home/projects/sehs/replication/data/fullestsample_max.dta"
* NOTES:   1. rdrobust by tierXschoolXcohort to get the right sample for
*             including covariates.
*          2. rdrobust by tier using tierXschoolXcohort FEs and save the right
*             bandwidths for parametric estimates.
*          3. Parametric estimates including all tiers. Test beta hat 1 = beta
*             hat 4.
*          4. Write estimates out to table and calculate means at the left limit
*             using the margins command.
*   KERNEL: uniform
*   POLYNOMIAL: p(1)

* OUTPUT: appendix_table5.xml
*
*******************************************************************************
#delimit;
tempfile temp1 temp2;

****** Define the estimation program ******;
capture program drop rdrobust1234;
program def rdrobust1234;
use "/home/projects/sehs/replication/data/fullestsample_max.dta", clear;
* Keep only schools with relatively similar cutoffs across tiers.;
drop if inlist(schoice,"Brooks","Jones","Lane","Northside","Payton","Young");
drop if schoice=="Lindblom" & inlist(cohort9,2011,2012);
drop if schoice=="Westinghouse" & inlist(cohort9,2011,2012);

di "$var";
/*Step 1*/;
postfile dataNon tierschcoh N_l N_r h_bw coeff se_coeff tiernum using 
"/home/projects/sehs/replication/data/NonParResults.dta", replace;

forvalues i = 1/148 {;
capture rdrobust $var centered if tierschcoh==`i', kernel(uniform) p(1); 
capture local tierschcoh = `i';
capture local N_l = e(N_h_l);
capture local N_r = e(N_h_r);
capture local h_bw = e(h_l);
capture local coeff = e(tau_cl);
capture local se_coeff = e(se_tau_cl);
capture sum tier if tierschcoh == `i';
capture local tiernum = r(mean);
capture post dataNon (`tierschcoh') (`N_l') (`N_r') (`h_bw') (`coeff') 
     (`se_coeff') (`tiernum');
ereturn clear;
};

postclose dataNon;
/* Step 2*/;
merge m:1 tierschcoh using "/home/projects/sehs/replication/data/NonParResults.dta";
drop if N_l == .;
quietly tab tierschcoh, gen(tsc);
gen x=1;
quietly rdrobust $var centered if tier == 1, covs($tsc1) p(1) kernel(uniform);
replace x=0 if tier==1 & (centered<-e(h_l) | centered>e(h_l));

quietly rdrobust $var centered if tier == 2, covs($tsc2) p(1) kernel(uniform);
replace x=0 if tier==2 & (centered<-e(h_l) | centered>e(h_l));

quietly rdrobust $var centered if tier == 3, covs($tsc3) p(1) kernel(uniform);
replace x=0 if tier==3 & (centered<-e(h_l) | centered>e(h_l));

quietly rdrobust $var centered if tier == 4, covs($tsc4) p(1) kernel(uniform);
replace x=0 if tier==4 & (centered<-e(h_l) | centered>e(h_l));

/*Step 3*/;
reg $var tier1-tier4 i.admitXtier1 i.admitXtier2 i.admitXtier3 i.admitXtier4
  centeredXtier1-centeredXtier4 centeredXadmitXtier1-centeredXadmitXtier4 
  $tsc1 $tsc2 $tsc3 $tsc4 if x==1, nocons cluster(schoice_n);
test i1.admitXtier1=i1.admitXtier4;
/* Step 4*/;
outreg2 i1.admitXtier1 i1.admitXtier2 i1.admitXtier3 i1.admitXtier4 using 
  "/home/projects/sehs/replication/tables/appendix_table5.xml", nocons keep(i.admitXtier1 
  i.admitXtier2 i.admitXtier3 i.admitXtier4) excel se dec(3) addstat(p-value, `r(p)') append;
margins admitXtier1, at(centeredXtier1=0 centeredXadmitXtier1=0) subpop(tier1);
margins admitXtier2, at(centeredXtier2=0 centeredXadmitXtier2=0) subpop(tier2);
margins admitXtier3, at(centeredXtier3=0 centeredXadmitXtier3=0) subpop(tier3);
margins admitXtier4, at(centeredXtier4=0 centeredXadmitXtier4=0) subpop(tier4);

!rm "/home/projects/sehs/replication/data/NonParResults.dta";
end;

* Variable = stdcomp;
global var "stdcomp";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = stdactcomp;
global var "stdactcomp";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = latent8pct;
global var "latent8pct";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = gpa_unwt2;
global var "gpa_unwt2";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = gpa_unwt2_gr11;
global var "gpa_unwt2_gr11";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = grad4yr;
global var "grad4yr";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc34";
rdrobust1234;

* Variable = firstfall;
global var "firstfall";
global tsc1 "tsc1-tsc4";
global tsc2 "tsc6-tsc9";
global tsc3 "tsc11-tsc14";
global tsc4 "tsc16-tsc19";
rdrobust1234;

* Variable = verycompetitiveplus;
global var "verycompetitiveplus";
global tsc1 "tsc1-tsc4";
global tsc2 "tsc6-tsc9";
global tsc3 "tsc11-tsc14";
global tsc4 "tsc16-tsc19";
rdrobust1234;

* Variable = anyhonors;
global var "anyhonors";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = hrsstdy10;
global var "hrsstdy10";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = stdoscie;
global var "stdoscie";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = stdossaf;
global var "stdossaf";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc34";
rdrobust1234;

* Variable = stdopeer;
global var "stdopeer";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = stdotrts;
global var "stdotrts";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;
*/;
* Variable = stdopssm;
global var "stdopssm";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;

* Variable = distance;
global var "distance";
global tsc1 "tsc1-tsc8";
global tsc2 "tsc10-tsc17";
global tsc3 "tsc19-tsc26";
global tsc4 "tsc28-tsc35";
rdrobust1234;
