
log using "/home/projects/sehs/replication/logs/hsgrowth_byses.log", replace

*goal: graph distr of EPAS growth percentiles for high-achieving students in tier 1 and tier 4
*growth data are for 2013-14
*Numbers are cited in Section I of the text following discussion of Table 1.

tempfile temp1 temp2

use "/home/projects/sehs/data/epasgrowth.dta", clear
rename schlid schid9
keep schid9 growthpctile
sort schid 
save `temp1'

use "/home/projects/sehs/data/allm910.dta", clear
rename *, lower
keep if statu>0
keep if granu910==9
gen year=2010
rename schid910 schid9
rename ssoc00910 ssoc
rename scon00910 scon
keep sid year schid9 ssoc scon centract00
save `temp2'

use "/home/projects/sehs/data/allm911.dta"
rename *, lower
keep if statu>0
keep if granu==9
gen year=2011
rename schid schid9
rename ssoc09911 ssoc
rename scon09911 scon
keep sid year schid9 ssoc scon centract00
append using `temp2'
save `temp2', replace

use "/home/projects/sehs/data/allm912.dta"
rename *, lower
keep if statu>0
keep if granu==9
gen year=2012
rename schid schid9
rename ssoc09912 ssoc
rename scon09912 scon
keep sid year schid9 ssoc scon centract00
append using `temp2'

sort sid year
duplicates report sid
by sid: keep if _n==1

gen cohort9=year
sort schid9 cohort9

merge m:1 schid9 using `temp1', keep(master matches)
drop _merge
rename centract00 tract00

sort sid
merge 1:1 sid using "/home/projects/nbct/ccsr/data/tests/latent8.dta", keep(master matches)
drop _merge

*creating indicator for SES status and SCON status
sort cohort9
xtile ssocq10=ssoc if cohort9==2010, nq(4)
xtile ssocq11=ssoc if cohort9==2011, nq(4)
xtile ssocq12=ssoc if cohort9==2012, nq(4)
gen ssocq=ssocq10
replace ssocq=ssocq11 if cohort9==2011
replace ssocq=ssocq12 if cohort9==2012

*creating indicator for high-ach students
foreach i in 10 11 12 {
egen std_latent`i'=std(latent8) if cohort9==20`i'
}

gen std_latent=std_latent10 if cohort9==2010
replace std_latent=std_latent11 if cohort9==2011
replace std_latent=std_latent12 if cohort9==2012

twoway (kdensity growthpctile if ssocq==1 & std_latent>1 & std_latent!=., legend(label(1 "Tier 1"))) (kdensity growthpctile if ssocq==4 & std_latent>1 & std_latent!=., legend(label(2 "Tier 4")))
graph save "/home/projects/sehs/replication/figures/HSgrowth_highachievers.gph", replace

hist growthpctile if ssocq==1 & std_latent>1 & std_latent!=., title("HS National School Growth Percentile") subtitle("High-Achieving Students in Low-SES Neigborhoods") xtitle("Explore-Plan growth percentile") xlabel(0(10)100) ylabel(0(.02).10)
graph save "/home/projects/sehs/replication/figures/HSgrowth_highach1", replace
hist growthpctile if ssocq==4 & std_latent>1 & std_latent!=., title("HS National School Growth Percentile") subtitle("High-Achieving Students in High-SES Neigborhoods") xtitle("Explore-Plan growth percentile") xlabel(0(10)100) ylabel(0(.02).10)
graph save "/home/projects/sehs/replication/figures/HSgrowth_highach4", replace


table ssocq if std_latent>1 & std_latent~=., c(mean growthpctile)

gen lowgrowth = growthpctile < 20
table ssocq if std_latent>1 & std_latent!=., c(mean lowgrowth)

