****************** Intergenerational Analysis on 2nd Generation's Education


do "D:\Data\workdata\704665\daycare\dofiles\first.do"

**************************************************************************
*********************** COLLAPSED DATA ANALYSIS, second gen
**************************************************************************

use "$work\analysis_daycare_intergen_everopen.dta", clear


**********************************
* predicted outcomes for second gen
* Appendix Table A10
**********************************

foreach out in $kidedu25 {

reg `out' $contrvars [aweight=N]
predict pr`out'
}


eststo clear
foreach var in  $predoutkid  {
eststo: areg `var' operating  i.year i.county#c.year [aw=N], abs(muni) cl(muni)
qui sum `e(depvar)' [aw `e(wexp)'] if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\predoutkid_robustness.tex", keep(operating) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) 
replace booktabs fragment stats(N, label("Observations (cells)"))
mtitles ("Yrs.School" "More than Comp. Edu." "Gym.") ;
#delimit cr



***********************
*mainouts
* table 5
***********************
foreach vars of global kidedu25  {

	quietly: areg `vars' operating  $style1 , abs(muni) cl(muni)

	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	 areg `vars' operating  $style2 , abs(muni) cl(muni)
			
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	

}

/*Creates the table  */
file open myfile using "$results\kidedu25.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  			 		\\" _n 
file close myfile
foreach vars of global kidedu25  {
	estout `vars'* using "$results\kidedu25.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control Mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\kidedu25.tex", write append
do $dofiles\tabbottom.do



estimates clear

* health at age 25

global title_nights25 "Hosp. nights, age 25"
global title_nights30 "Hosp. nights, age 30"
global title_ever25 "Ever hosp., age 25"
global title_ever30 "Ever hosp., age 30"

foreach vars of varlist ever25 nights25 ever30 nights30  {

	quietly: areg `vars' operating  $style1 , abs(muni) cl(muni)

	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	 areg `vars' operating  $style2 , abs(muni) cl(muni)
			
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	

}

/*Creates the table  */
file open myfile using "$results\kidsnights.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  			 		\\" _n 
file close myfile
foreach vars of varlist ever25 nights25 ever30 nights30 {
	estout `vars'* using "$results\kidsnights.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\kidsnights.tex", write append
do $dofiles\tabbottom.do

estimates clear


*robustness (second gen outcomes)



capture drop decade
gen decade=.
replace decade=1 if year<1940
replace decade=2 if year>=1940 & year<1950
replace decade=3 if year>=1950

gen fyear=year-3
gen edu=(fyear>=1946 & rural==1)

estimates clear 
*mainouts robustness
************************************************************
* Table A7
************************************************************

foreach vars of global kidedu25  {

	areg `vars' operating  i.year  $contrvars i.rural#c.year  [aweight=N]  , abs(muni) cl(muni)
	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	 areg `vars' operating edu  $style1, abs(muni) cl(muni)	
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	areg `vars' operating  i.rural#i.decade $style1, abs(muni) cl(muni)
	estimates store `vars'4
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 

	
	eststo: areg `vars' frac_operating    $style2, abs(muni) cl(muni)
	estimates store `vars'5
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	

	
	}



/*Creates the table  */
file open myfile using "$results\kidout_robust.tex", write replace
file write myfile "\begin{tabular}{p{1.5in} cccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 	& (4) 	 		\\" _n ///
"   		&              (Rural trends)  & (Edu. Ref.) & (Rural*Decade)  &(Frac Yrs) 	\\" _n 
file close myfile
foreach vars of global kidedu25  {
	estout `vars'* using "$results\kidout_robust.tex", type ///
		rename(frac_operating operating) append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\kidout_robust.tex", write append
file write myfile "\midrule" _n ///
"Cohort FE 									&    Yes   &         Yes  & 		Yes  	&  Yes   	\\" _n ///
"Municipality FE 							&    Yes   &         Yes  & 		Yes  	&  Yes    	 \\" _n ///
"Muni Controls  							&    Yes   &         Yes  & 		Yes  	&  Yes  	\\" _n ///
"\bottomrule" _n "\end{tabular}"
file close myfile



* robustness to change in sample
*mainouts robustness
************************************************************
* Table A8
************************************************************

estimates clear 
foreach vars of global kidedu25  {
	
	areg `vars' operating $style1  if  rural==0 , abs(muni) cl(muni)
	
	estimates store `vars'1
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 

	quietly: areg `vars' operating $style1 if  rural==1 , abs(muni) cl(muni)
	estimates store `vars'2 
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 

	areg `vars' operating   $style2   if   fstyear>=1934 & fstyear!=. , abs(muni) cl(muni)
	
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 
	

	quietly: areg `vars' operating  $style2  if ever_nurse==1 , abs(muni) cl(muni)
	
	estimates store `vars'5
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)' 
	
	
	}


/*Creates the table  */
file open myfile using "$results\kidout_robust1.tex", write replace
file write myfile "\begin{tabular}{p{1.5in} cccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 	& (4) 	  		\\" _n ///
"   		&         (Rural areas) &        (Towns)  & (No always impl.) &  (Ever nurse) 	\\" _n 
file close myfile
foreach vars of global kidedu25  {
	estout `vars'* using "$results\kidout_robust1.tex", type ///
		 append  cells(b(star fmt(%9.3f)) se(par([ ]))) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control  mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\kidout_robust1.tex", write append
file write myfile "\midrule" _n ///
"Cohort FE 									&    Yes   &         Yes  & 		Yes  	&  Yes  	  \\" _n ///
"Municipality FE 							&    Yes   &         Yes  & 		Yes  	&  Yes  	    	 \\" _n ///
"Muni Controls  							&    Yes   &         Yes  & 		Yes  	&  Yes   	\\" _n ///
"\textit{Trends} \\" _n ///
"Urban/Rural 		  &        No 	& No 	      	& Yes &         Yes  \\" _n ///
"\bottomrule" _n "\end{tabular}"
file close myfile

estimates clear 


**************************************************************************
****************** interaction with nurse program, not reported in paper
**************************************************************************


eststo clear
foreach var in $kidedu25 {
eststo: areg `var' operating nurse_treat daycare_nurse $style2 , abs(muni) cl(muni)
qui sum `var'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\kidedu25_cells_DAY_NURSE.tex", keep(operating nurse_treat daycare_nurse) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) mgroups("Child Outcomes at Age 25", pattern(1 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span
erepeat(\cmidrule(lr){@span}))
replace booktabs fragment stats(dv N, label("Control mean, dep. var." "Observations (cells)"))
mtitles ("Yrs.School" "More than comp. edu." "Gym.") ;
#delimit cr




**************************************************************************
**************** Event study figure for second gen
* figures 2 and A4
**************************************************************************

* slightly different sample as dependent on women born in 1935...
gen age_atopen = fstyear - year + 3
keep if fstyear!=.

***** event study regression graphs
capture drop older
gen older=age_atopen>11 & age_atopen<.

capture drop younger
gen younger = age_atopen<-2
replace younger = 1 if age_atopen==.
*want to assign people in always open to younger group
capture drop event_time
gen event_time = _n-100


gen age_pre1 = age_atopen==-1
replace age_pre1 = age_atopen==-2

forval i=0(2)11 {
gen age`i' = age_atopen==`i'
replace age`i' =1 if age_atopen==`i'+1

}

order age0-age10

* event graphs - loop over outcomes

foreach var in $kidedu25 {


gen coef = . 
gen ci_l = .
gen ci_h = .

areg `var' younger age_pre1 age0-age4 age8-age10 older  $style2, abs(muni) cl(muni)


forval i=1(1)1 {
replace coef = _b[age_pre`i'] if event_time==-`i'-1
replace ci_l =  _b[age_pre`i'] - 1.96*_se[age_pre`i'] if event_time==-`i'-1
replace ci_h = _b[age_pre`i'] + 1.96*_se[age_pre`i'] if event_time==-`i'-1
}

/*forval i=0(2)10 {
replace coef = _b[age_post`i'] if event_time==`i'
replace ci_l =  _b[age_post`i'] - 1.96*_se[age_post`i'] if event_time==`i'
replace ci_h = _b[age_post`i'] + 1.96*_se[age_post`i'] if event_time==`i'
}*/

*year of approval at ages 0-6
forval i=0(2)4 {
replace coef = _b[age`i'] if event_time==`i'
replace ci_l = _b[age`i'] - 1.96*_se[age`i'] if event_time==`i'
replace ci_h = _b[age`i'] + 1.96*_se[age`i'] if event_time==`i'
}

forval i=8(2)10 {
replace coef = _b[age`i'] if event_time==`i'
replace ci_l = _b[age`i'] - 1.96*_se[age`i'] if event_time==`i'
replace ci_h = _b[age`i'] + 1.96*_se[age`i'] if event_time==`i'
}


replace coef = 0 if event_time==6
replace ci_l = 0 if event_time==6
replace ci_h = 0 if event_time==6

preserve
collapse (mean) coef ci_l ci_h, by(event_time)

keep if event_time>=-2 & event_time<=11
drop if coef==.

label define eventtime -2"-2&-1" 0"0&1" 2"2&3" 4"4&5" 6"6&7" 8"8&9" 10"10&11" -3"<-2"  12 ">11"
label values event_time eventtime

#delimit ;
twoway (scatter coef event_time if event_time<6, msymbol(o) mcolor(black) connect(l) lw(medthin) lcolor(black) lpattern(solid))
(scatter coef event_time if event_time>6, msymbol(o) mcolor(black) connect(l) lw(medthin) lcolor(black) lpattern(solid))
(scatter coef event_time if event_time==6, msymbol(o) mcolor(black) connect(l) lw(medthin) lcolor(black) lpattern(solid))
(line ci_l event_time , lpattern(dash) lw(medthin) lcolor(blue))
(line ci_h event_time , lpattern(dash) lw(medthin) lcolor(blue))
(line ci_l event_time , lpattern(dash) lw(medthin) lcolor(blue))
(line ci_h event_time , lpattern(dash) lw(medthin) lcolor(blue)),
xline(2, lcolor(red)) xline(6, lcolor(red) lpattern(dash) lw(medthin)) yline(0, lcolor(black))
xtitle(Age at Preschool Approval) ytitle(Event-Time Coefficient) xlabel(-2(2)10,valuelabel) legend(off) ;
#delimit cr



graph export "$graphs\kid_eventstudy_everD_`var'.png", replace

restore

drop ci_l ci_h coef

}


