*EVENT GRAPHS 
* First gen outcomes

do "D:\Data\workdata\704665\daycare\dofiles\first.do"


use "$work\analysis_daycare_muni_ever_yrapproval.dta", clear

drop if alwaysopen==1
***** event study regression graphs
drop older
gen older=age_atopen>11 & age_atopen<.

drop younger
gen younger = age_atopen<-2
replace younger = 1 if age_atopen==.
*want to assign people in always open to younger group

gen event_time = _n-100

gen age_pre1 = age_atopen==-1
replace age_pre1 = age_atopen==-2

forval i=0(2)11 {
gen age`i' = age_atopen==`i'
replace age`i' =1 if age_atopen==`i'+1

}

order age0-age10


* event graphs - loop over outcomes

foreach var of  varlist $mainout {


gen coef = . 
gen ci_l = .
gen ci_h = .

areg `var' younger age_pre1 age0-age4 age8-age10 older  $style2, abs(muni) cl(muni)


forval i=1(1)1 {
replace coef = _b[age_pre`i'] if event_time==-`i'-1
replace ci_l =  _b[age_pre`i'] - 1.96*_se[age_pre`i'] if event_time==-`i'-1
replace ci_h = _b[age_pre`i'] + 1.96*_se[age_pre`i'] if event_time==-`i'-1
}


*year of approval at ages 0-6
forval i=0(2)4 {
replace coef = _b[age`i'] if event_time==`i'
replace ci_l = _b[age`i'] - 1.96*_se[age`i'] if event_time==`i'
replace ci_h = _b[age`i'] + 1.96*_se[age`i'] if event_time==`i'
}

forval i=8(2)10 {
replace coef = _b[age`i'] if event_time==`i'
replace ci_l = _b[age`i'] - 1.96*_se[age`i'] if event_time==`i'
replace ci_h = _b[age`i'] + 1.96*_se[age`i'] if event_time==`i'
}


replace coef = 0 if event_time==6
replace ci_l = 0 if event_time==6
replace ci_h = 0 if event_time==6

preserve
collapse (mean) coef ci_l ci_h, by(event_time)

keep if event_time>=-2 & event_time<=11
drop if coef==.

label define eventtime -2"-2&-1" 0"0&1" 2"2&3" 4"4&5" 6"6&7" 8"8&9" 10"10&11" -3"<-2"  12 ">11"
label values event_time eventtime

#delimit ;
twoway (scatter coef event_time if event_time<6, msymbol(o) mcolor(black) connect(l) lw(medthin) lcolor(black) lpattern(solid))
(scatter coef event_time if event_time>6, msymbol(o) mcolor(black) connect(l) lw(medthin) lcolor(black) lpattern(solid))
(scatter coef event_time if event_time==6, msymbol(o) mcolor(black) connect(l) lw(medthin) lcolor(black) lpattern(solid))
(line ci_l event_time , lpattern(dash) lw(medthin) lcolor(blue))
(line ci_h event_time , lpattern(dash) lw(medthin) lcolor(blue))
(line ci_l event_time , lpattern(dash) lw(medthin) lcolor(blue))
(line ci_h event_time , lpattern(dash) lw(medthin) lcolor(blue)),
xline(2, lcolor(red)) xline(6, lcolor(red) lpattern(dash) lw(medthin)) yline(0, lcolor(black))
xtitle(Age at Preschool Approval) ytitle(Event-Time Coefficient) xlabel(-2(2)10,valuelabel) legend(off) ;
#delimit cr



graph export "$graphs\eventstudy_everD_`var'.png", replace

restore

drop ci_l ci_h coef

}

