* Number of births in the DK towns
* for comparison of no of births/no enrolled
* prep some external data here

do "D:\Data\workdata\704665\daycare\dofiles\first.do"
**************************************************************************************

use "$work\parish_munic_county.dta",clear

// find/define towns vs rural areas
gen urbanstring=substr(Kommunenavn, -12,.)
gen otherstring=substr(Kommunenavn, -6,.)
gen urban=(urbanstring=="stadskommune")
drop urbanstring
label var urban "Town"

sort Kommune_ID 
by Kommune_ID: keep if _n==1
keep Kommune_ID Kommunenavn Amtsnavn urban

gen namestring=substr(Kommunenavn, -12,.)
split Kommunenavn, parse(" K")
rename Kommunenavn1 name_by
keep Kommune_ID Kommunenavn Amtsnavn name_by urban

replace name_by="Højer" if Kommune_ID==120573
replace name_by="København" if Kommune_ID==120663
replace name_by="Løgumkloster" if Kommune_ID==120577
replace name_by="Nykøbing Sj." if Kommune_ID==120644
replace name_by="Nordborg" if Kommune_ID==120631
replace name_by="Augustenborg" if Kommune_ID==120621
replace name_by="Marstal" if Kommune_ID==119651

#delimit;
replace urban=1 if (Kommune_ID==120573 | Kommune_ID==120663 | Kommune_ID==120577|
	Kommune_ID==120644|Kommune_ID==120631|Kommune_ID==120621|Kommune_ID==119651);
	#delimit cr
keep if urban==1

* some hardcoding
replace name_by="Nykøbing M" if Kommune_ID==120700
replace name_by="Brønderslev" if Kommune_ID==120679
replace name_by="Frederiksværk" if Kommune_ID==120682
replace name_by="Faaborg" if Kommune_ID==120719
replace name_by="Grenaa" if Kommune_ID==120694
replace name_by="Helsingør" if Kommune_ID==120708
replace name_by="Hillerød" if Kommune_ID==120711
replace name_by="Hjørring" if Kommune_ID==120671
replace name_by="Holbæk" if Kommune_ID==120725
replace name_by="Korsør" if Kommune_ID==120706
replace name_by="Køge" if Kommune_ID==120681
replace name_by="Neksø" if Kommune_ID==120659
replace name_by="Nykøbing F" if Kommune_ID==120667
replace name_by="Næstved" if Kommune_ID==120691
replace name_by="Nr. Sundby" if Kommune_ID==120716
replace name_by="Løgstør" if Kommune_ID==120649
replace name_by="Aabenraa" if Kommune_ID==120651
replace name_by="Aakirkeby" if Kommune_ID==120645
replace name_by="Aalborg" if Kommune_ID==120656
replace name_by="Aarhus" if Kommune_ID==120696
replace name_by="Præstø" if Kommune_ID==120686
replace name_by="Ringkøbing" if Kommune_ID==120655
replace name_by="Rønne" if Kommune_ID==120674
replace name_by="Rudkøbing" if Kommune_ID==120707
replace name_by="Rødby" if Kommune_ID==120658
replace name_by="Saxkøbing" if Kommune_ID==120717
replace name_by="Skelskør" if Kommune_ID==120677
replace name_by="Sorø" if Kommune_ID==120654
replace name_by="Stubbekøbing" if Kommune_ID==120650
replace name_by="Sæby" if Kommune_ID==120684
replace name_by="Sønderborg" if Kommune_ID==120721
replace name_by="Tønder" if Kommune_ID==120669
replace name_by="Ærøskøbing" if Kommune_ID==120688
replace name_by="Storehedinge" if Kommune_ID==120722

merge 1:m name_by using "$external\bydata_combined.dta"
keep if _merge==3
drop _merge

sort Kommune_ID

keep Kommune_ID name_by Amtsnavn Kommunenavn year id_by pop death_all deathpm livebirth death01 death14 stillbirth

label var pop "Population"
label var death_all "Deaths"
label var deathpm "Death per 1000 pop"
label var livebirth "Live births"
label var death01 "First yr mortality"
label var death14 "Deaths age 1-4"
label var stillbirth "Still births"


compress
save "$work\townsdata.dta", replace






