﻿
run "D:\Data\workdata\704665\daycare\dofiles\first.do"

******************************************************************************
*  educational outcomes kids
******************************************************************************
 foreach num of numlist 1980/2012{
use pnr pstill hfaudd using "$raw\GRUND`num'.dta",clear
bysort pnr: gen byte copies=_n
drop if copies>1
drop copies
drop if pnr==""
merge 1:1 pnr using "$work\pop3560_kidssample.dta"
keep if _merge==3
drop _merge

gen outyear=`num'
 
* gen age var
gen age=outyear-fodyear

*education
gen audd= hfaudd
gen audd1=string(audd)
drop audd
rename audd1 audd
merge m:1 audd using "$format\uddan_2008_audd.dta"
drop if _merge==2
destring h1, replace

gen university=(h1>=60 & h1<71)
replace university=. if h1==.
gen higheredu=(h1>=40 & h1<60)
replace higheredu=. if h1==.
gen gymnasium=(h1==20 | h1==25)
replace gymnasium=. if h1==.
gen edu_unknown=(h1>70)
gen basic_edu=(h1==10)
replace basic_edu=. if h1==.

gen month=pria

drop pstill audd atext pria fsp1e apubl1 u1 u1tekst m1 m1tekst _merge
compress

save "$work\edu_`num'kids.dta",replace
}

clear

use "$work\edu_1980kids.dta",clear
 foreach num of numlist 1981/2012{
append  using  "$work\edu_`num'kids.dta"
 }

sort pnr outyear 

save "$work\edu_panel_kids.dta", replace

clear
use "$work\edu_panel_kids.dta", clear

* the education vars
keep pnr university higheredu edu_unknown basic_edu gymnasium  month age

sort pnr
foreach var of varlist university higheredu edu_unknown basic_edu gymnasium  month {
 foreach nums of numlist 20(5)50{
gen `var'`nums'=`var' if age==`nums'
compress
}
}

drop university higheredu edu_unknown basic_edu   month 

collapse (min) university20-gymnasium50 (max) month20-month50, by(pnr)


save "$work\edu_2050_kids.dta", replace


use "$work\edu_2050_kids.dta", clear

foreach num of numlist 20(5)50{
gen year`num'=month`num'/12
}

foreach num of numlist 20(5)50{
label var university`num' "University education age `num'"
label var higheredu`num' "Higher education age `num'"
label var edu_unknown`num' "Missing education age `num'"
label var basic_edu`num' "Basic education age `num'"
label var gymnasium`num' "Gymnasium by age `num'"
label var month`num' "Months of education age `num'"
label var year`num' "Years of education age `num'"
}


save "$work\edu_2050_kids.dta", replace


**************************************************
************* Kids education outcomes
* for all kids and oldest kid (all kids added)
* prepare for merge to moms
**************************************************
use "$work\edu_2050_kids.dta", clear

*1-basic 
foreach k in 20 25 30 35 40 45 50 {
gen morethanbasic`k' = 1- basic_edu`k'
}


foreach var in university* higheredu* edu_unknown* basic_edu* morethanbasic* gymnasium* month* year* {
rename `var' `var'_kid
}

ren pnr pnr_child
save "$work\edu_2050_kids_tomerge.dta", replace

gen pnr=pnr_child
* merge on kids hosp stays 
merge 1:1 pnr using "$work\lpr_nights_kids.dta"

drop _merge
foreach num of numlist 25(1)34{
replace nights`num'=0 if nights`num'==.
}

gen ever25=(nights25!=0)
gen ever30=(nights30!=0)

drop pnr
save "$work\edu_2050_kids_tomerge.dta", replace

****** Data set of moms, their kids, and their dads
use "$work\pop3560_fertility.dta", clear

sort pnrm foed_dagkid pnr
by pnrm: keep if _n==1

ren pnr pnr_child
ren pnrm pnr 
*to merge to daycare data
ren pnrf pnr_father
gen dad_missing = (pnr_father=="")

***keep only moms
keep if nokids==.

***age at birth
gen momageatbirth = fodyear_kid-fodyear

***********************************************************************************************
***** oldest child per mom  (also for multiple births)
* omit this part of the code when creating dataset with all kids - then save as "all kids"
***********************************************************************************************
sort pnr foed_dagkid  //  unique sorting
by pnr: keep if _n==1


merge 1:1 pnr_child using "$work\edu_2050_kids_tomerge.dta"
keep if _merge==3
drop _merge

save "$work\edu_2050_oldestkids_tomerge.dta", replace // save here as "all kids" when not using the above contraint

*****************************************************************
********************* MERGE TO DAYCARE DATA
*****************************************************************

use "$work\pop_daycare_popmunic_yrapproval.dta", clear
* education
merge 1:1 pnr using "$work\edu_3065.dta"

drop if _merge==2
drop _merge

*** keep only relevant cohorts of females
keep if male==0
keep if fodyear>=1935 & fodyear<=1957
*we have 1935-1957 cohorts


* merge to kids' education data using mom's pnr
* alternatively merge with all kids
merge 1:1 pnr using "$work\edu_2050_oldestkids_tomerge.dta"
*_merge = 1 for women who are not mothers
*_merge = 2 for cohorts born in 1958-1960

keep if _merge==3
drop _merge

* missing for the outcomes where kids are too young...
replace ever25=. if fodyear_kid>1986
replace ever30=. if fodyear_kid>1982
replace nights25=. if fodyear_kid>1986
replace nights30=. if fodyear_kid>1982

****** merge to Nurse data *****

merge m:1 Sognekode_IM using "$work\nurseprogram.dta"
drop _merge
sort Kommune_ID
by Kommune_ID: egen nurse_date1=max(nurse_date)
drop nurse_date
rename nurse_date1 nurse_date 


* add info on the 28 munics without nurse information among our childcare munics

gen muni=Kommune_ID

gen imputenurse=0
replace nurse_date=date("1/1/1964", "MDY") if muni==120621
replace imputenurse=1 if muni==120621 /*Augustenborg*/

replace nurse_date=. if muni==120653
replace imputenurse=1 if muni==120653 /*Bogense*/

replace nurse_date=date("1/1/1964", "MDY") if muni==120622
replace imputenurse=1 if muni==120622 /*Broager*/

replace nurse_date=date("1/1/1950", "MDY") if muni==119265
replace imputenurse=1 if muni==119265 /*Faxe*/

replace nurse_date=. if muni==120180
replace imputenurse=1 if muni==120180 /*Hammel Voldby Søby*/

replace nurse_date=date("1/1/1950", "MDY") if muni==118980
replace imputenurse=1 if muni==118980 /*Herlev*/

replace nurse_date=date("1/1/1950", "MDY") if muni==119289
replace imputenurse=1 if muni==119289 /*Hårlev Himlingeøje*/

replace nurse_date=date("1/1/1950", "MDY") if muni==118983
replace imputenurse=1 if muni==118983 /*Høje Tåstrup*/

replace nurse_date=. if muni==120573
replace imputenurse=1 if muni==120573 /*Højer*/

replace nurse_date=. if muni==120362
replace imputenurse=1 if muni==120362 /*Ikast*/

replace nurse_date=. if muni==120577
replace imputenurse=1 if muni==120577 /*Løgumkloster */

replace nurse_date=date("1/1/1960", "MDY") if muni==120631
replace imputenurse=1 if muni==120631 /*Nordborg*/

replace nurse_date=. if muni==119590
replace imputenurse=1 if muni==119590 /*Nørre Åby*/

replace nurse_date=date("1/1/1964", "MDY") if muni==119659
replace imputenurse=1 if muni==119659 /*Ringe*/

replace nurse_date=. if muni==120707
replace imputenurse=1 if muni==120707 /*Rudkøbing*/

replace nurse_date=date("1/1/1950", "MDY") if muni==120701
replace imputenurse=1 if muni==120701 /*Skagen*/

replace nurse_date=date("1/1/1950", "MDY") if muni==120677
replace imputenurse=1 if muni==120677 /*Skælskør*/

replace nurse_date=. if muni==120587
replace imputenurse=1 if muni==120587 /*Skrbk*/

replace nurse_date=date("1/1/1964", "MDY") if muni==120636
replace imputenurse=1 if muni==120636 /*Sottrup*/

replace nurse_date=date("1/1/1950", "MDY") if muni==120722
replace imputenurse=1 if muni==120722 /*Store Heddinge*/

replace nurse_date=. if muni==120208	
replace imputenurse=1 if muni==120208 /*Them*/

replace nurse_date=. if muni==120590
replace imputenurse=1 if muni==120590 /*Tinglev*/

replace nurse_date=. if muni==120549
replace imputenurse=1 if muni==120549   /*Toftlund*/

replace nurse_date=date("1/1/1950", "MDY") if muni==120551
replace imputenurse=1 if muni==120551   /*Tystrup*/

replace nurse_date=. if muni==119601
replace imputenurse=1 if muni==119601   /*Vejlby-Strib*/

replace nurse_date=date("1/1/1950", "MDY") if muni==120554
replace imputenurse=1 if muni==120554   /*Vojens*/

replace nurse_date=date("1/1/1964", "MDY") if muni==119886
replace imputenurse=1 if muni==119886   /*Års*/

replace nurse_date=date("1/1/1950", "MDY") if muni==119354
replace imputenurse=1 if muni==119354   /*Ørslev*/

drop muni


gen DOB_minusnurse = foed_dag - nurse_date

gen nurse_treat = (DOB_minusnurse>0) if DOB_minusnurse<.
*all individuals born after nurse program

replace nurse_treat = 0 if nurse_treat==.
*nurse date missing for munis without a program

foreach k in 20 25 30 35 40 45 50 {
ren year`k'_kid yrsschool`k'_kid
}

global kidedu university* higheredu* edu_unknown* morethanbasic* basic_edu* gymnasium* yrsschool*

encode Amtsnavn, gen(county)
ren Kommune_ID muni

************ Merge to municipality x year interpolated controls
merge m:1 muni year using "$work/munic_controls_recode_ipolated.dta", keep(match master)

drop _merge
*rescale so that they are within 0-100 range
foreach var of varlist $contrvars{
replace `var'=0 if `var'<0
replace `var'=100 if `var'>100
}
	

************************ Munis with ever open daycare
drop if year==.

bys muni: egen everopen = max(operating)


codebook muni if everopen==1
codebook muni if everopen==0

keep if everopen==1

***** label key treatment variables
label var numinstperpop "Num. centers per 1000 pop at age 3"
label var operating "Any Approved Childcare Center at Age 3"

**** interaction with nurse program
replace nurse_treat = 1 if nurse_treat>0
cap drop daycare_nurse
gen daycare_nurse = operating*nurse_treat

label var nurse_treat "NHV at Birth"
label var daycare_nurse "Childcare x NHV"


*** which municipalities ever have a nurse program
bys muni: egen ever_nurse = max(nurse_treat)


*** HELPNURSE SAMPLE: drop years after 1952 for the 28 munis that have worse program data (i.e. cohorts born after 1949)
gen helpnurse=1 if imputenurse==0
replace helpnurse=1 if imputenurse==1 & year<=1952


save "$work/indiv_kidsdata_maj2019.dta", replace


* collapse


*********************************************************************
********************************************************************
***************** COLLAPSE TO MUNI X YEAR LEVEL ********************
********************************************************************
********************************************************************

gen N=1
global kidedu university* higheredu* edu_unknown* basic_edu* morethanbasic* gymnasium* yrsschool*

**regress kid outcomes on mother's month of birth dummies
gen mob = month(foed_dag)
egen muni_yr = group(muni year)

foreach out of varlist $kidedu nights* ever*{
areg `out' i.mob  , abs(muni_yr)
predict `out'_res if e(sample)==1, d
ren `out' `out'_raw
ren `out'_res `out'
}

* for all women by municipality and year(age 3 exposure)
#delimit ;
collapse 
		(mean) county rural numinst numslots numinstperpop numslotsperpop  popmunic nurse_treat imputenurse  $kidedu nights* ever*
		(max) operating
		(count) N
		, by(muni year) fast;
#delimit cr


************ Merge to municipality x year interpolated controls


merge m:1 muni year using "$work/munic_controls_recode_ipolated.dta", keep(match master)

drop _merge

*rescale so that they are within 0-100 range
foreach var of varlist $contrvars{
replace `var'=0 if `var'<0
replace `var'=100 if `var'>100
}

*indicator for a balanced panel
bys muni: gen totyears = _N
gen balanced = totyears==23
**munis with balanced data in every year

***** exposure at ages 4-7
sort muni year
foreach var of varlist numinstperpop operating {
by muni: gen `var'_age4 = `var'[_n+1] if balanced==1
by muni: gen `var'_age5 = `var'[_n+2] if balanced==1
by muni: gen `var'_age6 = `var'[_n+3] if balanced==1
by muni: gen `var'_age7 = `var'[_n+4] if balanced==1
}

gen frac_operating = 0 if balanced==1
replace frac_operating = 1 if operating==1 & balanced==1
replace frac_operating = 4/5 if operating==0 & operating_age4==1
replace frac_operating = 3/5 if operating==0 & operating_age4==0 & operating_age5==1
replace frac_operating = 2/5 if operating==0 & operating_age4==0 & operating_age5==0 & operating_age6==1
replace frac_operating = 1/5 if operating==0 & operating_age4==0 & operating_age5==0 & operating_age6==0 & operating_age7==1

egen numinstperpop_age3_7 = rowmean(numinstperpop numinstperpop_age4 numinstperpop_age5 numinstperpop_age6 numinstperpop_age7)


**** interaction with nurse program
replace nurse_treat = 1 if nurse_treat>0
cap drop daycare_nurse
gen daycare_nurse = operating*nurse_treat

label var nurse_treat "NHV at Birth"
label var daycare_nurse "Preschool x NHV"


*** which municipalities ever have a nurse program
capture drop ever_nurse
bys muni: egen ever_nurse = max(nurse_treat)



sort muni year operating
by muni: gen afstyear = year if operating[_n]==1 & operating[_n-1]==0

bys muni: egen fstyear = mean(afstyear)



save "$work\analysis_daycare_intergen_everopen.dta", replace

/**** to merge to moms data for calculating intergenerational coef **/
preserve
keep muni year yrsschool25_kid morethanbasic25_kid
save "$work\tomerge_tomoms.dta", replace
restore

