clear all
close all

al =  1/3;

% load lognormal_B_bailout_cal_trans_smooth_201609
load lognormal_B_bailout_cal_trans_smooth_201902.mat

% load r_data_1.txt % Juanpa's series
% load r_data_2.txt % Ajello, Benzoni & Chyruk (2012)'s series
% tt=(2007.25:.25:2015)';
r_data_1=load('r_data_1_2006.txt'); % real realized series equaled to the 
% 3-Month Treasury Constant Maturity Rate minus the quarterly inflation in 
% the Personal Consumption Expenditures: Chain-type Price Index Less Food and Energy
r_data_2=load('r_data_2_2006.txt'); % Ajello, Benzoni & Chyruk (2012)'s series
R_data=load('R_data.txt'); % 3-Month Treasury Bill: Secondary Market Rate, Percent, Monthly, Not Seasonally Adjusted, FRED

T=length(r_data_1);

r_model=100*((1+r2(1:T-5)).^4-1);
r_model=[2*ones(5,1);r_model];

T=31;

R_bmk=((1+r2(2:T+1)).*p2(2:T+1)./p2(1:T)).^4-1;

tt=(2006:.25:2015)';

% This is Figure 1 in the paper

figure(1) 
% subplot(1,2,1),plot(tt,r_data_1,'--b',tt,r_data_2,':g',tt,r_model,'r','LineWidth',2)
subplot(2,2,1),plot(tt,r_data_2,'b--',tt,r_model,'r','LineWidth',2)
title('Real Interest Rate','FontSize',12,'Interpreter','latex')
LEG=legend('data','model')
set(LEG,'FontSize',12)
set(LEG,'Interpreter','latex');
legend boxoff
set(gca,'FontSize',12)
axis([tt(1) tt(end) -3 4])
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,2),plot(tt,R_data,'--b',tt,[4*ones(6,1);100*R_bmk],'r','LineWidth',2)
title('Nominal Interest Rate','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
axis([tt(1) tt(end) -3 5])
set(gca,'TickLabelInterpreter','latex')


debt_GDP=load('debt_GDP_2006.txt');
subplot(2,2,3),plot(tt,debt_GDP,'b--',tt,debt_GDP+.005,'r','LineWidth',2)
title('Gov. Liabilities/GDP','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
axis([tt(1) tt(end) .5 1.2])
set(gca,'TickLabelInterpreter','latex')

T=length(r_data_1);

subplot(2,2,4)
plot(tt,[.69*ones(5,1);(1-1./la_hist(1:T-5))],'r','LineWidth',2)
title('Evolution of $\theta_t$','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
axis([tt(1) tt(end) .4 .7])
set(gca,'TickLabelInterpreter','latex')

set(gcf, 'PaperPosition', [0 0 6 4]); %Position plot at left hand corner with width 5 and height 5.
set(gcf, 'PaperSize', [6 4]); %Set the paper to have width 5 and height 5.

T=31;

R_bmk=((1+r2(2:T+1)).*p2(2:T+1)./p2(1:T)).^4-1;
GDP_bmk=log(Y2(1:T))-log(Y2(1));
TFP_bmk=log(Z2(1:T))-log(Z2(1));
K_bmk=log(K2(1:T))-log(K2(1));
inf_bmk=(p2(2:T+1)./p2(1:T)).^4-1;
r_bmk=(1+r2(1:T)).^4-1;
w2=(1-al)*Z2.*K2.^al;
w_bmk=log(w2(1:T))-log(w2(1));
B_bmk=B2(1:T)./(4*Y2(1:T));
la_bmk=la_hist;
credit_gr_bmk=log((1-1./la_bmk(1:37-5)).*K2(1:37-5))-[log((1-1./la_bmk(1)).*K2(1)) ...
    ;log((1-1./la_bmk(1:37-5-1)).*K2(1:37-5-1))];
credit_gr_bmk=[zeros(5,1);credit_gr_bmk];

tt=(2007.5:.25:2015)';

% This is Figure 2 in the paper

figure(2)

subplot(2,2,1),plot(tt,GDP_bmk,'b','LineWidth',2)
title('GDP','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.075 0])
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,2),plot(tt,TFP_bmk,'b','LineWidth',2)
title('TFP','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.075 0])
set(gca,'TickLabelInterpreter','latex')


subplot(2,2,3),plot(tt,K_bmk,'b','LineWidth',2)
title('Capital Stock','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.075 0.0])
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,4),plot(tt,w_bmk,'b','LineWidth',2)
title('Wage','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.075 0.0])
set(gca,'TickLabelInterpreter','latex')

set(gcf, 'PaperPosition', [0 0 6 4]); %Position plot at left hand corner with width 5 and height 5.
set(gcf, 'PaperSize', [6 4]); %Set the paper to have width 5 and height 5.
% saveas(gcf, 'fig_bmk', 'pdf') %Save figure


load lognormal_B_bailout_00_smooth_201902.mat Y2 Z2 K2 B2 r2 w2 zlow2 Tax2

Y_000=log(Y2(1:T)/Y2(1));
TFP_000=log(Z2(1:T)/Z2(1));
K_000=log(K2(1:T)/K2(1));
B_000=B2(1:T)./(4*Y2(1:T));
r_000=(1+r2(1:T)).^4-1;

load lognormal_B_bailout_0075_smooth_201902.mat Y2 Z2 K2 B2 r2 w2 zlow2 Tax2

Y_0075=log(Y2(1:T)/Y2(1));
TFP_0075=log(Z2(1:T)/Z2(1));
K_0075=log(K2(1:T)/K2(1));
B_0075=B2(1:T)./(4*Y2(1:T));
r_0075=(1+r2(1:T)).^4-1;

load lognormal_B_lumpsum_bmk_smooth_201902

GDP_lumpsum=log(Y2(1:T))-log(Y2(1));
TFP_lumpsum=log(Z2(1:T))-log(Z2(1));
K_lumpsum=log(K2(1:T))-log(K2(1));
B_lumpsum=B2(1:T)./(4*Y2(1:T));
r_lumpsum=(1+r2(1:T)).^4-1;

% This is Figure 3 in the paper

figure(3)
subplot(2,2,1),plot(tt,Y_000-GDP_bmk,'b' ...
,tt,Y_0075-GDP_bmk,'r--',tt,GDP_lumpsum-GDP_bmk,'g:','LineWidth',2)
axis([tt(1) tt(end) -.01 0.01])
title('GDP','Interpreter','latex')
% legend('\pi=0.00','\pi=0.03','lump-sum' ...
%     ,'Location','NorthEast')
% leg1 = legend('$\underline r = \ \ 0.00$','$\underline r = -0.03$','lump-sum');
leg1 = legend('$\pi=0.00$','$\pi=0.03$','lump sum' ...
    ,'Location','NorthEast')

set(leg1,'Interpreter','latex');
set(leg1,'Location','NorthEast');
set(gca,'FontSize',12)
legend boxoff
set(gca,'FontSize',12)
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,2),plot(tt,TFP_000-TFP_bmk,'b' ...
,tt,TFP_0075-TFP_bmk,'r--',tt,TFP_lumpsum-TFP_bmk,'g:','LineWidth',2)
axis([tt(1) tt(end) -.01 0.01])
title('TFP','Interpreter','latex')
set(gca,'FontSize',12)
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,3),plot(tt,K_000-K_bmk,'b',tt,K_0075-K_bmk,'r--' ...
    ,tt,K_lumpsum-K_bmk,'g:','LineWidth',2)
axis([tt(1) tt(end) -.05 0.05])
title('Capital Stock','Interpreter','latex')
set(gca,'FontSize',12)
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,4),plot(tt,log(B_000)-log(B_bmk),'b',tt,log(B_0075)-log(B_bmk),'r--' ...
    ,tt,log(B_lumpsum)-log(B_bmk),'g:','LineWidth',2)
axis([tt(1) tt(end) -1 1])
title('Government Debt/GDP','Interpreter','latex')
set(gca,'FontSize',12)
set(gca,'TickLabelInterpreter','latex')

set(gcf, 'PaperPosition', [0 0 6 4]); %Position plot at left hand corner with width 5 and height 5.
set(gcf, 'PaperSize', [6 4]); %Set the paper to have width 5 and height 5.

load lognormal_B_bailout_cal_trans_smooth_nu_0_201902.mat

R_bmk_nu_0=((1+r2(2:T+1)).*p2(2:T+1)./p2(1:T)).^4-1;
GDP_bmk_nu_0=log(Y2(1:T))-log(Y2(1));
TFP_bmk_nu_0=log(Z2(1:T))-log(Z2(1));
K_bmk_nu_0=log(K2(1:T))-log(K2(1));
inf_bmk_nu_0=(p2(2:T+1)./p2(1:T)).^4-1;
r_bmk_nu_0=(1+r2(1:T)).^4-1;
w2=(1-al)*Z2.*K2.^al;
w_bmk_nu_0=log(w2(1:T))-log(w2(1));
B_bmk_nu_0=B2(1:T)./(4*Y2(1:T));
p_bmk_nu_0=log(p2(1:T));

load lognormal_B0_nu0_201609.mat

load lognormal_B_fixed_M_nominal_smooth_201902.mat

GDP_indexed=log(Y1(1:T))-log(Y1(1));
TFP_indexed=log(Z1(1:T))-log(Z1(1));
K_indexed=log(K1(1:T))-log(K1(1));
p_indexed=log(p1(1:T));
L_indexed=zeros(T,1);
w_indexed=log(w1(1:T)/w1(1));
r_indexed=(1+r1(1:T)).^4-1;
B_indexed=B0./(4*Y1(1:T));
R_indexed=((1+r1(2:T+1)).*p1(2:T+1)./p1(1:T)).^4-1;

GDP_nom=log(Y2(1:T))-log(Y1(1));
TFP_nom=log(Z2(1:T))-log(Z1(1));
K_nom=log(K2(1:T))-log(K2(1));
p_nom=log(p2(1:T));
L_nom=zeros(T,1);
w_nom=log(w2(1:T)/w2(1));
r_nom=(1+r2(1:T)).^4-1;
R_nom=((1+r2(2:T+1)).*p2(2:T+1)./p2(1:T)).^4-1;

% This is Figure 4 in the paper

figure(4)
subplot(1,2,1),plot(tt,r_bmk_nu_0,'b',tt,r_indexed,'g:',tt,r_nom,'r--','LineWidth',2)
axis([tt(1) tt(end) -.05 0.03])
title('Real Interest Rate','FontSize',12,'Interpreter','latex')
LEG=legend('bmk','ind. debt','nom. debt','Location','NorthEast');
set(LEG,'Interpreter','latex');
legend boxoff
set(LEG,'FontSize',12)
set(gca,'FontSize',12)
set(gca,'TickLabelInterpreter','latex')

subplot(1,2,2),plot(tt,w_bmk_nu_0,'b',tt,w_indexed,'g:',tt,w_nom,'r--','LineWidth',2)
axis([tt(1) tt(end) -.15 0.01])
title('Real Wage','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
set(gca,'TickLabelInterpreter','latex')

set(gcf, 'PaperPosition', [0 0 6 2.5]); %Position plot at left hand corner with width 5 and height 5.
set(gcf, 'PaperSize', [6 2.5]); %Set the paper to have width 5 and height 5.

% This is Figure 5 in the paper

figure(5)

subplot(2,2,1),plot(tt,GDP_bmk_nu_0,tt,GDP_indexed,'g:',tt,GDP_nom,'r--' ...
   ,'LineWidth',2)
axis([tt(1) tt(end) -.15 0.05])
title('GDP','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
LEG=legend('bmk','ind. debt','nom. debt','Location','NorthEast');
legend boxoff
set(LEG,'FontSize',12)
set(LEG,'Interpreter','latex');
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,2),plot(tt,TFP_bmk_nu_0,tt,TFP_indexed,'g:',tt,TFP_nom,'r--' ...
   ,'LineWidth',2)
axis([tt(1) tt(end) -.15 0.025])
title('TFP','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
set(LEG,'Interpreter','latex');
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,3),plot(tt,K_bmk_nu_0,tt,K_indexed,'g:',tt,K_nom,'r--' ...
   ,'LineWidth',2)
axis([tt(1) tt(end) -.1 0.025])
title('Capital Stock','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
set(LEG,'Interpreter','latex');
set(gca,'TickLabelInterpreter','latex')

subplot(2,2,4),plot(tt,p_bmk_nu_0,tt,p_indexed,'g:',tt,p_nom,'r--' ...
   ,'LineWidth',2)
axis([tt(1) tt(end) -.3 0.2])
title('Price Level','FontSize',12,'Interpreter','latex')
set(gca,'FontSize',12)
set(gca,'TickLabelInterpreter','latex')

set(gcf, 'PaperPosition', [0 0 6 4]); %Position plot at left hand corner with width 5 and height 5.
set(gcf, 'PaperSize', [6 4]); %Set the paper to have width 5 and height 5.


% Additional figures from the Online Appendix and beyond.


bt=0.9865; % th=0.69
N=100;
zmax=10;
z(:,1)=linspace(0,zmax,N)';
Pz=[0; logncdf(z(2:end),0,1)/logncdf(zmax,0,1)];

load welfare2_bmk.mat
wc_bmk=exp((U-U0)*(1-bt));
wcW_bmk=exp((UW-UW0)*(1-bt));
load welfare2_00.mat
wc_00=exp((U-U0)*(1-bt));
wcW_00=exp((UW-UW0)*(1-bt));
load welfare2_0075.mat
wc_0075=exp((U-U0)*(1-bt));
wcW_0075=exp((UW-UW0)*(1-bt));

% This is Figure A.1 in the Online Appendix

figure(6)
plot(Pz,wc_bmk-1,'b',Pz,wc_00-1,'r--',Pz,wc_0075-1,'g:','LineWidth',2)
line([.8 1],[0 0],'LineStyle','-','Color','k')
axis([.8 1 -.3 1.6])
legend('bmk','\pi = 0.00','\pi = 0.03','Location','NorthWest')
legend boxoff
xlabel('ability percentile','FontSize',16)
ylabel('fraction of consumption','FontSize',16)
set(gca,'FontSize',16)
set(gcf, 'PaperPosition', [0 0 7 5]); %Position plot at left hand corner with width 5 and height 5.
set(gcf, 'PaperSize', [7 5]); %Set the paper to have width 5 and height 5.

disp('welfare of workers')
disp(['bmk, wg^W = ' num2str(wcW_bmk-1,1) ', \pi = 0.00, wg^W = ' num2str(wcW_00-1,1) ', \pi = 0.03, wg^W = ' num2str(wcW_0075-1,1)])

load lognormal_B_bailout_cal_trans_sensitivity_th_059.mat
la_059=la_hist;
GDP_059=log(Y2(1:T))-log(Y2(1));
TFP_059=log(Z2(1:T))-log(Z2(1));
K_059=log(K2(1:T))-log(K2(1));
credit_gr_059=log((1-1./la_059(1:37-5)).*K2(1:37-5))-[log((1-1./la_059(1)).*K2(1)) ...
    ;log((1-1./la_059(1:37-5-1)).*K2(1:37-5-1))];
credit_gr_059=[zeros(5,1);credit_gr_059];

load lognormal_B_bailout_cal_trans_sensitivity_th_079.mat
la_079=la_hist;
GDP_079=log(Y2(1:T))-log(Y2(1));
TFP_079=log(Z2(1:T))-log(Z2(1));
K_079=log(K2(1:T))-log(K2(1));
credit_gr_079=log((1-1./la_079(1:37-5)).*K2(1:37-5))-[log((1-1./la_079(1)).*K2(1)) ...
    ;log((1-1./la_079(1:37-5-1)).*K2(1:37-5-1))];
credit_gr_079=[zeros(5,1);credit_gr_079];

% This is Figure A.2 in the Online Appendix

figure(7)
subplot(2,2,1),plot(tt,GDP_bmk,'b',tt,GDP_059,'--g',tt,GDP_079,':r','LineWidth',2)
title('GDP','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0])
legend('bmk, \theta = 0.69','\theta = 0.59','\theta = 0.79')
legend boxoff
subplot(2,2,2),plot(tt,TFP_bmk,'b',tt,TFP_059,'--g',tt,TFP_079,':r','LineWidth',2)
title('TFP','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0])
subplot(2,2,3),plot(tt,K_bmk,'b',tt,K_059,'--g',tt,K_079,':r','LineWidth',2)
title('capital','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0])
% subplot(2,2,4),plot(tt,1-1./la_bmk(1:T),'b',tt,1-1./la_059(1:T),'--g',tt,1-1./la_079(1:T),':r','LineWidth',2)
% title('\theta','FontSize',12)
% axis([tt(1) tt(end) 0 1])
tt=(2006:.25:2015)';
subplot(2,2,4),plot(tt,credit_gr_bmk,'b',tt,credit_gr_059,'--g',tt,credit_gr_079,':r','LineWidth',2)
title('credit growth','FontSize',12)
axis([tt(1) tt(end) -.05 .01])
set(gca,'FontSize',12)

load lognormal_B_bailout_cal_trans_smooth_201902.mat
T=71;
la_bmk=la_hist;
GDP_bmk=log(Y2(1:T))-log(Y2(1));
TFP_bmk=log(Z2(1:T))-log(Z2(1));
K_bmk=log(K2(1:T))-log(K2(1));
L_bmk=zeros(T,1);
B_bmk=B2(1:T)./(4*Y2(1:T));
r_bmk=r2(1:T);
Tax_bmk=Tax2(1:T);

load lognormal_B_bailout_cal_trans_smooth_lafixed_201609.mat
la_lafixed=la_hist;
GDP_lafixed=log(Y2(1:T))-log(Y2(1));
TFP_lafixed=log(Z2(1:T))-log(Z2(1));
K_lafixed=log(K2(1:T))-log(K2(1));
r_lafixed=r2(1:T);
Tax_lafixed=Tax2(1:T);

tt=(2007.5:.25:2025)';

% This is Figure A.3 in the Online Appendix

figure(8)
subplot(2,2,1),plot(tt,GDP_bmk,'b',tt,GDP_lafixed,'--r','LineWidth',2)
title('GDP','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0.02])
legend('\rho=0.95 (bmk)','\rho=1.00','Location','SouthWest')
legend boxoff
subplot(2,2,2),plot(tt,TFP_bmk,'b',tt,TFP_lafixed,'--r','LineWidth',2)
title('TFP','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0.02])
subplot(2,2,3),plot(tt,K_bmk,'b',tt,K_lafixed,'--r','LineWidth',2)
title('capital','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.15 0.02])

subplot(2,2,4),plot(tt,1-1./la_bmk(1:T),'b',tt,1-1./la_lafixed(1:T),'--r','LineWidth',2)
title('Colateral constraint, \theta','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) 0.4 .8])

load lognormal_B_bailout_cal_trans_smooth_201902.mat
T=31;

R_bmk=((1+r2(2:T+1)).*p2(2:T+1)./p2(1:T)).^4-1;
GDP_bmk=log(Y2(1:T))-log(Y2(1));
TFP_bmk=log(Z2(1:T))-log(Z2(1));
K_bmk=log(K2(1:T))-log(K2(1));
inf_bmk=(p2(2:T+1)./p2(1:T)).^4-1;
r_bmk=(1+r2(1:T)).^4-1;
w2=(1-al)*Z2.*K2.^al;
w_bmk=log(w2(1:T))-log(w2(1));
B_bmk=B2(1:T)./(4*Y2(1:T));

load lognormal_B_bailout_cal_trans_smooth_201609_alt_Bt.mat
la_alt_Bt=la_hist;
GDP_alt_Bt=log(Y2(1:T))-log(Y2(1));
TFP_alt_Bt=log(Z2(1:T))-log(Z2(1));
K_alt_Bt=log(K2(1:T))-log(K2(1));
L_alt_Bt=zeros(T,1);
B_alt_Bt=B2(1:T)./(4*Y2(1:T));
r_alt_Bt=r2(1:T);
Tax_alt_Bt=Tax2(1:T);

tt=(2007.5:.25:2015)';

% This is Figure A.4 in the Online Appendix

figure(9)
subplot(2,2,1),plot(tt,GDP_bmk,'b',tt,GDP_alt_Bt,'--r','LineWidth',2)
title('GDP','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0.02])
legend('bmk','only treasury debt','Location','SouthWest')
legend boxoff
subplot(2,2,2),plot(tt,TFP_bmk,'b',tt,TFP_alt_Bt,'--r','LineWidth',2)
title('TFP','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0.02])
subplot(2,2,3),plot(tt,K_bmk,'b',tt,K_alt_Bt,'--r','LineWidth',2)
title('capital','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) -.1 0.02])
subplot(2,2,4),plot(tt,B_bmk,'b',tt,B_alt_Bt,'--r','LineWidth',2)
title('Govt. Debt to GDP','FontSize',12)
set(gca,'FontSize',12)
axis([tt(1) tt(end) 0.5 1.5])


