function [binary_prod_t, config_binary_t, ...
    full_prod_t, config_full_t, fixed_prod_t] = merger_change_brand(...
    t, binary_prod_t, config_binary_t, full_prod_t, config_full_t, ...
    brand_option, merge_id, para_linear_est, dim_demand_brandtime,...
    mc_param, dim_mc_brand, key_oem_ind, fixed_prod_t)


n_merge = length(merge_id);

if n_merge>0
    para_linear_est = para_linear_est';
    mc_param = mc_param';
    
    % brand effect
    demand_brandtime_coeff = para_linear_est(dim_demand_brandtime);
    mc_brand_coeff = mc_param(dim_mc_brand);
    
    demand_brand_coeff_merge = nan(n_merge, 1);
    mc_brand_coeff_merge = nan(n_merge, 1);
    
    for nm = 1 : n_merge
        if ismember(merge_id(nm), key_oem_ind)
            demand_brand_coeff_merge(nm) = demand_brandtime_coeff(key_oem_ind==merge_id(nm));
            mc_brand_coeff_merge(nm) = mc_brand_coeff(key_oem_ind==merge_id(nm));
        else
            demand_brand_coeff_merge(nm) = 0;
            mc_brand_coeff_merge(nm) = 0;
        end
    end
    
    for nm = 1 : n_merge
        n_prod_no = length(binary_prod_t{merge_id(nm)});
        for npo = 1 : n_prod_no
            % mean utility and brand effect
            if isequal(brand_option.utility, 'average')
                mean_demand_brand_coeff = mean(demand_brand_coeff_merge);
                binary_prod_t{merge_id(nm)}{npo}.mean_u = ...
                    binary_prod_t{merge_id(nm)}{npo}.mean_u - ...
                    demand_brand_coeff_merge(nm) + mean_demand_brand_coeff;

                binary_prod_t{merge_id(nm)}{npo}.brandeffect = ...
                    mean_demand_brand_coeff/para_linear_est(1);
            elseif ~isequal(brand_option.utility, 'pre-merger')
                error('unknown post merger brand option');
            end

            % marginal cost
            if isequal(brand_option.mc, 'average')
                mean_mc_brand_coeff = mean(mc_brand_coeff_merge);        
                binary_prod_t{merge_id(nm)}{npo}.mean_mc = ...
                    binary_prod_t{merge_id(nm)}{npo}.mean_mc - ...
                    mc_brand_coeff_merge(nm) + mean_mc_brand_coeff;
            elseif ~isequal(brand_option.mc, 'pre-merger')
                error('unknown post merger brand option');                
            end
            
        end

        % fixed product
        ind_nm = fixed_prod_t.oem(:, merge_id(nm));

        if isequal(brand_option.utility, 'average')
            fixed_prod_t.mean_demand(ind_nm) = ...
                fixed_prod_t.mean_demand(ind_nm) - ...
                demand_brand_coeff_merge(nm) + mean_demand_brand_coeff;
            fixed_prod_t.brandeffect(ind_nm) = ...
                mean_demand_brand_coeff/para_linear_est(1);
        elseif ~isequal(brand_option.utility, 'pre-merger')
            error('unknown post merger brand option');                
        end

        if isequal(brand_option.mc, 'average')
            fixed_prod_t.mean_mc(ind_nm) = ...
                fixed_prod_t.mean_demand(ind_nm) - ...
                mc_brand_coeff_merge(nm) + mean_mc_brand_coeff;
        end

        full_prod_t{merge_id(nm)} = [];
        config_full_t{merge_id(nm)} = [];
    end
    
end

