function [stderr, para_mean_chara, stderr_nonlinear_q, stderr_q] = gmm_std_err_smartphone(para_nonlinear_est,...
    share, x_rand, x_det, ind_mkt_start,ind_mkt_end, randomdraw, IV, W,...
    setup, n_oem, n_carrier, n_mkt, carrier_ind, oem_ind,...
    meanutility00, para_linear_est,...
    pfid)

spacing = 1e-4;
n_para_nonlinear = length(para_nonlinear_est);

% calculate the derivative of the objective function with respect to nonlinear parameters
setup.no_transformation_of_para = false;
[~, ~, g_obs0, para_linear_tmp,~,~,~,~,~,~,~,x_det_for_est] = gmmobj_BLP_smartphone(para_nonlinear_est, share, x_rand, x_det, ind_mkt_start,ind_mkt_end, randomdraw, IV, W, setup, n_oem, n_carrier, n_mkt, carrier_ind, oem_ind, meanutility00, para_linear_est);
if ~isequal(para_linear_tmp, para_linear_est); error('para_linear recalculated it not consistent with para_linear_est'); end;
Om = g_obs0'*g_obs0/size(g_obs0,1);
n_mo = size(Om, 1);
G = nan(n_mo, n_para_nonlinear);

[para_sigma, para_quality_coeff, dim_para_sigma] = ...
    paravec2para_smartphone(para_nonlinear_est, setup, x_rand);

setup.no_transformation_of_para = true;
para_nonlinear_est_transformed = para_nonlinear_est;

tmp = para_nonlinear_est_transformed(dim_para_sigma);
para_nonlinear_est_transformed(dim_para_sigma) = exp(tmp);

for i = 1 : length(para_nonlinear_est)
    para_nonlinear_tmp = para_nonlinear_est_transformed;    
    para_nonlinear_tmp(i) = para_nonlinear_tmp(i) + spacing;
    
    try
        [~, ~, g_obs1] = gmmobj_BLP_smartphone(para_nonlinear_tmp, share, x_rand, x_det, ind_mkt_start,ind_mkt_end, randomdraw, IV, W, setup, n_oem, n_carrier, n_mkt, carrier_ind, oem_ind, [], para_linear_est);
        G(:, i) = mean((g_obs1 - g_obs0)/spacing, 1)';
    catch err
        fprintf(pfid, 'error message = %s\n', err.message);
        for ii = 1:length(err.stack)
            fprintf(pfid, '%s, Line %1.0f\n', err.stack(ii).file, err.stack(ii).line);
        end
        
        para_nonlinear_tmp = para_nonlinear_est_transformed;    
        para_nonlinear_tmp(i) = para_nonlinear_tmp(i) - spacing;
        [~, ~, g_obs1] = gmmobj_BLP_smartphone(para_nonlinear_tmp, share, x_rand, x_det, ind_mkt_start,ind_mkt_end, randomdraw, IV, W, setup, n_oem, n_carrier, n_mkt, carrier_ind, oem_ind, [], para_linear_est);
        G(:, i) = mean((g_obs0 - g_obs1)/spacing, 1)';
    end
end
% concatenate the above derivative w/ that wrt the linear parameters
n_obs = size(x_det_for_est,1);
G = [G, -IV'*x_det_for_est/n_obs];

% stderr
sig_para = inv(G'*W*G)*(G'*W*Om*W*G)*inv(G'*W*G)/size(x_det_for_est,1);

stderr = sqrt(diag(sig_para));

% interaction of beta_quality*beta(nonlinear)
n_para_quality = length(para_quality_coeff);
stderr_nonlinear_q = nan(n_para_quality, 1);
v1 = para_linear_est(1);
ind_v1 = n_para_nonlinear+1;
for np = 1 : n_para_quality
    v2 = para_nonlinear_est_transformed(np);
    ind_v2 = np;
    sig_para_q = sig_para([ind_v1, ind_v2], [ind_v1, ind_v2]);
    tmp_v = [v2, v1];
    stderr_nonlinear_q(np) = sqrt(diag(tmp_v*sig_para_q*tmp_v'));    
end

para_mean_chara = v1*para_nonlinear_est_transformed(1:n_para_quality);

stderr_q = zeros(n_obs, 1);
ind1 = setup.dim_quality_in_x_det;
sig_para_q = sig_para(ind1(2:end), :);
sig_para_q = sig_para_q(:, ind1(2:end));
quality_x = x_det(:, ind1(2:end));
for n_o = 1 : n_obs
    stderr_q(n_o) = quality_x(n_o, :)*sig_para_q*quality_x(n_o, :)';    
end

fprintf(setup.pfid, 'para_nonlinear\n');
for i = 1:length(para_nonlinear_est)
    fprintf(setup.pfid, '%1.4e %1.4e\n', [para_nonlinear_est(i), stderr(i)]);
end
m = length(para_nonlinear_est);
fprintf(setup.pfid, 'para_linear\n');
for i = 1:length(para_linear_est)
    fprintf(setup.pfid, '%1.4e %1.4e %1.4e\n', [para_linear_est(i), stderr(i+m), para_linear_est(i)/stderr(i+m)]);
end


