clear; clc; clear global; if ispc; dbstop if error; end;

% load the estimation file
filename_estresult = 'part2_demand_mc_est.mat';
load(filename_estresult);

pfid = 1;

%% Table 1. summary statistics table
outputvar = {'quantity', 'nominal_retail_price', 'batterytalktime', 'camres', 'generation_dummies', 'screensize','weight'};
outputvar_name = outputvar;
outputvar_scale = ones(1, length(outputvar));
outputvar_dim = nan(1, length(outputvar));

n_var = length(outputvar);

fprintf(pfid, '\n Table: Summary Statistics\n');
fprintf(pfid, '%4s\t%4s\t%4s\t%4s\t%4s\n', ' ', 'mean', 'std','min','max');
for i = 1:n_var
    if isequal(outputvar{i}, 'quantity')
        outputvar_name{i} = 'Quantity (1000)';
    elseif isequal(outputvar{i}, 'nominal_retail_price')
        outputvar_name{i} = 'Price ($)';
    elseif isequal(outputvar{i}, 'stocost')
        outputvar_name{i} = 'Wholesale Price ($)';
        outputvar_scale(i) = normalization_price;
    elseif isequal(outputvar{i}, 'batterytalktime')
        outputvar_name{i} = 'Battery talk time (hour)';
        outputvar_scale(i) = 10;
    elseif isequal(outputvar{i}, 'camres')
        outputvar_name{i} = 'Camera resolution (megapixel)';
        outputvar_scale(i) = 10;
    elseif isequal(outputvar{i}, 'screensize')
        outputvar_name{i} = 'Screen size (inch)';
    elseif isequal(outputvar(i), {'isflagship'})
        outputvar_name{i} = 'Flagship?';
    elseif isequal(outputvar(i), {'generation_dummies'})
        outputvar_name{i} = 'Chipset generation';
    elseif ismember(outputvar(i), {'isflagship','brandtime_dummies'})
        outputvar_name{i} = outputvar{i};
    elseif isequal(outputvar(i), {'weight'})
        outputvar_name{i} = 'Weight (gram)';
        outputvar_scale(i) = 100;
    else
        error('scale and variable name to be written');
    end
    eval(['tmp = ' outputvar{i}  '*outputvar_scale(i);']);
    outputvar_dim(i) = size(tmp, 2);
    
    for j = 1:outputvar_dim(i)
        if isequal(outputvar(i), {'generation_dummies'})
            fprintf(pfid, '%20s %1.0f\t%2.2f\t%1.2f\t%1.2f\t%1.2f\n', outputvar_name{i}, j+1, mean(tmp(:,j)), std(tmp(:,j)), min(tmp(:,j)), max(tmp(:,j)));
        else
            fprintf(pfid, '%20s\t%2.2f\t%1.2f\t%1.2f\t%1.2f\n', outputvar_name{i}, mean(tmp(:,j)), std(tmp(:,j)), min(tmp(:,j)), max(tmp(:,j)));
        end                
    end
end
fprintf(pfid, 'Obs\t%1.0f\n', length(price));
fprintf(pfid, 'FOOTNOTE: One product in our sample (BlackBerry 8830) does not have a camera.\n');

%% Table 1: cross-carrier variation
outputvar = {'quantity', 'nominal_retail_price', 'batterytalktime', 'camres', 'generation_dummies', 'screensize','weight'};
outputvar_name = outputvar;
outputvar_scale = ones(1, length(outputvar));
outputvar_dim = nan(1, length(outputvar));

n_var = length(outputvar);

fprintf(pfid, ['\n Table: Cross-Time Variation\n']);
fprintf(pfid, '%4s\t%4s\t%4s\t%4s\t%4s\n', ' ', 'mean', 'min','max', 'median');

for i = 1:n_var
    if isequal(outputvar{i}, 'quantity')
        outputvar_name{i} = 'Quantity (1000)';
    elseif isequal(outputvar{i}, 'nominal_retail_price')
        outputvar_name{i} = 'Price ($)';
    elseif isequal(outputvar{i}, 'stocost')
        outputvar_name{i} = 'Wholesale Price ($)';
        outputvar_scale(i) = normalization_price;
    elseif isequal(outputvar{i}, 'batterytalktime')
        outputvar_name{i} = 'Battery talk time (hour)';
        outputvar_scale(i) = 10;
    elseif isequal(outputvar{i}, 'camres')
        outputvar_name{i} = 'Camera resolution (megapixel)';
        outputvar_scale(i) = 10;
    elseif isequal(outputvar{i}, 'screensize')
        outputvar_name{i} = 'Screen size (inch)';
    elseif isequal(outputvar(i), {'isflagship'})
        outputvar_name{i} = 'Flagship?';
    elseif isequal(outputvar(i), {'generation_dummies'})
        outputvar_name{i} = 'Chipset generation';
    elseif ismember(outputvar(i), {'isflagship','brandtime_dummies'})
        outputvar_name{i} = outputvar{i};
    elseif isequal(outputvar(i), {'weight'})
        outputvar_name{i} = 'Weight (gram)';
        outputvar_scale(i) = 100;
    else
        error('scale and variable name to be written');
    end
    eval(['tmp = ' outputvar{i}  '*outputvar_scale(i);']);
    outputvar_dim(i) = size(tmp, 2);
    
 
    for j = 1:outputvar_dim(i)
        dT = nan(n_mkt, 4);
        
        for t = 1 : n_mkt            
            
            ind_t = time==t;
            
            
            dT(t, 1) = mean(tmp(ind_t, j));
            dT(t, 2) = min(tmp(ind_t, j));
            dT(t, 3) = max(tmp(ind_t, j));
            dT(t, 4) = median(tmp(ind_t, j));
            
            for kk = 1 : size(dT, 2)
                dT(t, kk) = std(dT(:, kk), 'omitnan');
            end
            
        end
        
        if isequal(outputvar(i), {'generation_dummies'})
            fprintf(pfid, '%20s %1.0f\t%2.2f\t%1.2f\t%1.2f\t%1.2f\n', outputvar_name{i}, j+1, std(dT(:, 1)), std(dT(:, 2)), std(dT(:, 3)), std(dT(:, 4)));
        else
            fprintf(pfid, '%20s\t%2.2f\t%1.2f\t%1.2f\t%1.2f\n', outputvar_name{i}, std(dT(:, 1)), std(dT(:, 2)), std(dT(:, 3)), std(dT(:, 4)));
        end
    end
    
    
end

%% Table 2. Top 6 manufactureres
fprintf(pfid, '\n Table: List of Top Six Manufacturers\n');

if isequal(data_frequency, 'quarterly')
    fprintf(pfid, '%5s\t%5s\t%5s\t%5s\t%5s\t%5s\n', 'Manufacturer','Headquarters','Avg. Number','Avg. Number','Avg. Price', 'Avg. Quarterly Sales');
    fprintf(pfid, '\t\t%5s\t%5s\t%5s\t%5s\n', 'of Products','of Smartphones','($)','(million)');
elseif isequal(data_frequency, 'monthly')
    fprintf(pfid, '%5s\t%5s\t%5s\t%5s\t%5s\t%5s\n', 'Manufacturer','Headquarters','Avg. Number','Avg. Number','Avg. Price', 'Avg. Monthly Sales');
    fprintf(pfid, '\t\t%5s\t%5s\t%5s\t%5s\n', 'of Products','of Smartphones','($)','(million)');
end
topoem = {'Apple', 'Samsung', 'BlackBerry', 'HTC', 'Motorola', 'LG'};
hq = {'US', 'Korea', 'Canada', 'Taiwan', 'US', 'Korea'};

n_topoem = length(topoem);
anq = nan(n_topoem, n_mkt); % number of smartphone/carriers
anq2 = nan(n_topoem, n_mkt); % number of smartphones
arp = nan(n_topoem, 1); % average price (averaged across smartphone/carriers within a firm/month)
aqs = nan(n_topoem, n_mkt); % total monthly sales

for i = 1 : n_topoem
    ind_oem = ismember(oem, topoem{i});
    for t = 1 : n_mkt
        ind_t = setup.mktid==t;
        tmpind = ind_oem&ind_t;
        if any(tmpind)
            anq(i,t) = nnz(tmpind);
            anq2(i,t) = length(unique(model_clean(tmpind)));
            aqs(i,t) = sum(quantity(tmpind));
        end
    end
    
    ttsales = sum(quantity(ind_oem));
    arp(i) = sum((quantity(ind_oem)/ttsales).*price(ind_oem));
end
anq = nanmean(anq, 2);
anq2 = nanmean(anq2, 2);
aqs = nanmean(aqs, 2);
arp = arp*100;
for i = 1: n_topoem
    fprintf(pfid, '%10s\t%10s\t%1.2f\t%1.2f\t%4.2f\t%1.2f\n', topoem{i}, hq{i}, anq(i), anq2(i), arp(i), aqs(i)/1000);
end


%% Table 3. summary statistics on quality and price dispersion within a manufacturer/period
outputvar2 = outputvar;
outputvar_name2 = outputvar_name;
outputvar_scale2 = outputvar_scale;
outputvar_dim2 = outputvar_dim;

ind = ismember(outputvar2, {'generation_dummies'});
outputvar2(ind) = {'generation'};
outpuvar_name2(ind) = {'Generation'};
outputvar_scale2(ind) = 1;
outputvar_dim2(ind) = 1;

ind = ismember(outputvar2, {'brandtime_dummies'});
outputvar2(ind) = [];
outputvar_name2(ind) = [];
outputvar_scale2(ind) = [];
outputvar_dim2(ind) = [];


all_oem = unique(oem);
n_all_oem = length(all_oem);

stdq = nan(sum(outputvar_dim2), n_all_oem*n_mkt);
HLq = stdq;
HH2q = stdq;
std_of_mean = stdq;
kk = 0;

n_carrier = 4;

for i = 1 : length(outputvar2)
    eval(['tmp = ' outputvar2{i}  '*outputvar_scale2(i);']);
    
    stdq_oem_mkt = nan(outputvar_dim2(i), n_all_oem, n_mkt); % std dev
    HLq_oem_mkt = nan(outputvar_dim2(i), n_all_oem, n_mkt); % range = highest - lowest
    HH2q_oem_mkt = nan(outputvar_dim2(i), n_all_oem, n_mkt); % highest - 2nd highest
    meanq_oem_mkt_carrier = nan(outputvar_dim2(i), n_all_oem, n_mkt, n_carrier);
    
    for no = 1 : n_all_oem
        for nm = 1 : n_mkt
            ind_om = (setup.mktid==nm) & ismember(oem, all_oem{no});
            v_qom = eval('tmp(ind_om,:);');
            if isempty(v_qom)
                stdq_oem_mkt(:, no, nm) = -1;
                HLq_oem_mkt(:, no, nm) = -1;
                HH2q_oem_mkt(:, no, nm) = -1;
                meanq_oem_mkt_carrier(:, no, nm, :) = -1;
            elseif nnz(ind_om)==1
                stdq_oem_mkt(:, no, nm) = -0.5;
                HLq_oem_mkt(:, no, nm) = -0.5;
                HH2q_oem_mkt(:, no, nm) = -0.5;
                for nc = 1:n_carrier
                    v_qomc = eval('tmp(ind_om & carrier_ind(:, nc),:);');
                    if ~isempty(v_qomc)
                        meanq_oem_mkt_carrier(:, no, nm, nc) = mean(v_qomc, 1);
                    end
                end
            else
                stdq_oem_mkt(:, no, nm) = std(v_qom, 1);
                HLq_oem_mkt(:, no, nm) = max(v_qom) - min(v_qom);
                for nc = 1:n_carrier
                    v_qomc = eval('tmp(ind_om & carrier_ind(:, nc),:);');
                    if ~isempty(v_qomc)
                        meanq_oem_mkt_carrier(:, no, nm, nc) = mean(v_qomc, 1);
                    end
                end
                for j = 1:size(v_qom,2)
                    if HLq_oem_mkt(j,no,nm) == 0
                        HH2q_oem_mkt(j,no,nm) = 0;
                    else
                        tmpv = v_qom(:,j);
                        tmpv(tmpv==max(tmpv)) = -inf;
                        HH2q_oem_mkt(j, no, nm) = max(v_qom(:,j)) - max(tmpv);
                    end
                end
            end
        end
    end
    stdq(kk+1:kk+outputvar_dim2(i), :) = reshape(stdq_oem_mkt, [outputvar_dim2(i) n_all_oem*n_mkt]);
    HLq(kk+1:kk+outputvar_dim2(i), :) = reshape(HLq_oem_mkt, [outputvar_dim2(i) n_all_oem*n_mkt]);
    HH2q(kk+1:kk+outputvar_dim2(i), :) = reshape(HH2q_oem_mkt, [outputvar_dim2(i) n_all_oem*n_mkt]);
    std_of_mean(kk+1:kk+outputvar_dim2(i), :) = reshape(nanstd(meanq_oem_mkt_carrier, 0, 4), [outputvar_dim2(i) n_all_oem*n_mkt]);
    
    kk = kk + outputvar_dim2(i);
end


fprintf(pfid, '\n Table: quality and price dispersion within a firm/month, include firm/months with one observation\n');
ind_obs_q = stdq(1, :)>=-.5;
if isequal(data_frequency, 'quarterly')
    fprintf(pfid, 'All %1.0f Manufacturer/quarters\n', nnz(ind_obs_q));
elseif isequal(data_frequency, 'monthly')
    fprintf(pfid, 'All %1.0f Manufacturer/months\n', nnz(ind_obs_q));
end
fprintf(pfid, '%5s\t%5s\t%5s\t%5s\t%5s\n', ' ', 'Std. Dev.',  'Highest - Lowest', 'Highest - 2nd Highest', 'cross-carrier std of within-carrier mean');
kk = 0;
for i = 1 : length(outputvar2)
    for j = 1:outputvar_dim2(i)
        v_nq = [stdq(kk+j, :); HLq(kk+j, :); HH2q(kk+j, :); std_of_mean(kk+j, :)];
        v_nq = v_nq(:, ind_obs_q);
        v_nq(v_nq==-0.5)= 0;
        v_nq = mean(v_nq, 2);
        fprintf(pfid, '%10s\t%2.2f\t%1.2f\t%1.2f\t%1.2f\n', outputvar_name2{i}, v_nq(1), v_nq(2), v_nq(3), v_nq(4));
    end
    kk = kk + outputvar_dim2(i);
end


%% table 5. own and cross price semi-elasticities
setup.invert_quality_fc = false;
setup.direct_oem_pricing = false;
setup.no_transformation_of_para = false;
[~, ~, ~, ~, simShare] = gmmobj_BLP_smartphone(para_nonlinear_est, ...
    share, x_rand, x_det, ind_mkt_start,ind_mkt_end, randomdraw, IV_demand, W, setup,  n_oem, n_carrier, n_mkt, ...
    carrier_ind, oem_ind, meanutility00, para_linear_est);

ind_mkt = find((yyyy==2013) & mm==3 & ismember(carrier, 'AT&T'));
model_t = model(ind_mkt);
q_t = quantity(ind_mkt);
carrier_t = carrier(ind_mkt);
[~, ind_model] = sort(q_t, 'descend');

top_model = model_t(ind_model(1:10));
bot_model = model_t(ind_model(end-9:end));

fprintf(pfid, 'Top products on AT&T Mar 2013 \t ');
for n = 1 : length(top_model)
    fprintf(pfid, '%s\t', top_model{n});
end
fprintf(pfid, '\n');
fprintf(pfid, 'Bottom products on AT&T Mar 2013 \t ');
for n = 1 : length(bot_model)
    fprintf(pfid, '%s\t', bot_model{n});
end
fprintf(pfid, '\n');

ind_mkt = (yyyy==2013) & mm==3;
elas_model = [top_model; bot_model];
n_elas_model = length(elas_model);
elas_carrier = carrier_t([ind_model(1:10); ind_model(end-9:end)]);

semi_elas_table = nan(n_elas_model, n_elas_model);
elas_table = semi_elas_table;

for nm1 = 1 : n_elas_model
    for nm2 =  1 : n_elas_model
        ind_nm1 = ind_mkt&ismember(model, elas_model{nm1})&ismember(carrier, elas_carrier{nm1});
        ind_nm2 = ind_mkt&ismember(model, elas_model{nm2})&ismember(carrier, elas_carrier{nm2});
        simshare1 = simShare(ind_nm1, :);
        simshare2 = simShare(ind_nm2, :);
        
        dsdp_nm12 = mean(sim_pcoeff.*(-simshare1.*simshare2 + (nm1==nm2)*simshare1));
        
        semi_elas_table(nm1, nm2) = dsdp_nm12/share(ind_nm1)*10;
        elas_table(nm1, nm2) = dsdp_nm12*price(ind_nm2)/share(ind_nm1);
    end
end

fprintf(pfid, '\n Table: Own and Cross Price Semi-elasticities (%%) \n'); % note: the unit is % b/c price is normalized by 100
fprintf(pfid, '%5s\t', ' ');
for nm = 1 : n_elas_model
    fprintf(pfid, '%5s\t', elas_model{nm});
end
fprintf(pfid, '\n');
format short
for nm = 1 : n_elas_model
    fprintf(pfid, '%20s\t', elas_model{nm});
    for nm2 = 1 : n_elas_model
        if abs(semi_elas_table(nm,nm2))<0.01
            fprintf(pfid, '%1.3e\t', semi_elas_table(nm, nm2));
        else
            fprintf(pfid, '%10.3f\t', semi_elas_table(nm, nm2));
        end
    end
    fprintf(pfid, '\n');
end
fprintf(pfid, 'FOOTNOTE: 10 dollar changes for a row product, percentage in the mkt share for a column product\n');

n_elas_all = sum(ind_mkt)-1;
semi_elas_table_all = nan(n_elas_model, n_elas_all);
elas_table_all = semi_elas_table;

for nm1 = 1 : n_elas_model
    ind_nm1 = ind_mkt&ismember(model, elas_model{nm1})&ismember(carrier, elas_carrier{nm1});
    simshare1 = simShare(ind_nm1, :);
    ind_nm2 = ind_mkt&~(ismember(model, elas_model{nm1})&ismember(carrier, elas_carrier{nm1}));
    ind_ind_nm2 = find(ind_nm2);
    for nm2 =  1 : n_elas_all        
        simshare2 = simShare(ind_ind_nm2(nm2), :);
        
        dsdp_nm12 = mean(sim_pcoeff.*(-simshare1.*simshare2));
        
        semi_elas_table_all(nm1, nm2) = dsdp_nm12/share(ind_ind_nm2(nm2))*10;
        elas_table_all(nm1, nm2) = dsdp_nm12*price(ind_nm1)/share(ind_ind_nm2(nm2));
    end
end

%% table 6. elasticity with respect to quality index
% compute quality index
elas_table_q = zeros(n_elas_model, n_elas_model);

for nm1 = 1 : n_elas_model
    for nm2 =  1 : n_elas_model
        ind_nm1 = ind_mkt&ismember(model, elas_model{nm1})&ismember(carrier, elas_carrier{nm1});
        ind_nm2 = ind_mkt&ismember(model, elas_model{nm2})&ismember(carrier, elas_carrier{nm2});
        simshare1 = simShare(ind_nm1, :);
        simshare2 = simShare(ind_nm2, :);
        
        dsdp_nm12 = mean(sim_qcoeff.*(-simshare1.*simshare2 + (nm1==nm2)*simshare1));
        
        elas_table_q(nm1, nm2) = dsdp_nm12*quality_index(ind_nm2)/share(ind_nm1);
        
    end
end


fprintf(pfid, '\n Table: Own and Cross Quality Elasticities (top products on AT&T) \n');
fprintf(pfid, '%5s\t', ' ');
for nm = 1 : n_elas_model
    fprintf(pfid, '%5s\t', elas_model{nm});
end
fprintf(pfid, '\n');
format short
for nm = 1 : n_elas_model
    fprintf(pfid, '%20s\t', elas_model{nm});
    for nm2 = 1 : n_elas_model
        if abs(elas_table_q(nm, nm2))<0.01
            fprintf(pfid, '%1.3e\t', elas_table_q(nm, nm2));
        else
            fprintf(pfid, '%10.3f\t', elas_table_q(nm, nm2));
        end
    end
    fprintf(pfid, '\n');
end

q_elas_table_all = nan(n_elas_model, n_elas_all);
for nm1 = 1 : n_elas_model
    ind_nm1 = ind_mkt&ismember(model, elas_model{nm1})&ismember(carrier, elas_carrier{nm1});
    simshare1 = simShare(ind_nm1, :);
    ind_nm2 = ind_mkt&~(ismember(model, elas_model{nm1})&ismember(carrier, elas_carrier{nm1}));
    ind_ind_nm2 = find(ind_nm2);
    for nm2 =  1 : n_elas_all        
        simshare2 = simShare(ind_ind_nm2(nm2), :);
        
        dsdp_nm12 = mean(sim_qcoeff.*(-simshare1.*simshare2));
        
        q_elas_table_all(nm1, nm2) = dsdp_nm12*quality_index(ind_nm1)/share(ind_ind_nm2(nm2));        
    end
end


%% Figure 1. plot quality evolution
if setup.corr==0
    tmp = quality_index_includingbrand;
    ind1 = ismember(oem, {'Apple'});
    ind2 = ismember(oem, {'Samsung'});
    ind3 = ismember(oem, {'BlackBerry'});
    ind4 = ismember(oem, {'HTC'});
    
    q_max = nan(n_mkt, 1);
    q_median = nan(n_mkt, 1);
    q_max1 = nan(n_mkt, 1);
    q_max2 = nan(n_mkt, 1);
    q_max3 = nan(n_mkt, 1);
    q_max4 = nan(n_mkt, 1);
    for t = 1:n_mkt
        ind = ind_mkt_start(t) : ind_mkt_end(t);
        tmpq = tmp(ind);
        q_max(t) = max(tmpq);
        q_median(t) = median(tmpq);
        q_max1(t) = max(tmpq(ind1(ind)));
        q_max2(t) = max(tmpq(ind2(ind)));
        q_max3(t) = max(tmpq(ind3(ind)));
        q_max4(t) = max(tmpq(ind4(ind)));
    end
    
    disp('is Apple at the frontier?');
    disp(isequal(q_max, q_max1));
    
    figure; axes('FontSize',20);
    plot(q_max1, 'b', 'LineWidth',4); hold on;
    plot(q_max2, '-.r','LineWidth',4); hold on;
    plot(q_median, '--k','LineWidth',4); hold on;
    axis([1 51 3 11])
        
    set(gca, 'XTickLabel',{'2009/1','2009/7','2010/1','2010/7','2011/1','2011/7','2012/1','2012/7','2013/1',''},...
        'XTick',[1 7 13 19 25 31 37 43 49 51], 'FontSize',20);
    set(gcf, 'PaperType', 'uslegal');
    ylabel('quality', 'FontSize',20)
    legend('Apple and industry max', 'Samsung max', 'industry median', 'Location', 'Northwest');
    
    orient landscape
    print('quality_evolution', '-dpdf');
end


%% Figure 2. figures about product variety
range = max(quality_index_includingbrand) - min(quality_index_includingbrand);
variety1 = nan(n_mkt, 5); % col1: variety measure where one product is a smartphone/carrier 
                          % col2: # of equidistantly distributed products over the range of the month
                          % col3: # of equidistantly distributed products over the range in the whole sample
                          % col4: # of products
                          % col5: range of quality                        
variety2 = variety1; % one product is a smartphone (we take the avg quality across smartphone/carriers within a smartphone)
oemmodel = strcat(oem, model_clean);

for t = 1:n_mkt
    ind = ind_mkt_start(t) : ind_mkt_end(t);
    variety1(t,1) = sum(diff(sort(quality_index_includingbrand(ind))).^(1/2)).^2; 
    variety1(t,4) = length(ind);
    variety1(t,5) = max(quality_index_includingbrand(ind)) - min(quality_index_includingbrand(ind));
    
    tmp = unique(oemmodel(ind)); % unique smartphones
    quality_index_includingbrand_tmp = nan(length(tmp),1);
    for i = 1:length(tmp)
        tmpind = ismember(oemmodel(ind), tmp(i));
        quality_index_includingbrand_tmp(i) = mean(quality_index_includingbrand(ind(tmpind)));
    end
    variety2(t,1) = sum(diff(sort(quality_index_includingbrand_tmp)).^(1/2)).^2; 
    variety2(t,4) = length(tmp);
    variety2(t,5) = max(quality_index_includingbrand_tmp) - min(quality_index_includingbrand_tmp);
end
vareity1(:,2) = variety1(:,1)./variety1(:,5) + 1;
variety1(:,3) = variety1(:,1)/range + 1;

variety2(:,2) = variety2(:,1)./variety2(:,5) + 1;
variety2(:,3) = variety2(:,1)/range + 1;


figure;
plot(variety2(:,1), 'b'); hold on; plot(variety2(:,2), 'r'); hold on; plot(variety2(:,4), 'k'); hold on; plot(variety2(:,5), 'm');

figure; axes('FontSize',16);
subplot(2,2,1);
plot(variety2(:,1), '-b.', 'LineWidth',4); xlim([1 n_mkt]); title('variety measure', 'FontSize', 18);
subplot(2,2,2);
plot(variety2(:,2), '-b.', 'LineWidth',4); xlim([1 n_mkt]); title('# of equidistantly distributed products', 'FontSize', 18);
subplot(2,2,3);
plot(variety2(:,4), '-b.', 'LineWidth',4); xlim([1 n_mkt]); title('# of smartphones', 'FontSize', 18);
subplot(2,2,4);
plot(variety2(:,5), '-b.', 'LineWidth',4); xlim([1 n_mkt]); title('quality range', 'FontSize', 18);

figure; 
subplot(3,1,1);
plot(variety2(:,4), '-b.', 'LineWidth',4); xlim([1 n_mkt]); title('(a) # of smartphones', 'FontSize', 14);
set(gca, 'XTickLabel',{'2009/1','2009/7','2010/1','2010/7','2011/1','2011/7','2012/1','2012/7','2013/1',''},...
        'XTick',[1 7 13 19 25 31 37 43 49 51], 'FontSize',16);
subplot(3,1,2);
plot(variety2(:,1), '-b.', 'LineWidth',4); xlim([1 n_mkt]); title('(b) variety measure', 'FontSize', 14);
set(gca, 'XTickLabel',{'2009/1','2009/7','2010/1','2010/7','2011/1','2011/7','2012/1','2012/7','2013/1',''},...
        'XTick',[1 7 13 19 25 31 37 43 49 51], 'FontSize',16);
subplot(3,1,3);
plot(variety2(:,2), '-b.', 'LineWidth',4); xlim([1 n_mkt]); title('(c) # of equidistant products', 'FontSize', 14);
set(gca, 'XTickLabel',{'2009/1','2009/7','2010/1','2010/7','2011/1','2011/7','2012/1','2012/7','2013/1',''},...
        'XTick',[1 7 13 19 25 31 37 43 49 51], 'FontSize',16);
orient landscape
print('variety_evolution', '-dpdf');
