function StartingParams = StartParams(StartInputs3)

global NALT Pvarn Int3_1 Server_switch Start_Switch  
global DIROFF_Switch INSIDER_switch homebI_switch NhomebInt

%%
Switchmergers = StartInputs3{1};
Switchdummies= StartInputs3{2};

cd('StartParams');

if Start_Switch == 1

    betaC0 = csvread('betaC.sol');
    % the order of the coefficients of interactions is the order of the
    % elements of the matrix Int when read column by column.
    betaP0 = csvread('betaP.sol');
    homeb0 = csvread('homeb.sol');
    FE0 = csvread('FE.sol');
    FE0 = FE0(2:length(FE0));
    mu0 = csvread('mu.sol');
    sigma0 = csvread('sigma.sol');

    StartingParams = [betaP0;betaC0;FE0;homeb0;mu0;sigma0];

elseif Start_Switch == 2

    filename = 'Start.csv';
    
    delimiter = ',';
    startRow = 3;

    %% Read columns of data as strings:
    formatSpec = '%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%[^\n\r]';

    %% Open the text file.
    fileID = fopen(filename,'r');

    %% Read columns of data according to format string.
    dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'HeaderLines' ,startRow-1, 'ReturnOnError', false);

    %% Close the text file.
    fclose(fileID);

    %% Convert the contents of columns containing numeric strings to numbers.
    raw = repmat({''},length(dataArray{1}),length(dataArray)-1);
    for col=1:length(dataArray)-1
        raw(1:length(dataArray{col}),col) = dataArray{col};
    end
    numericData = NaN(size(dataArray{1},1),size(dataArray,2));

    if Switchmergers == 0 && Switchdummies ==0;
        endcol = (NALT+10);
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 0 && INSIDER_switch == 0;
        endcol = (NALT+5);
            elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 0 && INSIDER_switch == 0;
        endcol = (NALT+6);
           elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 0 && INSIDER_switch == 1;
        endcol = (NALT+7);
    elseif Switchmergers == 1 && Switchdummies ==0 && DIROFF_Switch == 1 && INSIDER_switch == 0;
        endcol = (NALT+13);
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 0;
        endcol = (NALT+13);
    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 0;
        endcol = (NALT+16);
    elseif Switchmergers == 0 && Switchdummies ==0 && DIROFF_Switch == 2 && INSIDER_switch == 0;
        endcol = (NALT+7);
    elseif Switchmergers == 1 && Switchdummies ==0 && DIROFF_Switch == 2 && INSIDER_switch == 0;
        endcol = (NALT+9);
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 0;
        endcol = (NALT+9);
    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 0;
        endcol = (NALT+11);
   elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 1;
       endcol = (NALT+16);
          elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 1;
       endcol = (NALT+19);
   elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 2;
        endcol = (NALT+16);
           elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 2;
        endcol = (NALT+19);
   elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 1;
       endcol = (NALT+11);
         elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 1;
       endcol = (NALT+13);
   elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 2;
       endcol = (NALT+11);
   elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 2;
       endcol = (NALT+13);
       
   elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 3 && INSIDER_switch == 0;
       endcol = (NALT+14);
       
   elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 3 && INSIDER_switch == 0;
       endcol =(NALT+18);
       
   elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 3 && INSIDER_switch == 2;
       endcol =(NALT+22);
    end
    
    % add homebI_switch
    if homebI_switch ==1
        endcol= endcol +NhomebInt;
    end
    
    %%
    
    for col=1:endcol

        % Converts strings in the input cell array to numbers. Replaced non-numeric
        % strings with NaN.
        rawData = dataArray{col};
        for row=1:size(rawData, 1);
            % Create a regular expression to detect and remove non-numeric prefixes and
            % suffixes.
            regexstr = '(?<prefix>.*?)(?<numbers>([-]*(\d+[\,]*)+[\.]{0,1}\d*[eEdD]{0,1}[-+]*\d*[i]{0,1})|([-]*(\d+[\,]*)*[\.]{1,1}\d+[eEdD]{0,1}[-+]*\d*[i]{0,1}))(?<suffix>.*)';
            try
                result = regexp(rawData{row}, regexstr, 'names');
                numbers = result.numbers;

                % Detected commas in non-thousand locations.
                invalidThousandsSeparator = false;
                if any(numbers==',');
                    thousandsRegExp = '^\d+?(\,\d{3})*\.{0,1}\d*$';
                    if isempty(regexp(thousandsRegExp, ',', 'once'));
                        numbers = NaN;
                        invalidThousandsSeparator = true;
                    end
                end
                % Convert numeric strings to numbers.
                if ~invalidThousandsSeparator;
                    numbers = textscan(strrep(numbers, ',', ''), '%f');
                    numericData(row, col) = numbers{1};
                    raw{row, col} = numbers{1};
                end
            catch me
            end
        end
    end

    %% Split data into numeric and cell columns & Allocate imported array to column variable names

    if Switchmergers == 0 && Switchdummies ==0 && DIROFF_Switch == 1 && INSIDER_switch == 0;

    rawNumericColumns = raw(:, 1:(NALT+10));

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 5)), cell2mat(rawNumericColumns(:, 8))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4));
              cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7));
              cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 11));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 12:61))];     %  first FE is normalized
    
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 0 && INSIDER_switch == 0 && homebI_switch ==1;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 6));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (7:6+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, 7+NhomebInt:endcol))];     %  first FE is normalized
  
    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 0 && INSIDER_switch == 0 && homebI_switch ==1;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 7));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (8:7+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, 8+NhomebInt:endcol))];     %  first FE is normalized
   
    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 0 && INSIDER_switch == 1 && homebI_switch ==1;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 8));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (9:8+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, 9+NhomebInt:endcol))];     %  first FE is normalized

    elseif (Switchmergers == 1 && Switchdummies ==0) || (Switchmergers == 0 && Switchdummies >=1) && DIROFF_Switch == 1 && INSIDER_switch == 0 && homebI_switch ==1;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 6)), cell2mat(rawNumericColumns(:, 10))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5));
             cell2mat(rawNumericColumns(:, 7)),cell2mat(rawNumericColumns(:, 8)), cell2mat(rawNumericColumns(:, 9));
             cell2mat(rawNumericColumns(:, 11)), cell2mat(rawNumericColumns(:, 12)), cell2mat(rawNumericColumns(:, 13))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 14));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (15:14+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, (14+NhomebInt+1):endcol))];     % normalized FE is now first one.  

    elseif (Switchmergers == 1 && Switchdummies ==0) || (Switchmergers == 0 && Switchdummies >=1) && DIROFF_Switch == 1 && INSIDER_switch == 0 && homebI_switch ==0 ;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 6)), cell2mat(rawNumericColumns(:, 10))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5));
             cell2mat(rawNumericColumns(:, 7)),cell2mat(rawNumericColumns(:, 8)), cell2mat(rawNumericColumns(:, 9));
             cell2mat(rawNumericColumns(:, 11)), cell2mat(rawNumericColumns(:, 12)), cell2mat(rawNumericColumns(:, 13))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 14));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 15:64))];     % normalized FE is now first one.  

 
    elseif (Switchmergers == 1 && Switchdummies >=1) && DIROFF_Switch == 1 && INSIDER_switch == 0 && homebI_switch ==0 ; 

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7)), cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6));
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),cell2mat(rawNumericColumns(:, 11));
             cell2mat(rawNumericColumns(:, 13)), cell2mat(rawNumericColumns(:, 14)), cell2mat(rawNumericColumns(:, 15)), cell2mat(rawNumericColumns(:, 16))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 17));      


    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 18:67))];     % normalized FE is now first one.  

    elseif (Switchmergers == 1 && Switchdummies >=1) && DIROFF_Switch == 1 && INSIDER_switch == 0 && homebI_switch ==1 ; 

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7)), cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6));
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),cell2mat(rawNumericColumns(:, 11));
             cell2mat(rawNumericColumns(:, 13)), cell2mat(rawNumericColumns(:, 14)), cell2mat(rawNumericColumns(:, 15)), cell2mat(rawNumericColumns(:, 16))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 17));      
   StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, 18)),cell2mat(rawNumericColumns(:, 19))];      
    

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, 20:69))];     % normalized FE is now first one.  
   
    elseif Switchmergers == 0 && Switchdummies ==0 && DIROFF_Switch == 2 && INSIDER_switch == 0;

    rawNumericColumns = raw(:, 1:(NALT+7));

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 5))]; %, cell2mat(rawNumericColumns(:, 8))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4));
              cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 8));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 9:(NALT+7)))];     %  first FE is normalized

    elseif (Switchmergers == 1 && Switchdummies ==0) || (Switchmergers == 0 && Switchdummies >=1) && DIROFF_Switch == 2 && INSIDER_switch == 0 && homebI_switch ==0;

    rawNumericColumns = raw(:, 1:(NALT+9));

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 6))]; %, cell2mat(rawNumericColumns(:, 10))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5));
             cell2mat(rawNumericColumns(:, 7)),cell2mat(rawNumericColumns(:, 8)), cell2mat(rawNumericColumns(:, 9))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 10));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 11:(NALT+9)))];     % normalized FE is now first one.  

   elseif (Switchmergers == 1 && Switchdummies ==0) || (Switchmergers == 0 && Switchdummies >=1) && DIROFF_Switch == 2 && INSIDER_switch == 0 && homebI_switch ==1;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 6))]; %, cell2mat(rawNumericColumns(:, 10))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5));
             cell2mat(rawNumericColumns(:, 7)),cell2mat(rawNumericColumns(:, 8)), cell2mat(rawNumericColumns(:, 9))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 10));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (11:10+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, (11+NhomebInt):endcol))];     % normalized FE is now first one.  

    elseif (Switchmergers == 1 && Switchdummies >=1) && DIROFF_Switch == 2 && INSIDER_switch == 0 && homebI_switch == 0;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6));
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),cell2mat(rawNumericColumns(:, 11))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 12));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 13:(NALT+11)))];     % normalized FE is now first one.  
     elseif (Switchmergers == 1 && Switchdummies >=1) && DIROFF_Switch == 2 && INSIDER_switch == 0 && homebI_switch == 1;

    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6));
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),cell2mat(rawNumericColumns(:, 11))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 12));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (13:12+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, (13+NhomebInt):endcol))];     % normalized FE is now first one.  
   
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 1;
    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7)), cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6));
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),cell2mat(rawNumericColumns(:, 11));
             cell2mat(rawNumericColumns(:, 13)), cell2mat(rawNumericColumns(:, 14)), cell2mat(rawNumericColumns(:, 15)), cell2mat(rawNumericColumns(:, 16))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 17));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 18:(NALT+16)))];     % normalized FE is now first one.  
         
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 2;
    
    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7)), cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),0,0;
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),0,cell2mat(rawNumericColumns(:, 11)),0;
             cell2mat(rawNumericColumns(:, 13)), cell2mat(rawNumericColumns(:, 14)), cell2mat(rawNumericColumns(:, 15)),0,0, cell2mat(rawNumericColumns(:, 16))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 17));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 18:(NALT+16)))];     % normalized FE is now first one.  
    
    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 2  && homebI_switch == 0;
    
    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 8)), cell2mat(rawNumericColumns(:, 14))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7)),0,0;
             cell2mat(rawNumericColumns(:, 9)),cell2mat(rawNumericColumns(:, 10)), cell2mat(rawNumericColumns(:, 11)), cell2mat(rawNumericColumns(:, 12)),0,cell2mat(rawNumericColumns(:, 13)),0;
             cell2mat(rawNumericColumns(:, 15)), cell2mat(rawNumericColumns(:, 16)), cell2mat(rawNumericColumns(:, 17)), cell2mat(rawNumericColumns(:, 18)),0,0, cell2mat(rawNumericColumns(:, 19))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 20));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 21:(NALT+19)))];     % normalized FE is now first one.  

    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 1 && INSIDER_switch == 2  && homebI_switch == 1;
    
    rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 8)), cell2mat(rawNumericColumns(:, 14))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7)),0,0;
             cell2mat(rawNumericColumns(:, 9)),cell2mat(rawNumericColumns(:, 10)), cell2mat(rawNumericColumns(:, 11)), cell2mat(rawNumericColumns(:, 12)),0,cell2mat(rawNumericColumns(:, 13)),0;
             cell2mat(rawNumericColumns(:, 15)), cell2mat(rawNumericColumns(:, 16)), cell2mat(rawNumericColumns(:, 17)), cell2mat(rawNumericColumns(:, 18)),0,0, cell2mat(rawNumericColumns(:, 19))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 20));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (21:20+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, (21+NhomebInt):(endcol)))];     % normalized FE is now first one.  

    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 1;
            rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6));
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),cell2mat(rawNumericColumns(:, 11))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 12));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 13:(NALT+11)))];     % normalized FE is now first one.  

    elseif Switchmergers ==1 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 1 && homebI_switch == 0;
            rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 8))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7));
             cell2mat(rawNumericColumns(:, 9)),cell2mat(rawNumericColumns(:, 10)), cell2mat(rawNumericColumns(:, 11)),cell2mat(rawNumericColumns(:, 12)),cell2mat(rawNumericColumns(:, 13))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 14));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 15:(NALT+13)))];     % normalized FE is now first one.  
    
    elseif Switchmergers ==1 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 1  && homebI_switch == 1;
            rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 8))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7));
             cell2mat(rawNumericColumns(:, 9)),cell2mat(rawNumericColumns(:, 10)), cell2mat(rawNumericColumns(:, 11)),cell2mat(rawNumericColumns(:, 12)),cell2mat(rawNumericColumns(:, 13))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 14));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (15:14+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, (15+NhomebInt):endcol))];     % normalized FE is now first one.  

    
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 2 && INSIDER_switch == 2 ;
            rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),0;
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10)),0 ,cell2mat(rawNumericColumns(:, 11))];

    StartingParams(Pvarn+Int3_1+NALT) = cell2mat(rawNumericColumns(:, 12));      

    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NALT-1) = [cell2mat(rawNumericColumns(:, 13:(NALT+11)))];     % normalized FE is now first one.  
    
    elseif Switchmergers == 0 && Switchdummies >=1 && DIROFF_Switch == 3 && INSIDER_switch == 0;
            rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7)),cell2mat(rawNumericColumns(:, 11))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5));
             0,0,0;   
             cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 9)), cell2mat(rawNumericColumns(:, 10));
             cell2mat(rawNumericColumns(:, 12)), cell2mat(rawNumericColumns(:, 13)), cell2mat(rawNumericColumns(:, 14))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 15));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (16:15+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, 16+NhomebInt:endcol))];     % normalized FE is now first one.  
   
    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 3 && INSIDER_switch == 0;
            rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 7)),cell2mat(rawNumericColumns(:, 9)),cell2mat(rawNumericColumns(:, 14))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6));
             0,0,0,cell2mat(rawNumericColumns(:, 8));
             cell2mat(rawNumericColumns(:, 10)),cell2mat(rawNumericColumns(:, 11)), cell2mat(rawNumericColumns(:, 12)), cell2mat(rawNumericColumns(:, 13));
             cell2mat(rawNumericColumns(:, 15)), cell2mat(rawNumericColumns(:, 16)), cell2mat(rawNumericColumns(:, 17)), cell2mat(rawNumericColumns(:, 18))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 19));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (20:19+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, 20+NhomebInt:endcol))];     % normalized FE is now first one.  
   
    elseif Switchmergers == 1 && Switchdummies >=1 && DIROFF_Switch == 3 && INSIDER_switch == 2;
            rawNumericColumns = raw(:, 1:endcol);

    StartingParams(1:Pvarn) = [cell2mat(rawNumericColumns(:, 2)), cell2mat(rawNumericColumns(:, 8)),cell2mat(rawNumericColumns(:, 11)),cell2mat(rawNumericColumns(:, 17))]; %, cell2mat(rawNumericColumns(:, 12))];

    StartingParams(Pvarn+1:Pvarn+Int3_1) = [cell2mat(rawNumericColumns(:, 3)), cell2mat(rawNumericColumns(:, 4)),cell2mat(rawNumericColumns(:, 5)),cell2mat(rawNumericColumns(:, 6)),cell2mat(rawNumericColumns(:, 7)),0,0;
             0,0,0,cell2mat(rawNumericColumns(:, 9)),cell2mat(rawNumericColumns(:, 10)),0,0;
             cell2mat(rawNumericColumns(:, 12)),cell2mat(rawNumericColumns(:, 13)), cell2mat(rawNumericColumns(:, 14)), cell2mat(rawNumericColumns(:, 15)),0,cell2mat(rawNumericColumns(:, 16)),0;
             cell2mat(rawNumericColumns(:, 18)), cell2mat(rawNumericColumns(:, 19)), cell2mat(rawNumericColumns(:, 20)), cell2mat(rawNumericColumns(:, 21)),0,0,cell2mat(rawNumericColumns(:, 22))];

    StartingParams(Pvarn+Int3_1+NALT+NhomebInt) = cell2mat(rawNumericColumns(:, 23));      
    StartingParams(Pvarn+Int3_1+1:Pvarn+Int3_1+NhomebInt) = [cell2mat(rawNumericColumns(:, (24:23+NhomebInt)))];      

    StartingParams(Pvarn+Int3_1+1+NhomebInt:Pvarn+Int3_1+NALT-1+NhomebInt) = [cell2mat(rawNumericColumns(:, 24+NhomebInt:endcol))];     % normalized FE is now first one.  
   
    end

end

if Server_switch ==1
    cd '~/Inertia/ForServer';

elseif Server_switch == 0
    cd 'C:\Dropbox\Model_Estimation\LocalTrials';


end

