/*********************************************************************
Table 1:
	Panel A: Column (1), (2)
	Panel B: Column (1), (2)
*********************************************************************/

use leads_score_posting, clear

* create rating category
tab rating, missing
gen rating_cat = 0 if (rating==.)
replace rating_cat = 1 if rating < 3
replace rating_cat = 2 if rating==3 | rating==3.5
replace rating_cat = 3 if rating>=4 & rating~=.
tab rating_cat, missing
label var rating_cat "rating category"

* separate price category when it is missing
replace price = 0 if price == .

gen lnscore = ln(score)
gen lnscoreXpost1 = lnscore*post1
gen lnscoreXpost2 = lnscore*post2

gen below70Xpost1 = below70*post1
gen below70Xpost2 = below70*post2

gen time = month

xtset business_id month

xi i.rating_cat*time i.price*time

** Table 1 Panel A: Column (1) & (2) **
** NOTE: the variable "lnleads" is removed from the data due to the data agreement with Yelp **
eststo clear
	xtreg leads_n lnscoreXpost1 lnscoreXpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
eststo reg1
	xtreg lnleads lnscoreXpost1 lnscoreXpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
eststo reg2
esttab using result.csv, star(* 0.10 ** 0.05 *** 0.01) nomtitles nogap replace csv se drop(_I*X*)

	
** Table 2 Panel B: Column (1) & (2) **
** NOTE: the variable "lnleads" is removed from the data due to the data agreement with Yelp **
eststo clear
	xtreg leads_n below70Xpost1 below70Xpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
eststo reg1
	xtreg lnleads below70Xpost1 below70Xpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
eststo reg2
esttab using result.csv, star(* 0.10 ** 0.05 *** 0.01) nomtitles nogap replace csv se drop(_I*X*)

	

/*********************************************************************
Table 1:
	Panel A: Column (3), (4)
	Panel B: Column (1), (2)
*********************************************************************/

use reviews_score_posting, clear

gen rating_cat = 0 if (rating==.)
replace rating_cat = 1 if rating < 3
replace rating_cat = 2 if rating==3 | rating==3.5
replace rating_cat = 3 if rating>=4 & rating~=.
tab rating_cat, missing
label var rating_cat "rating category"

* separate price category when it is missing
replace price = 0 if price == .

gen lnscore = ln(score)
gen lnscoreXpost1 = lnscore*post1
gen lnscoreXpost2 = lnscore*post2

gen below70Xpost1 = below70*post1
gen below70Xpost2 = below70*post2

gen time = month

xtset business_id month
xi i.rating_cat*time i.price*time


** Table 1 Panel A: Column (3) & (4) **
** NOTE: the variable "lnnum_rev" is removed from the data due to the data agreement with Yelp **
eststo clear
	xtreg num_rev_n lnscoreXpost1 lnscoreXpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
eststo reg1
	xtreg lnnum_rev lnscoreXpost1 lnscoreXpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
eststo reg2
esttab using result.csv, star(* 0.10 ** 0.05 *** 0.01) nomtitles nogap replace csv se drop(_I*X*)


** Table 1 Panel A: Column (3) & (4) **
** NOTE: the variable "lnnum_rev" is removed from the data due to the data agreement with Yelp **
eststo clear
	xtreg num_rev_n below70Xpost1 below70Xpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
eststo reg2
	xtreg lnnum_rev below70Xpost1 below70Xpost2 post1 post2 time _IpriX* _IratX*, fe cluster(business_id)
esttab using result.csv, star(* 0.10 ** 0.05 *** 0.01) nomtitles nogap replace csv se drop(_I*X*)




/*********************************************************************
Figure 4
*********************************************************************/

*********************** LEADS *************************

use leads_score_posting_weekly, clear

collapse (mean) leads_mean = leads_n ///
	(sd) leads_sd = leads_n ///
	(count) ct_leads = leads_n, ///
	by(week below70)

local outcome "leads"
foreach X of local outcome {
	generate h_`X' = `X'_mean + `X'_sd/sqrt(ct_`X')
	generate l_`X' = `X'_mean - `X'_sd/sqrt(ct_`X')
}


** PLOT **

tsset below70 week

#delimit ;
twoway
	(tsline leads_mean if below70 == 0, lpattern(shortdash) lc(gs0) lw(medthick))
	(tsline leads_mean if below70 == 1, lpattern(longdash_dot) lc(black) lw(medthick))
	(rcap h_leads l_leads week if below70 == 0, lc(gs0) lw(vthin))
	(rcap h_leads l_leads week if below70 == 1, lc(black) lw(vthin))
	,
	xline(0, lwidth(thin) lcolor(red))
	xline(9, lwidth(thin) lcolor(red))
	legend(order(1 "Businesses (Score>70)" 2 "Businesses (Score<=70)") size(medsmall))
	legend(col(2))
	ytitle("Standardized Counts", size(medsmall))
	xtitle("Week", size(medsmall))
	ylabel(-0.2(0.1)0.2, labsize(small))
	xtitle("")
	xlabel(-15(5)35, labsize(small))
	xscale(lw(medium)) yscale(lw(medium))
	graphregion(fcolor(white));
#delimit cr
graph export "Fig4_A.eps", replace



*********************** # of REVIEWS *************************

use reviews_score_posting_weekly, clear

collapse (mean) num_rev_mean = num_rev_n ///
	(sd) num_rev_sd = num_rev_n  ///
	(count) ct_num_rev = num_rev_n , ///
	by(week below70)

local outcome "num_rev"
foreach X of local outcome {
	generate h_`X' = `X'_mean + `X'_sd/sqrt(ct_`X')
	generate l_`X' = `X'_mean - `X'_sd/sqrt(ct_`X')
}

** PLOT **
tsset below70 week

#delimit ;
twoway
	(tsline num_rev_mean if below70 == 0, lpattern(shortdash) lc(gs0) lw(medthick))
	(tsline num_rev_mean if below70 == 1, lpattern(longdash_dot) lc(black) lw(medthick))
	(rcap h_num_rev l_num_rev week if below70 == 0, lc(gs0) lw(vthin))
	(rcap h_num_rev l_num_rev week if below70 == 1, lc(black) lw(vthin))
	,
	xline(0, lwidth(thin) lcolor(red))
	xline(9, lwidth(thin) lcolor(red))
	legend(order(1 "Businesses (Score>70)" 2 "Businesses (Score<=70)") size(nedsmall))
	legend(col(2))
	ytitle("Standardized Counts", size(nedsmall))
	ylabel(-0.3(0.1)0.4, labsize(small))
	tlabel(-15(5)35, labsize(small))
	xtitle("")
	xscale(lw(medium)) yscale(lw(medium))
	graphregion(fcolor(white));
#delimit cr
graph export "Fig4_B.eps", replace



