function [residual, g1, g2, g3] = Taylor_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 23, 1);

%
% Model equations
%

T27 = params(2)*((1-y(8))/y(3)+y(8)/y(4));
T28 = 1/y(3);
T54 = y(7)^(params(8)/(1-params(8)));
T67 = params(7)^(1/(1-params(8)));
T87 = (1-y(9)*(1-params(10)))^params(8);
T106 = (1+y(16))^params(15);
T113 = params(16)*(1+y(16))^(params(15)-1);
T153 = (y(20)/params(3))^(-1);
T159 = params(3)^params(20);
lhs =y(4);
rhs =params(1)*y(3);
residual(1)= lhs-rhs;
lhs =y(2)*(1+y(1))/(1+y(16));
rhs =1;
residual(2)= lhs-rhs;
lhs =y(2);
rhs =T27/T28;
residual(3)= lhs-rhs;
lhs =y(5);
rhs =y(9)*(exp(y(21))/y(15)-y(3))-params(9)*y(10)+params(6);
residual(4)= lhs-rhs;
lhs =y(6);
rhs =params(2);
residual(5)= lhs-rhs;
lhs =T54;
rhs =(1-params(11))*(exp(y(21))*y(11)-y(3)+params(12)-y(22))*T67/params(9)+T54*y(6)*(1-params(10));
residual(6)= lhs-rhs;
lhs =y(8);
rhs =params(10)*(1-y(7));
residual(7)= lhs-rhs;
lhs =y(9);
rhs =(1-y(8))*y(9)+y(7)*(1-y(9));
residual(8)= lhs-rhs;
lhs =y(10);
rhs =((y(9)-y(9)*(1-params(10)))/T87)^(1/(1-params(8)));
residual(9)= lhs-rhs;
lhs =y(12);
rhs =params(15)*(1-params(17))*y(13)/((params(15)-1)*y(14));
residual(10)= lhs-rhs;
lhs =y(13);
rhs =y(11)*y(17)+y(13)*y(6)*params(16)*T106;
residual(11)= lhs-rhs;
lhs =y(14);
rhs =y(17)+y(14)*y(6)*T113;
residual(12)= lhs-rhs;
lhs =1;
rhs =(1-params(16))*y(12)^(1-params(15))+params(16)*(1+y(16))^(-(1-params(15)));
residual(13)= lhs-rhs;
lhs =y(15);
rhs =(1-params(16))*y(12)^(-params(15))+T106*y(15)*params(16);
residual(14)= lhs-rhs;
lhs =y(18);
rhs =(-log(params(1)))+y(18)*params(2)*(1-y(8)-y(7));
residual(15)= lhs-rhs;
lhs =y(19);
rhs =params(9)*T54/T67;
residual(16)= lhs-rhs;
lhs =y(18)/params(18);
rhs =y(19)/params(19)*T153;
residual(17)= lhs-rhs;
lhs =y(3);
rhs =y(20)^(1-params(20))*T159;
residual(18)= lhs-rhs;
lhs =y(15)*y(17);
rhs =y(9)*exp(y(21));
residual(19)= lhs-rhs;
lhs =y(1);
rhs =params(4)+params(23)*(y(1)-params(4))+y(16)*(1-params(23))*params(24)+x(3);
residual(20)= lhs-rhs;
lhs =y(21);
rhs =y(21)*params(21)-x(1);
residual(21)= lhs-rhs;
lhs =y(22);
rhs =y(22)*params(22)+x(2);
residual(22)= lhs-rhs;
lhs =y(23);
rhs =x(3);
residual(23)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(23, 23);

  %
  % Jacobian matrix
  %

T221 = getPowerDeriv(y(7),params(8)/(1-params(8)),1);
T283 = getPowerDeriv(1+y(16),params(15),1);
  g1(1,3)=(-params(1));
  g1(1,4)=1;
  g1(2,1)=y(2)/(1+y(16));
  g1(2,2)=(1+y(1))/(1+y(16));
  g1(2,16)=(-(y(2)*(1+y(1))))/((1+y(16))*(1+y(16)));
  g1(3,2)=1;
  g1(3,3)=(-((T28*params(2)*(-(1-y(8)))/(y(3)*y(3))-T27*(-1)/(y(3)*y(3)))/(T28*T28)));
  g1(3,4)=(-(params(2)*(-y(8))/(y(4)*y(4))/T28));
  g1(3,8)=(-(params(2)*((-1)/y(3)+1/y(4))/T28));
  g1(4,3)=y(9);
  g1(4,5)=1;
  g1(4,9)=(-(exp(y(21))/y(15)-y(3)));
  g1(4,10)=params(9);
  g1(4,15)=(-(y(9)*(-exp(y(21)))/(y(15)*y(15))));
  g1(4,21)=(-(y(9)*exp(y(21))/y(15)));
  g1(5,6)=1;
  g1(6,3)=(-(T67*(-(1-params(11)))/params(9)));
  g1(6,6)=(-(T54*(1-params(10))));
  g1(6,7)=T221-y(6)*(1-params(10))*T221;
  g1(6,11)=(-(T67*exp(y(21))*(1-params(11))/params(9)));
  g1(6,21)=(-(T67*(1-params(11))*exp(y(21))*y(11)/params(9)));
  g1(6,22)=(-(T67*(-(1-params(11)))/params(9)));
  g1(7,7)=params(10);
  g1(7,8)=1;
  g1(8,7)=(-(1-y(9)));
  g1(8,8)=y(9);
  g1(8,9)=1-(1-y(8)-y(7));
  g1(9,9)=(-((T87*(1-(1-params(10)))-(y(9)-y(9)*(1-params(10)))*(-(1-params(10)))*getPowerDeriv(1-y(9)*(1-params(10)),params(8),1))/(T87*T87)*getPowerDeriv((y(9)-y(9)*(1-params(10)))/T87,1/(1-params(8)),1)));
  g1(9,10)=1;
  g1(10,12)=1;
  g1(10,13)=(-(params(15)*(1-params(17))/((params(15)-1)*y(14))));
  g1(10,14)=(-((-(params(15)*(1-params(17))*y(13)*(params(15)-1)))/((params(15)-1)*y(14)*(params(15)-1)*y(14))));
  g1(11,6)=(-(y(13)*params(16)*T106));
  g1(11,11)=(-y(17));
  g1(11,13)=1-y(6)*params(16)*T106;
  g1(11,16)=(-(y(13)*y(6)*params(16)*T283));
  g1(11,17)=(-y(11));
  g1(12,6)=(-(y(14)*T113));
  g1(12,14)=1-y(6)*T113;
  g1(12,16)=(-(y(14)*y(6)*params(16)*getPowerDeriv(1+y(16),params(15)-1,1)));
  g1(12,17)=(-1);
  g1(13,12)=(-((1-params(16))*getPowerDeriv(y(12),1-params(15),1)));
  g1(13,16)=(-(params(16)*getPowerDeriv(1+y(16),(-(1-params(15))),1)));
  g1(14,12)=(-((1-params(16))*getPowerDeriv(y(12),(-params(15)),1)));
  g1(14,15)=1-params(16)*T106;
  g1(14,16)=(-(y(15)*params(16)*T283));
  g1(15,7)=(-(y(18)*(-params(2))));
  g1(15,8)=(-(y(18)*(-params(2))));
  g1(15,18)=1-params(2)*(1-y(8)-y(7));
  g1(16,7)=(-(params(9)*T221/T67));
  g1(16,19)=1;
  g1(17,18)=1/params(18);
  g1(17,19)=(-(T153*1/params(19)));
  g1(17,20)=(-(y(19)/params(19)*1/params(3)*getPowerDeriv(y(20)/params(3),(-1),1)));
  g1(18,3)=1;
  g1(18,20)=(-(T159*getPowerDeriv(y(20),1-params(20),1)));
  g1(19,9)=(-exp(y(21)));
  g1(19,15)=y(17);
  g1(19,17)=y(15);
  g1(19,21)=(-(y(9)*exp(y(21))));
  g1(20,1)=1-params(23);
  g1(20,16)=(-((1-params(23))*params(24)));
  g1(21,21)=1-params(21);
  g1(22,22)=1-params(22);
  g1(23,23)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],23,529);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],23,12167);
end
end
end
end
