* Table 5
* complete:  07/30/19
* edited to add "reghdfe, compile" based on 10/11/19
clear all
* ssc install ritest
* ssc install ftools
* ssc install reghdfe
cap reghdfe, compile
* ssc install estout


* .dta files needed: table5_1.dta table5_2dta
* .ado files needed: permute_table5_cols1_2.ado, permute_table5_cols4_8.ado


use table5_1, clear

label drop _all

compress


/* Table 5: Cols 1-2 */
********************
********************Columns 1 and 2: Standard Asymptotics
********************
reghdfe export treat_year_2011 ,ab(pcode year) vce(cluster fcode)
su export if treatment==0
reghdfe l_texport treat_year_2011 ,ab(pcode year) vce(cluster fcode)
su l_texport if treatment==0



/*Table 5: Cols 1-2 (Permutation Tests) */
********************
********************Columns 1 and 2: Permutation Tests
********************

keep export l_texport treatment year fcode pcode
#delimit ;
ritest treatment b_t11_exp = r(b_t11_exp) b_t11_lexp = r(b_t11_lexp),
cluster(fcode) saving(permutation_results_table5_cols1_2,replace
every(100)) reps(4000): permute_table5_cols1_2 treatment;





/* Table 5: Col 3 */
********************;
********************Columns 3: Standard Asymptotics and Permutation Test;
********************;

use table5_2, clear;
reg total treatment if new==0,cluster(fcode);
su total if treatment==0 &new==0;

#delimit ;
ritest treatment
b_t_lu=r(b_t_lu),
cluster(fcode) saving(permutation_results_table5_col3,replace every(100))
reps(4000): permute_table5_col3  treatment;



/* Table 5: Cols 4-8 */
********************;
********************Columns 4-8: Standard Asymptotics;
********************;

use  table5_1,clear;


*** use data at firm level for firm level regressions ****;
egen ftag=tag(firm year);
keep if ftag==1;
gen logflooms=log(firmlooms);
gen logflooms_emp=log(firmlooms/firmemp);
gen logpicks_emp=log(firmpicks/firmemp);
gen logemp=log(firmemp);

keep logflooms logemp logflooms_emp  anyconsult salesmarketingscore treatment  treat_year_2011 fcode year;
label drop _all;
compress;


eststo clear;
local i=1;
local outcomes logflooms logemp logflooms_emp  anyconsult salesmarketingscore;
foreach var of varlist `outcomes' {;
reghdfe `var' treat_year_2011,ab(fcode year) vce(cluster fcode);
*pause;
sum `var' if treatment==0;
estadd scalar cmean=r(mean);
eststo table5a_`i';
local i=`i'+1;
};

keep `outcomes' treatment fcode year;


/* Table 5: Cols 4-8 (Permutation Tests) */
********************;
********************Columns 4-8: Permutation Tests;
********************;


ritest treatment
bt_logflooms=r(b_logflooms)
bt_logemp=r(b_logemp)
bt_logflooms_emp=r(b_logflooms_emp)
bt_anyconsult=r(b_anyconsult)
bt_sales =r(b_salesmarketingscore),
cluster(fcode) saving(permutation_results_table5_cols4_8,replace every(100))
reps(4000): permute_table5_cols4_8 treatment;








