function [tr] = solveTransition(ss, T, nSigma , par, func, glob, comp, steadyRepost, cost)


xiGr = zeros(glob.nXi,1);
xiGr(end) = par.xiBad;
glob.xiGrid = xiGr;

Pxi = eye(glob.nXi);

Pxi(1,end) = par.pBad;
Pxi(1,end-1) = (1-par.pBad);

Pxi(end,end-1) = par.pGood;
Pxi(end,end) = (1 - par.pGood);

glob.Pxi = Pxi;

glob.masterP    = kron(glob.Pz,glob.Pxi);
glob.disutil    = kron(ones(glob.nZ,1),glob.xiGrid);

%% Guess path of theta from t=1 to t=T
th0 = linspace(ss.th, ss.th,  T-1);

errTrans = 1;
iterTrans = 0;

%% initialize transition values/decisions/distributions
S = ss.S.*ones(glob.nXi,T);
S0_xi_min = ss.S(1).*ones(glob.nXi,T);
V = ss.V.*ones(glob.nXi,T);

s_u = ss.s_u.*ones(glob.nXi,T-1);
s_e = ss.s_e.*ones(glob.nXi,T-1);
quit = ss.quit.*ones(glob.nXi,T-1);

searchers = ones(1,T-1);

EE = ss.EE.*ones(1,T-1);
EU = ss.EU.*ones(1,T-1);
u = ss.u.*ones(1,T-1);
e = ss.e.*ones(glob.nXi,T-1);

th1 = ss.th*ones(1,T-1);
%% Deterministic path of productivity: Shock hits at t=1
logzTrans = zeros(1,T-1);
logzTrans(1) = (nSigma>0) * nSigma * par.sigmaZ;

for t=2:T-1
    logzTrans(t) = par.rhoZ*logzTrans(t-1);
end

z = exp(logzTrans);
emp = sum(ss.e);
vShock = (nSigma == -2)*0.01*[ss.v,zeros(1,T-2)] + (nSigma == -10)*2*0.01*[ss.v,zeros(1,T-2)];

%% Deterministic path of OJS efficiency
lambda = par.lambda;
lambdaShock = 0.01;

loglambdaTrans = zeros(1,T-1);
rhoLambda = 0.975;
loglambdaTrans(1) = log(lambda) + (nSigma==-3)*lambdaShock;

for t = 2:T-1
    loglambdaTrans(t) = (1-rhoLambda)*log(lambda) + rhoLambda * loglambdaTrans(t-1);
end

lambdaTrans = exp(loglambdaTrans);

%% Deterministic path of match efficiency
mu = par.mu;
muShock = 0.01;
logmuTrans = zeros(1,T-1);
rhoMu = 0.975;
logmuTrans(1) = log(mu) + (nSigma==-4)*muShock;
for t = 2:T-1
    logmuTrans(t) = (1-rhoMu)*log(mu) + rhoMu * logmuTrans(t-1);
end

muTrans = exp(logmuTrans);


%% Deterministic path of discount factor shock

beta = par.beta;
betaShock = 0.01;
logbetaTrans = zeros(1,T-1);
rhoBeta = 0.975;
logbetaTrans(1) = log(beta) + (nSigma==-5)*betaShock;
for t = 2:T-1
    logbetaTrans(t) = (1-rhoBeta)*log(beta) + rhoBeta * logbetaTrans(t-1);
end

betaTrans = exp(logbetaTrans);



while errTrans > comp.tolerTrans && iterTrans<comp.maxIterTrans
    %% Path of f and q
 
    f = func.f_theta(th0,par.eta,muTrans);
    q = func.q_theta(th0,par.eta,muTrans);
    %% Solve for value functions backward given f and q path.
    for iT = T-1:-1:1
        par.lambda = lambdaTrans(iT);
        par.beta = betaTrans(iT);
        glob.output = z(1,iT)*glob.onesnXi';
        
        
        [S(:,iT), V(:,iT), s_u(:,iT), s_e(:,iT)] = ...
            iterateSurplus(S(:,iT+1),V(:,iT+1),par,func,glob,f(iT),q(iT));
        
   
        %S0_xi_min(:,iT) = kron(S(1:glob.nXi:end,iT),ones(glob.nXi,1));
        S0_xi_min(:,iT) = dprod(S(glob.selection,iT),glob.onesnXi)';
        
        quit(:,iT)  = S(:,iT) < 0; % quit decision
    end    
        
    %% Iterate on distribution forward given decisions and f/q path
    
    % disutility shock that moves all workers to highest disutility
    eInit = (nSigma ~= 0) * ss.e + (nSigma == 0) * [zeros(glob.nXi-1,1);emp];
    
    [u(1,1), e(:,1), EE(1,1), EU(1,1)] = iterateWorkerLOM(ss.u, eInit, ss.s_e, ss.s_u, ss.f, par, glob, quit(:,1));
    searchers(1,1) = s_u(1,1) * u(1,1) + par.lambda * s_e(:,1)' * e(:,1);
    
    % distrution from t=2 to T-1
    for iT = 2:T-1
        par.lambda = lambdaTrans(iT);
        [u(1,iT), e(:,iT), EE(1,iT), EU(1,iT)] = iterateWorkerLOM(u(1,iT-1), e(:,iT-1), s_e(:,iT-1), s_u(1,iT-1), f(iT-1), par, glob, quit(:,iT));
        searchers(1,iT) = s_u(1,iT)*u(1,iT) + par.lambda * s_e(:,iT)' * e(:,iT);
    end
    v = th0.*searchers;
    
    %% Free Entry: Compute market tightness path implied by distribution
    
    switch cost
        
        case 'c(n)'
                       
            thSyst = @(n) -(func.k_n(n , par.k1, par.k2, ss.n) ...
                + par.kappa ...
                - betaTrans.*(1-par.delta).*((1-par.phi).*func.q_theta((n + (1-steadyRepost)*par.gamma*(EE(1,:) + EU(1,:)) + steadyRepost*par.gamma*(ss.EE + ss.EU) + (1-par.delta)*(1- (1-par.s) * [ss.q , q(1:T-2)]).*[ss.v , v(1:T-2)] + vShock)./searchers,par.eta,muTrans).*(1-par.s).*S0_xi_min(1,2:end) + V(1,2:end))).^2;
            
        case 'c(v)'
            
            thSyst = @(n) -(func.k_n(n + (1-steadyRepost)*par.gamma*(EE(1,:) + EU(1,:)) + steadyRepost*par.gamma*(ss.EE + ss.EU) + (1-par.delta)*(1- (1-par.s) * [ss.q , q(1:T-2)]).*[ss.v , v(1:T-2)] + vShock , par.k1, ss.v/ss.n * par.k2, ss.v) ...
                + par.kappa ...
                - betaTrans.*(1-par.delta).*((1-par.phi).*func.q_theta((n + (1-steadyRepost)*par.gamma*(EE(1,:) + EU(1,:)) + steadyRepost*par.gamma*(ss.EE + ss.EU) + (1-par.delta)*(1- (1-par.s) * [ss.q , q(1:T-2)]).*[ss.v , v(1:T-2)] + vShock)./searchers,par.eta,muTrans).*(1-par.s).*S0_xi_min(1,2:end) + V(1,2:end))).^2;                        
            
        case 'c(vInflow)'
            
            thSyst = @(n) -(func.k_n(n + (1-steadyRepost)*par.gamma*(EE(1,:) + EU(1,:)) + steadyRepost*par.gamma*(ss.EE + ss.EU) + vShock, par.k1, (ss.n + par.gamma*(ss.EE + ss.EU))/ss.n * par.k2, ss.n + par.gamma*(ss.EE + ss.EU)) ...
                + par.kappa ...
                - betaTrans.*(1-par.delta).*((1-par.phi).*func.q_theta((n + (1-steadyRepost)*par.gamma*(EE(1,:) + EU(1,:)) + steadyRepost*par.gamma*(ss.EE + ss.EU) + (1-par.delta)*(1- (1-par.s) * [ss.q , q(1:T-2)]).*[ss.v , v(1:T-2)] + vShock)./searchers,par.eta,muTrans).*(1-par.s).*S0_xi_min(1,2:end) + V(1,2:end))).^2;
            
    end
    
    nVec = goldenx(thSyst,comp.thLB*ones(1,T-1),comp.thUB*ones(1,T-1));
    th1 = (nVec + (1-steadyRepost)*par.gamma*(EE(1,:) + EU(1,:)) + steadyRepost*par.gamma*(ss.EE + ss.EU) + (1-par.delta)*(1- (1-par.s) * [ss.q , q(1:T-2)]).*[ss.v , v(1:T-2)] + vShock)./searchers;

    %% Update path for market tightness
    errTrans = 100 * max(abs(th1-th0));
    iterTrans = iterTrans + 1;
    th0 = comp.omegaTrans * th0 + (1 - comp.omegaTrans) * th1;
    
end

tr.S = S;
tr.V = V;
tr.v = v;
tr.EE = EE;
tr.EU = EU;
tr.u = u;
tr.e = e;
tr.u = u;
tr.th = th1;
tr.f = f;
tr.q = q;
tr.thObs = v./u;
tr.n = v - (1-steadyRepost)* par.gamma * (EE + EU) - steadyRepost * par.gamma * (ss.EE + ss.EU) - (1-par.delta)*(1- (1-par.s) * [ss.q , q(1:T-2)]).*[ss.v , v(1:T-2)] - vShock ;
tr.s_u = s_u;
tr.s_e = s_e;

tr.z = z;
tr.lambda = lambdaTrans;
tr.mu = muTrans;
tr.beta = betaTrans;

tr.jjRate = (1-par.s) * EE./sum(e,1); % job-to-job rate
tr.ueRate = (1-par.delta) * (1-par.s) * s_u(1,:) .* f; % job finding rate for unemployed workers

tr.dn_v = (tr.n(1)-ss.n)/vShock(1);
tr.du_v = (u(2)-ss.u)/vShock(1);
tr.dv_v = (v(1)-ss.v)/vShock(1);

end