function [u1, e1, EE, EU] = iterateWorkerLOM(u0, e0, sE, sU, f0, par, glob, quit)

delta = par.delta;
lambda = par.lambda;
s = par.s;

Pq = glob.Pxi*quit; 

Lambda_u = [1 - (1-delta)*(1-s)*sU*f0, delta + (1-delta)*s + (1-delta)* (1-s) * Pq' .* (1 - lambda*f0*sE')];
Lambda_e = [zeros(glob.nXi,1) , (1-delta)*(1-s)*glob.Pxi'.*(1-quit).*(1-lambda*f0*sE')];
Lambda_e(1,:) = Lambda_e(1,:) + (1-delta)*(1-s)*[sU*f0 , lambda*f0*sE'];

Lambda = [Lambda_u;Lambda_e];
m1 = Lambda*[u0;e0];

u1 = m1(1);
e1 = m1(2:end);

EE = (1-delta) * lambda * f0 * sE' * e0; 
EU = (1-delta) * ((1-s)* Pq' * ((1 - lambda * f0 * sE) .* e0) ...
    +  s * (1 - lambda * f0 * sE') * e0);

end
