
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000
set maxvar 120000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" 
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"

local standard="noobs nonumbers nomtitles nogaps nolines"

set scheme s1color
local figbacks "plotregion(fcolor(white)) graphregion(fcolor(white) lwidth(large)) bgcolor(white)"

*****************************************************************************
*Compile de-trended values
*****************************************************************************
use 			 $temdir/fullfesample_detrended_set0, clear
	foreach g in 1 2 3 4{
	merge 1:1 ssn yearqtr using $temdir/fullfesample_detrended_set`g', gen(m`g'1)
	}
	
	foreach g of varlist logwages poste yfe* agfe* qfe* enrolle*{
		replace re_`g'=0 if re_`g'==. & `g'!=.
		}
		keep re_* ssn yearqtr
		tempfile temdet
		save `temdet'
*****************************************************************************
*CREATE SAMPLE OF NON-ENROLLERS
*****************************************************************************

use $temdir/aca_CENCOL_withwages_rr, clear


	keep if mlot1_term>2004 & mlot1_term<2009.2
	keep if enrol_12301==0 
	egen keepflag=tag(yearqtr ssn)
	keep if keepflag
	gen controlgroup=1
	keep ssn agefor year qtr enrolled_8* logwage yearqtr
	gen treatmentgroup=0
		foreach g in 1 2 3 4 5{
		gen pposte`g'=0 
		}
		gen poste=0
		gen morecoh=1
		gen maincoh=1
	save $temdir/CENCOL_nonenrollers_forfe, replace

	
**************************************************************************************************	

use $temdir/aca_CENCOL_withwages_rr, clear
keep if mlot1_term<2009.3
keep ssn
replace ssn=substr(ssn,1,9)
duplicates drop
tempfile temp
save `temp'

	use $anadir/c123010_all_cleaned, clear
	merge m:1 ssn using $anadir/c123010_firstcchars

	*Measures for type of admissions
	*College
		destring firstenrcol, gen(colnum2)
		bysort colnum2: egen tott=total(tagflag)
		tab colnum2 if tagflag
		gen numcol=colnum2*(tott>100)
	gen admission_comp=inlist(numcol,621,611,231,521,661,821,971,641,861,931,721,441,22 ,451,31 ,841,141,51 ,592,461,681,851,941,61 ,771,881,961,891,982,71 ,551,372,871,651,781,561,271,91 ,582,291)==1
	gen admission_lott=inlist(numcol,111,811,311,748,571,742,744,313,344,431,361,991,747,334,745,471,731,832,741,523,233,261,482,531)==1
	gen admission_pure=inlist(numcol,111,811,311,748,571,742,744,313,344,431,361,991)==1
	gen admission_oth=inlist(numcol ,411,421,241,171,281,161,711,621,746)==1

	rename age2 agefor
	rename logwage logwages
	gen treatmentgroup=1	
	append using $temdir/CENCOL_nonenrollers_forfe

	drop agfe* yfe* qfe* year qtr
	gen year=floor(yearqtr)
	gen qtr=yearqtr-year
	qui tab agefor, gen(agfe)
	qui tab year, gen(yfe)
	qui tab qtr, gen(qfe)
	replace ssn=substr(ssn,1,9)
	merge m:1 ssn using `temp', gen(mCENCOL)
	
		
		global optionss "label se nonotes  nogaps nomtitles noobs nonumbers nolines "
	gen sampeCENCOL=( firstenrcol=="CENCOL" | mCENCOL==3)
	
	merge m:1 ssn yearqtr using `temdet', gen(mergetem)
		rename re_logwag RELOGWA


keep if maincoh==1
**************************
*Draw Pictures
**************************
gen ys=(4*(yearqtr-firstenrt))+18
forvalues y=1/39{
	gen qyfe`y'=ys==`y'
	}
			mat a=-18,0,0
			reg logwage qyfe* yfe* qfe* agfe* enrolled_8 if treatmentgroup==1, cluster(ssn)
			forvalues y=1/39{
				local b=`y'-18
				mat b=`b',_b[qyfe`y'], _se[qyfe`y']
				mat a=a\b
				}
			mat c=-18,0,0
			reg logwage qyfe* yfe* qfe* agfe* enrolled_8 if treatmentgroup==1 & sampe57==1, cluster(ssn)
			forvalues y=1/39{
				local b=`y'-18
				mat b=`b',_b[qyfe`y'], _se[qyfe`y']
				mat c=c\b
				}
				mat a=a,c
				preserve
				clear
				svmat a
				gen u=a2+2*a3
				gen l=a2-2*a3
				
				gen u5=a5+2*a6
				gen l5=a5-2*a6
				
				twoway scatter a2 u l a5 u5 l5 a1 if a1>-21, xscale(r(-20(4)21)) xlabel(-20(4)21) yline(0) ylab(, nogrid) lcolor(black black black gray gray gray) mcolor(black black black gray gray gray) connect(l l l l l l) msymbol(Oh none none O none none) lpattern(solid dash dash solid dash dash) `figbacks' ytitle("Log Earnings") xtitle("Quarters Since Start Program") legend(order(4 "Central College" 1 "California"))
						graph export  "$outdir/rr/fe_byq_cacc.eps", replace
				restore
	
		*/
**************************
*Regressions
**************
*cycle through cohorts


label var poste "Start Program"
eststo clear
		eststo d1: reg logwage poste yfe* qfe* agfe* enrolled_8 if treatmentgroup==1, cluster(ssn)
			gen esss=e(sample)
		eststo d2: reg logwage poste yfe* qfe* agfe* enrolled_8 if sampeCENCOL==1 & treatmentgroup==1,  cluster(ssn)
		eststo d3: reg logwage poste yfe* qfe* agfe* enrolled_8 if admission_pure==1 & treatmentgroup==1,  cluster(ssn)
		eststo d4: reg logwage poste yfe* qfe* agfe* enrolled_8 if admission_pure!=1 & treatmentgroup==1,  cluster(ssn)
	

		eststo t1: areg logwage poste yfe* qfe* agfe* enrolled_8 if treatmentgroup==1, absorb(ssn) cluster(ssn)
		eststo t2: areg logwage poste yfe* qfe* agfe* enrolled_8 if sampeCENCOL==1 & treatmentgroup==1, absorb(ssn) cluster(ssn)
		eststo t3: areg logwage poste yfe* qfe* agfe* enrolled_8 if admission_pure==1 & treatmentgroup==1, absorb(ssn) cluster(ssn)
		eststo t4: areg logwage poste yfe* qfe* agfe* enrolled_8 if admission_pure!=1 & treatmentgroup==1, absorb(ssn) cluster(ssn)
		
		eststo f1: reg RELOG re_* if treatmentgroup==1 & esss==1, cluster(ssn)
		eststo f2: reg RELOG re_* if sampeCENCOL==1 & treatmentgroup==1  & esss==1,  cluster(ssn)
		eststo f3: reg RELOG re_* if admission_pure==1 & treatmentgroup==1  & esss==1, cluster(ssn)
		eststo f4: reg RELOG re_* if admission_pure!=1 & treatmentgroup==1  & esss==1,  cluster(ssn)
				
		
esttab *1 using  "$outdir/rr/reg_mainfetable1_allp_.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")
esttab *2 using  "$outdir/rr/reg_mainfetable2_allp_.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")
esttab *3 using  "$outdir/rr/reg_mainfetable3_allp_.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")
esttab *4 using  "$outdir/rr/reg_mainfetable4_allp_.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")



*run it without controlling for enrollment
label var poste "Start Program"
eststo clear
			drop ess
		eststo d1: reg logwage poste yfe* qfe* agfe*   if treatmentgroup==1, cluster(ssn)
			gen esss=e(sample)
		eststo d2: reg logwage poste yfe* qfe* agfe*   if sampeCENCOL==1 & treatmentgroup==1,  cluster(ssn)
		eststo d3: reg logwage poste yfe* qfe* agfe*   if admission_pure==1 & treatmentgroup==1,  cluster(ssn)
		eststo d4: reg logwage poste yfe* qfe* agfe*   if admission_pure!=1 & treatmentgroup==1,  cluster(ssn)
	

		eststo t1: areg logwage poste yfe* qfe* agfe*   if treatmentgroup==1, absorb(ssn) cluster(ssn)
		eststo t2: areg logwage poste yfe* qfe* agfe*   if sampeCENCOL==1 & treatmentgroup==1, absorb(ssn) cluster(ssn)
		eststo t3: areg logwage poste yfe* qfe* agfe*   if admission_pure==1 & treatmentgroup==1, absorb(ssn) cluster(ssn)
		eststo t4: areg logwage poste yfe* qfe* agfe*   if admission_pure!=1 & treatmentgroup==1, absorb(ssn) cluster(ssn)
		
		rename re_enrolled dre_enrolled
		eststo f1: reg RELOG re_* if treatmentgroup==1 & esss==1, cluster(ssn)
		eststo f2: reg RELOG re_* if sampeCENCOL==1 & treatmentgroup==1  & esss==1,  cluster(ssn)
		eststo f3: reg RELOG re_* if admission_pure==1 & treatmentgroup==1  & esss==1, cluster(ssn)
		eststo f4: reg RELOG re_* if admission_pure!=1 & treatmentgroup==1  & esss==1,  cluster(ssn)
		rename dre_enrolled re_enrolled_8		
		
esttab *1 using  "$outdir/condacc/reg_mainfetable1_noenr_allp_`samp'.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")
esttab *2 using  "$outdir/condacc/reg_mainfetable2_noenr_allp_`samp'.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")
esttab *3 using  "$outdir/condacc/reg_mainfetable3_noenr_allp_`samp'.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")
esttab *4 using  "$outdir/condacc/reg_mainfetable4_noenr_allp_`samp'.tex"    , replace nostar rename(re_poste poste)  keep(poste )	stat(N N_clust , label("N" "Students" )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ")


*/

*****************************************************************************
*Scatterplot graph of colleges
******************************************************************************

	keep if maincoh==1
		drop colnum2 tott 
		destring firstenrcol, gen(colnum2)
		bysort colnum2: egen tott=total(tagflag)
		tab colnum2 if tagflag
		gen colnum=colnum2*(tott>100)
foreach var in colnum{
		levelsof `var', local(l`var')
	mat c`var'=.,.,.
	mat cw`var'=.,.,.,.
	
	foreach c of local l`var'{
		di `c'
		qui reg RELOG re_* if treatmentgroup==1 & `var'==`c' , cluster(ssn) 
		mat B=e(b)
		local bb=round(B[1,1],0.001)
		mat V=e(V)
		local se=round(sqrt(V[1,1]),0.001)
		mat cc=`bb',`se',`c'
		mat c`var'=c`var'\cc
		mat list ccolnum

		sum admission_lott
			local ttt=r(mean)
		qui reg logwage poste yfe* qfe* agfe* enrolled_8 if treatmentgroup==1 & `var'==`c' ,  cluster(ssn) 
		mat B=e(b)
		local bb=round(B[1,1],0.001)
		mat V=e(V)
		local se=round(sqrt(V[1,1]),0.001)
		mat cc=`bb',`se',`c',`ttt'
		mat cw`var'=cw`var'\cc
		

		}		
		
		preserve
		clear
		mat c=c`var',cw`var'
		svmat c
		save $temdir/rrforgraph_c`var', replace
		restore
		}
	preserve	
	use $temdir/rrforgraph_ccolnum, clear
	sort c1
	gen firstenrcol=c3
	tostring firstenr, replace
	replace firstenr="0"+firstenr if length(firstenr)<3
	merge 1:1 firstenrcol using $temdir/forgraph_ccolnum_weights
	
	keep if c1!=.
	sort c1
	gen rank=_n
			label values rank toplab
	local z=_N
	gen x=c4*1.1
	gen y=c4*1.1
		serrbar c1 c2 rank, addplot(scatter c1 rank if c3==CENCOL, msymbol(S) mcolor(black) ) mvopts(mcolor(gray))  lcolor(gray) `figbacks' xtitle("Colleges, Ranked by Estimated Effect") ytitle("Coefficient (Log Earnings)")  yline(0.123, lpattern(dash))  xtitle("Colleges, Ranked by Coefficient") xscale(r(0(`z')`z'))  xlabel(0(`z')`z', valuelabel )  yscale(r(-.2(0.2)1.0)) ylabel(-.2(0.2)1.0, nogrid)  yline(0, lcolor(black)) legend(off)
		graph export "$outdir/condacc/serrbar_colnum.eps", replace
		
		twoway (scatter c1 c4 , msymbol(o) mcolor(gray))(scatter c1 c4 if c3==CENCOL , msymbol(S) mcolor(black))(line y x, lcolor(black) lpattern(solid)), yline(0, lcolor(black)) `figbacks'  ytitle("Fixed Effects Coefficient (log earnings)")  xtitle("Pre-Post Coefficient (log earnings)") yscale(r(-0.2(0.2)1.4)) ylabel(-0.2(0.2)1.4) xscale(r(-0.2(0.2)1.4)) xlabel(-0.2(0.2)1.4) legend( order(2 "Central College" 3 "45-degrees"))
		graph export "$outdir/condacc/dots_colnum.eps", replace		

*/
*/
******************************************************************************
*Heterogeneity table
******************************************************************************
 preserve
	insheet using $anadir/transfer_rate_0004.csv, clear
		rename v1 col 
		sum rate, det
		gen c_tranra=rate>r(p50)
		keep col c_tranra
		keep if col!=.
		tempfile temptranrate
		save `temptranrate'
	use /home/research/cavoced/tasks/data/TOP_ONET_data, clear
		keep top6 vocflag
		duplicates drop
		gen voced_flag=vocflag=="*"
		tempfile tempcte
		save `tempcte'
		use /home/research/cavoced/tasks/data/academicfile_topcollevel, clear
			merge m:1 top6 using `tempcte'
			keep if year>2001 & year<2005
			gen units=aw_units
			gen vawunits=aw_units*voced_flag
			collapse(sum) units vawunits, by(col)
			gen shvaw=vaw/units
			sum shva, det
			gen c_vochigh=shva>r(p50)
			keep col c_vo
			merge m:1 col using $anadir/colstuff_bycounty2, gen(zop)
			merge m:1 col using `temptranrate', gen(zop2)
			drop zop*
	tempfile tempcollist
		save `tempcollist'
restore
			destring firstenrcol, gen(col)
			drop _merge
			merge m:1 col using `tempcollist' , gen(zop3)
			drop zop
				renpfix hisp_ c_
	gen preear=exp(logwage) if poste==0
		replace preear=0 if preear==. & poste==0
		bysort ssn: egen meanpreear=mean(preear)
		sum meanpreear if tagflag, det
		gen c_preear=meanpreear>r(p50)
	bysort gstartc: egen c_passrate=mean(awa_d_123010)
		sum c_passrate, det
		replace c_passrate=c_passrate>r(p50)
		gen c_racew=race_W
		gen c_raceb=race_B
		gen c_raceh=race_H
		gen c_racea=race_A
		gen c_sexm=sex_M
		gen c_sexf=sex_F
		gen c_age30p=(minterm-birth)>=30
		gen c_age30l=(minterm-birth)<30
		gen c_aaahi=aaa>470
		gen c_medwa=himeda_rel==1
		gen c_medem=himeda_sh==1
		gen c_nurwa=hinurs_rel==1
		gen c_nurem=hinurs_sh==1
		gen c_nclex=nclex_hi==1
		gen c_medanurs=himedanurs_wag==1
		gen c_adcomp=admission_comp
		gen c_adlott=admission_lott
		gen c_adpu=admission_pure	
		gen c_waitlist=admission_oth
		gen c_numcol=numcolinco>1 if numcolinco!=.
		
	*Interactions
	eststo clear
	gen c_racemin=(race_H==1 | race_B==1)

	foreach g in  preear racemin age30p sexf  hosp ltc  age60p medwa medem nurwa nurem medanurs nclex aaahi passrate adpu adlott adcomp waitlist vochigh tranra{
		gen pc_`g'=poste*c_`g'
		}
		
		label var postany "Main Effect"
		label var pc_racemin "Minority"
		label var pc_sexf "Female"
		label var pc_age30p "Older than 30"
		label var pc_hosp "Hospital Beds"
		label var pc_ltc "Long-Term Care Beds"
		label var pc_age60p "Share Older than 60"
		label var pc_aaahi "ADN Graduates in 2004"
		label var pc_medwa "Med. Asst. Relative Wage"
		label var pc_medem "Med. Asst. Employment"
		label var pc_nurwa "RN Relative Wage"
		label var pc_nurem "RN Employment"
		label var pc_adpu "Lottery "
		label var pc_adlott "Other Randomized "
		label var pc_adcomp "Competitive "
		label var pc_waitlist "Waitlist "
		label var pc_medanurs "Nurse-Med Assistant Relative Wage"
		label var pc_nclex "NCLEX Pass Rate"
		label var pc_passrate "Program Completion Rate"
		
	mat diffmat=.,.,.,.,.,.,.,.	
		local i=1
	foreach g in  preear racemin age30p sexf hosp ltc  age60p medwa medem nurwa nurem medanurs nclex aaahi passrate adpu adlott adcomp waitlist vochigh tranra{
		
				reg logwage if treatmentgroup==1 & maincoh==1 & c_`g'==1, cluster(ssn)
					scalar clu1=e(N_clust)
					local cl1=clu1
				eststo t1: reg RELOG re_* if treatmentgroup==1 & maincoh==1 & c_`g'==1
					local z1=_b[re_poste]
					scalar n1=e(N)
					local n1=n1
				reg logwage if treatmentgroup==1 & maincoh==1 & c_`g'==0, cluster(ssn)
					scalar clu2=e(N_clust)
					local cl2=clu2
				eststo t2:  reg RELOG re_* if treatmentgroup==1 & maincoh==1 & c_`g'==0, 
					local z2=_b[re_poste]
					scalar n2=e(N)
					local n2=n2
					local diff=`z1'-`z2'
					suest t1 t2, cluster(ssn)
					test [t1_mean]re_poste=[t2_mean]re_poste
					local chi=r(chi2)
					local ppp=r(p)
					mat zzz=`i',`diff',`chi',`ppp',`n1',`n2', `cl1',`cl2'
					mat diffmat=diffmat\zzz
					mat list diffmat
				estimates save "$temdir/fehet_`g'" , replace
			
			local i=`i'+1
			}
		preserve
		clear
		svmat diffmat
		save $outdir/fehet_results, replace
		restore

