****************************************************************************************************
* This dofile produces all tables and figures in the online appendix of Bohlmark and Willén (2018) *
****************************************************************************************************
* Verified: November 16, 2018
   
************
* TABLE A2 *
************

use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
keep if searchsamp==0
drop if treat==0
tab treat

* Note: treat yields the fraction of the decate treated. Treat equal to 1 thus means that the neighborhood tipped in 1990.

************
* TABLE A3 *
************

* NOTE: Pick Donut hole size on rows 13-18. Currently estimates effect with a 2.00 donut hole. 

* Loading the data  
use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear

* Imposing sample restrictions
keep if kommun==1 | kommun==1280 | kommun==1480
keep if searchsamp==0

* Excluding observations near TP (generating the donut hole)
drop if d1_fpneg>-0.05 & d1_fpneg<0.05 // 0.1 Donut Hole
drop if d1_fpneg>-0.15 & d1_fpneg<0.15 // 0.3 Donut Hole
drop if d1_fpneg>-0.25 & d1_fpneg<0.25 // 0.5 Donut Hole
drop if d1_fpneg>-0.5  & d1_fpneg<0.5 // 1 Donut Hole
drop if d1_fpneg>-1    & d1_fpneg<1 // 2 Donut Hole

* Performing the regression
	estimates clear	
	xi: reg Dn1990 past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)

************
* TABLE A4 *
************

* Preliminary estimation commands
	clear
	set mem 64m
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposureSWE_W.dta", clear 
	sort k2	

* Constraining the sample 
	keep if searchsamp==0
	keep if kommun==1 | kommun==1280 | kommun==1480
	estimates clear

* Running the regression
	local var "Dn1990 Dwest1990 DnonWest1990"
	foreach x of local var {
	
	xi: reg `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_1
		}

* Displaying the results 
	estimates table _all, se stats(N) keep(past_fpneg)
	estimates table _all, star(0.1 0.05 0.01) keep(past_fpneg)
	

************
* TABLE A5 *
************

* Preliminary estimation commands 
use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
keep if kommun==1 | kommun==1280 | kommun==1480
keep if searchsamp==0

* Generating additional necessary variable (fifth order polynomial)
	gen d5_fpneg=d1_fpneg^5
	 
* Population Density
	merge m:1 sams using "P:\2016\79\DTA files segregation\SAMS_areal.dta"
	drop if _merge==2
	gen density=sN_tot1990/areal
	drop _merge
	 
* Estimation
quietly {
estimates clear
	
	local var "Dn1990"
	foreach x of local var {
	
	regress  `x' past_fpneg d1_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_1
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_2
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_3
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_4
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_5
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg d5_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_6
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female int1_fpneg int2_fpneg int3_fpneg int4_fpneg i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_7
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female ysm socialbidrag Nhemmabarn0_15 i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_8
	
	regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg loginc ys female density i.kommun [aw=sN_tot1990], cluster(cluster2)
	estimates store `x'_9
	
	}
	}
	estimates table _all, se stats(N r2) keep(past_fpneg)
	estimates table _all, star(0.1 0.05 0.01) keep(past_fpneg)
	
************
* TABLE A6 *
************

* Preliminary estimation commands
	clear
	set mem 64m
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
	sort k2
	
* Throwing out the 2/3 of the sample used for identifying the TP
	keep if searchsamp==0
	keep if main==1

* Identifying optimal bandwidth using the cross-validation method of Ludwig and Miller (2007)
	rdbwselect past_fpneg d1_fpneg loginc ys female i.kommun, bwselect(CV)
	* Cross-validation suggests 11.58483

* Constraining Window
	keep if d1_fpneg>-11.58483 & d1_fpneg<11.58483

* Estimating the regressions
	reg  Di1990 past_fpneg d1_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	reg  Dtot_sams1990 past_fpneg d1_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)
	reg  Dn1990 past_fpneg d1_fpneg loginc ys female i.kommun [aw=sN_tot1990], cluster(cluster2)


************
* TABLE A7 *
************

	****************
	* YOUNG COHORT *
	****************


	* Opening the data and restricting to analysis sample
		use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
		keep if kommun90==1 | kommun90==1280 | kommun90==1480
		 
	* Creating dummy variables for missing parental characteristics	 
		foreach i in ysmamma yspappa parint parage {
		drop if `i'==.
		}

	* Sample Selection
		keep if immback==0
		keep if searchsamp==0
		keep if fodar>=1980&fodar<=1990

	* Stratification variables to investigate selectivity on 
		
		* i. Parental education
		gen ed_int=0
		replace ed_int=1 if ysmamma>12 | yspappa>12

		* ii. Parental income 
		preserve
		gen highinc=.
		sum parint, detail
		replace highinc=1 if parint>r(p75)
		replace highinc=0 if parint<r(p25)
		keep persid highinc
		tempfile tl
		save "`tl'", replace
		restore
		merge 1:1 persid using `tl'
		drop _merge
		
		* iii. Dropping outliers
		preserve 
		drop if d1_fpneg>42 & kommun90==1
		drop if d1_fpneg>34 & kommun90==1480
		drop if d1_fpneg>35 & kommun90==1280
		gen noout=1
		save "`tl'", replace
		restore
		merge 1:1 persid using `tl'
		drop _merge

	* Getting treatment measure for 90 and 00 sams area
		preserve 
		use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
		ren sams sams90
		keep sams90 treat
		tempfile abss
		save `abss'
		restore
		
		merge m:1 sams90 using `abss'
		tab _merge
		drop _merge
		
		preserve
		use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
		ren sams sams00
		keep sams00 treat
		ren treat treat00
		tempfile abssa
		save `abssa'
		restore
		
		merge m:1 sams00 using `abssa'	
		tab _merge
		drop _merge
			
	* Generating depend. variables 
		 gen CtoT=0
		 replace CtoT=1 if sams90!=sams00 & treat==0 & treat00==1
		 
		 gen TtoC=0
		 replace TtoC=1 if sams90!=sams00 & treat==1 & treat00==0

	* Keeping only natives
		 keep if immback==0

	* Treatment variables of interest	 
		gen d2_fpneg=d1_fpneg*d1_fpneg
		gen d3_fpneg=d1_fpneg^3
		gen d4_fpneg=d1_fpneg^4

	* Cluster for se
		gen cluster2=round(d1_fpneg,1)

	* Estimation
		local var "CtoT TtoC"
		foreach x of local var {
		estimates clear
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon i.fodar i.kommun90,  				cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon i.fodar i.kommun90 if ed_int==1,  	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon i.fodar i.kommun90 if ed_int==0, 	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon i.fodar i.kommun90 if highinc==1, 	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon i.fodar i.kommun90 if highinc==0, 	cluster(cluster2)
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg 	i.fodar i.kommun90 if kon==1, 		cluster(cluster2)
		eststo: regress  `x' past_fpneg d2_fpneg d3_fpneg d4_fpneg 		        i.fodar i.kommun90 if kon==2, 		cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon i.fodar i.kommun90 if noout==1, 	cluster(cluster2)
		esttab using "P:\2016\79\Young_selective_migr.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}
			
	*****************
	* MIDDLE COHORT *
	*****************

	* Opening the data 
		use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
		estimates clear 

	* Keeping analysis sample 
		keep if kommun90==1 | kommun90==1280 | kommun90==1480
		keep if fodar>=1973&fodar<=1983
		keep if immback==0
		keep if searchsamp==0

	* Dummy variables for missing parental characteristics 
		foreach i in ysmamma yspappa parint parage {
		drop if `i'==.
		}

	* Stratification variables to investigate selectivity on 
		
		* i. Parental education
		gen ed_int=0
		replace ed_int=1 if ysmamma>12 | yspappa>12

		* ii. Parental income
		preserve
		gen highinc=.
		sum parint, detail
		replace highinc=1 if parint>r(p75)
		replace highinc=0 if parint<r(p25)
		keep persid highinc
		tempfile tl
		save "`tl'", replace
		restore
		merge 1:1 persid using `tl'
		drop _merge
		
		* iii. Eliminating outliers
		preserve 
		drop if d1_fpneg>42 & kommun90==1
		drop if d1_fpneg>34 & kommun90==1480
		drop if d1_fpneg>35 & kommun90==1280
		gen noout=1
		save "`tl'", replace
		restore
		merge 1:1 persid using `tl'
		drop _merge

	* Sams area and treat variable in 1990 and 2000
		preserve 
		use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
		ren sams sams90
		keep sams90 treat
		tempfile abss
		save `abss'
		restore
		
		merge m:1 sams90 using `abss'
		tab _merge
		drop _merge
		
		preserve
		use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
		ren sams sams00
		keep sams00 treat
		ren treat treat00
		tempfile abssa
		save `abssa'
		restore
		
		merge m:1 sams00 using `abssa'
		tab _merge
		drop _merge
			
	* Generating dep. variables
		 gen CtoT=0
		 replace CtoT=1 if sams90!=sams00 & treat==0 & treat00==1
		 
		 gen TtoC=0
		 replace TtoC=1 if sams90!=sams00 & treat==1 & treat00==0

		 keep if immback==0

	* Generating relevant polys
		gen d2_fpneg=d1_fpneg*d1_fpneg
		gen d3_fpneg=d1_fpneg^3
		gen d4_fpneg=d1_fpneg^4

	* Cluster variable for se	
		gen cluster2=round(d1_fpneg,1)

	* Keeping natives
		keep if immback==0

	* Estimation
		local var "CtoT TtoC"
		foreach x of local var {
		estimates clear
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  i.fodar i.kommun90,  				cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  i.fodar i.kommun90 if ed_int==1,  	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  i.fodar i.kommun90 if ed_int==0, 	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  i.fodar i.kommun90 if highinc==1, 	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  i.fodar i.kommun90 if highinc==0, 	cluster(cluster2)
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg 	 i.fodar i.kommun90 if kon==1, 		cluster(cluster2)
		eststo: regress  `x' past_fpneg d2_fpneg d3_fpneg d4_fpneg 	  	         i.fodar i.kommun90 if kon==2, 		cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  i.fodar i.kommun90 if noout==1, 	cluster(cluster2)
		esttab using "P:\2016\79\Middle_selective_migration.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}
		
	**************
	* OLD COHORT *
	**************

	* Opening the data
	use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
	estimates clear 

	* Keeping the analysis sample
	keep if kommun90==1 | kommun90==1280 | kommun90==1480
	keep if fodar>=1948&fodar<=1958
	keep if immback==0
	keep if searchsamp==0

	* Dummy variables for missing information, to be consistent with other cohorts
	foreach i in ys90 inc_NOarbers90 {
	drop if `i'==.
	}

	* Stratification variables to investigate selectivity on 
		* i. Education
		gen ed_int=0
		replace ed_int=1 if ys90>12

		* ii. Income 
		preserve
		gen highinc=.
		sum inc_NOarbers90, detail
		replace highinc=1 if inc_NOarbers90>r(p75)
		replace highinc=0 if inc_NOarbers90<r(p25)
		keep persid highinc
		tempfile tl
		save "`tl'", replace
		restore
		merge 1:1 persid using `tl'
		drop _merge
		
		* iii. Eliminating outliers
		preserve 
		drop if d1_fpneg>42 & kommun90==1
		drop if d1_fpneg>34 & kommun90==1480
		drop if d1_fpneg>35 & kommun90==1280
		gen noout=1
		save "`tl'", replace
		restore
		merge 1:1 persid using `tl'
		drop _merge

	* Treat variables for sams area in 1990 and 2000 

		preserve 
		use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
		ren sams sams90
		keep sams90 treat
		tempfile abss
		save `abss'
		restore
		
		merge m:1 sams90 using `abss'
		tab _merge
		drop _merge
		
		preserve
		use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
		ren sams sams00
		keep sams00 treat
		ren treat treat00
		tempfile abssa
		save `abssa'
		restore
		
		merge m:1 sams00 using `abssa'
		tab _merge
		drop _merge
			
	* Dep. variables
		 gen CtoT=0
		 replace CtoT=1 if sams90!=sams00 & treat==0 & treat00==1
		 gen TtoC=0
		 replace TtoC=1 if sams90!=sams00 & treat==1 & treat00==0

	* Keeping natives and creating polys
		keep if immback==0
		gen d2_fpneg=d1_fpneg*d1_fpneg
		gen d3_fpneg=d1_fpneg^3
		gen d4_fpneg=d1_fpneg^4

	* Generating cluster for se
		gen cluster2=round(d1_fpneg,1)

	* Estimation
		local var "CtoT TtoC"
		foreach x of local var {
		estimates clear
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon 	i.fodar i.kommun90,  				cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  	i.fodar i.kommun90 if ed_int==1,  	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon 	i.fodar i.kommun90 if ed_int==0, 	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  	i.fodar i.kommun90 if highinc==1, 	cluster(cluster2) 
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  	i.fodar i.kommun90 if highinc==0, 	cluster(cluster2)
		eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg 	   	i.fodar i.kommun90 if kon==1, 		cluster(cluster2)
		eststo: regress  `x' past_fpneg d2_fpneg d3_fpneg d4_fpneg 		       		i.fodar i.kommun90 if kon==2, 		cluster(cluster2) 
		eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg kon  	i.fodar i.kommun90 if noout==1, 	cluster(cluster2)
		esttab using "P:\2016\79\Old_selective_migration.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
		}


************
* TABLE A8 *
************

* To change between immigrant and native outcomes, change the immback command on row 520

* Opening the data
	use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
	ren persid dnr201597
	estimates clear 

* Keeping the relevant sample
	keep if kommun90==1 | kommun90==1280 | kommun90==1480

* Generating necessary polys
	gen d2_fpneg=d1_fpneg*d1_fpneg
	gen d3_fpneg=d1_fpneg^3
	gen d4_fpneg=d1_fpneg^4

* Creating cluster variable for se	
	gen cluster2=round(d1_fpneg,1)

* Merging with the military enlistment score data	
	merge 1:1 dnr201597 using "P:\2016\79\DTA files segregation\Outcomes_Military"

* Sample selection	
	keep if fodar>=1973&fodar<=1983
	keep if kommun90==1 | kommun90==1280 | kommun90==1480
	keep if _merge==3
	drop _merge
	ren dnr201597 persid

* Dummy variables for missing parental characteristics
	foreach i in ysmamma yspappa parint parage {
	gen miss`i'=`i'==.
	replace `i'=0 if miss`i'==1
	}
	
* Further sample selection	
	keep if immback==0
	keep if kon==1
	keep if searchsamp==0

* Running the regressions	
	local var "noncogn_cap cogn_cap"
	foreach x of local var {
	estimates clear
	eststo: xi: areg `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar, absorb(kommun90)  cluster(cluster2) level(90)
	esttab using "P:\2016\79\EnlistScore1.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
	}
	
* Running the regressions for constrained cohort sample	
	keep if fodar<1981
	local var "noncogn_cap cogn_cap"
	foreach x of local var {
	estimates clear
	eststo: xi: areg `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar, absorb(kommun90)  cluster(cluster2) level(90)
	esttab using "P:\2016\79\EnlistScore2.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
	}
	

************
* TABLE A9 *
************

* Note: Change immback variable on rows 727 and 743 to get values for natives or non-western immigrants. Current setting yeilds the results in Columns 1 and 2. 

* Preliminary: Retrieving the sams area of the young cohort in 1991-1995 (they are not in Louise as below registry age)
forvalues i=1(1)5 {
use "P:\2016\79\Leverans\Louisegeo199`i'.dta", clear
destring dnr201597, replace
keep dnr201597 kommun sams
destring sams, force replace

ren dnr201597 dnr201597m
ren sams sams9`i'
rename kommun kommun9`i'
tempfile Mamma
save "`Mamma'", replace

ren dnr201597m dnr201597f
tempfile Pappa
save "`Pappa'", replace

use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
rename persid dnr201597
merge 1:1 dnr201597 using "P:\2016\79\DTA files segregation\outcome_sample_par_id"	// Holder which links child id to parental id
drop if _merge==2
drop _merge
ren dnr201597 persid

merge m:1 dnr201597m using "`Mamma'"		// Assume lives with mother, unless missing, in which case father
drop if _merge==2
drop _merge
merge m:1 dnr201597f using "`Pappa'", update 
drop if _merge==2
drop _merge

replace sams9`i'=. if 199`i'-fodar>=16		// Get these directly from LOUISE as above 16 
replace kommun9`i'=. if 199`i'-fodar>=16	// Get these directly from LOUISE as above 16

tempfile holder
save "`holder'", replace

* This code retrieves the sams area of the middle and old cohorts in year i
use "P:\2016\79\Leverans\Louisegeo199`i'.dta", clear

destring dnr201597, replace
keep dnr201597 kommun sams
destring sams, force replace

ren dnr201597 persid
ren sams sams9`i'
rename kommun kommun9`i'

tempfile holder2
save "`holder2'", replace

use "`holder'", clear
merge 1:1 persid using "`holder2'", update
drop if _merge==2
drop _merge

save "P:\2016\79\DTA files segregation\sams9`i'.dta", replace
}

* Preliminary: Retrieving the sams area of the young cohort in 1996-1999 (some of these are not in Louise as below age 16)

forvalues i=6(1)9 {
	use "P:\2016\79\Leverans\Louisegeo199`i'.dta", clear
	destring dnr201597, replace
	keep dnr201597 kommun sams
	destring sams, force replace

	ren dnr201597 dnr201597m
	ren sams sams9`i'
	rename kommun kommun9`i'
	tempfile Mamma
	save "`Mamma'", replace

	ren dnr201597m dnr201597f
	tempfile Pappa
	save "`Pappa'", replace

	use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
	rename persid dnr201597
	merge 1:1 dnr201597 using "P:\2016\79\DTA files segregation\outcome_sample_par_id"
	drop if _merge==2
	drop _merge
	ren dnr201597 persid
	merge m:1 dnr201597m using "`Mamma'"
	drop if _merge==2
	drop _merge
	merge m:1 dnr201597f using "`Pappa'", update 
	drop if _merge==2
	drop _merge

	replace sams9`i'=. if 199`i'-fodar>=16
	replace kommun9`i'=. if 199`i'-fodar>=16

	tempfile holder
	save "`holder'", replace

* This code retrieves the sams area of the 1974 and 1958 cohorts
	use "P:\2016\79\Leverans\Louisegeo199`i'.dta", clear

	destring dnr201597, replace
	keep dnr201597 kommun sams
	destring sams, force replace

	ren dnr201597 persid
	ren sams sams9`i'
	rename kommun kommun9`i'

	tempfile holder2
	save "`holder2'", replace

	use "`holder'", clear
	merge 1:1 persid using "`holder2'", update
	drop if _merge==2
	drop _merge

	save "P:\2016\79\DTA files segregation\sams9`i'.dta", replace
}
*

* Creating data set with sams areas and their 1990 tipping status, for each year for all sams in our analysis sample (will use to populate 1990 tipping status variable further down in file)
use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
keep sams90 past_fpneg
forvalues i=1(1)10 {
	preserve
		gen sams9`i'=sams90
		gen past_fpneg9`i'=past_fpneg 
		keep sams9`i' past_fpneg9`i'
		bysort sams9`i': gen dup=cond(_N==1,0,_n)
		drop if dup>1
		drop dup
		save "P:\2016\79\DTA files segregation\temp_`i'.dta", replace
	restore
}
*

* Creating set with residential location for each individual for each year of the decade
use "P:\2016\79\DTA files segregation\sams91.dta", clear
keep persid sams91
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams92.dta"
keep persid sams91 sams92
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams93.dta"
keep persid sams91 sams92 sams93
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams94.dta"
keep persid sams91 sams92 sams93 sams94
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams95.dta"
keep persid sams91 sams92 sams93 sams94 sams95
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams96.dta"
keep persid sams91 sams92 sams93 sams94 sams95 sams96
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams97.dta"
keep persid sams91 sams92 sams93 sams94 sams95 sams96 sams97
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams98.dta"
keep persid sams91 sams92 sams93 sams94 sams95 sams96 sams97 sams98
merge 1:1 persid using "P:\2016\79\DTA files segregation\sams99.dta"
keep persid sams91 sams92 sams93 sams94 sams95 sams96 sams97 sams98 sams99

merge 1:1 persid using "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear

keep persid sams90 sams91 sams92 sams93 sams94 sams95 sams96 sams97 sams98 sams99 sams00
rename sams00 sams910
save "P:\2016\79\DTA files segregation\Temp.dta", replace

* Using the files saved on row 679 to populate the 1990 tipping status for each of the sams that the individual lived in during the decade
use "P:\2016\79\DTA files segregation\Temp.dta", clear
forvalues i=1(1)10 {
	merge m:1 sams9`i' using "P:\2016\79\DTA files segregation\temp`i'.dta"
	drop if _merge==2
	drop _merge
}

* Adding outcomes and background characteristics
merge 1:1 persid using "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear

* Keeping analytical municipalities
keep if kommun90==1 | kommun90==1280 | kommun90==1480

* Obtaining the numbers displayed in Table A9
	* All: Treatment
		preserve 
			keep if searchsamp==0
			* keep if immback== // 1 for non-western immigrants, 0 for natives
			forvalues i=1(1)10 {
				quietly {
					count if past_fpneg==1 & sams90!=. & sams91!=. & sams92!=. & sams93!=. & sams94!=. & sams95!=. & sams96!=. & sams97!=. & sams98!=. & sams99!=. & sams910!=. 
					local T_`i'=r(N)
					count if past_fpneg==1 & sams90==sams9`i' & sams90!=.
					local P_`i'=r(N)
					local MOVE_PAST_`i'=(`P_`i'')/(`T_`i'')
				}
				display `MOVE_PAST_`i''
			}
		restore

	* All: Control
		preserve
			keep if searchsamp==0
			* keep if immback== // 1 for non-western immigrants, 0 for natives
				forvalues i=1(1)10 {
					quietly {
						count if past_fpneg==0 & sams90!=. & sams91!=. & sams92!=. & sams93!=. & sams94!=. & sams95!=. & sams96!=. & sams97!=. & sams98!=. & sams99!=. & sams910!=. 
						local T_`i'=r(N)
						count if past_fpneg==0 & sams90==sams9`i' & sams90!=.
						local P_`i'=r(N)
						local CONT_`i'=(`P_`i'')/(`T_`i'')
					}
					display `CONT_`i''
				}
		restore

*************					
* TABLE A10 *
*************

* Preliminary Estimation Commands
	clear
	set mem 64m

* Loading the main analysis data and attaching the density data 
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000.dta", clear
	sort k2
	merge 1:m sams using "P:\2016\79\DTA files segregation\SAMS_areal.dta"
	drop if _merge<3
	gen density=N_tot/areal
	
* Constraining the sample 
	gen main=0
	replace main=1 if k2==1
	replace main=1 if k2==8
	replace main=1 if k2==12
	keep if main==1

* Getting summary statistics
	bysort k2: sum density
	
*************
* TABLE A11 *
*************

* Opening main data
use "P:\2016\79\DTA files segregation\outcome_sample9000.dta_extended_cohorts2", clear
collapse (mean) past_fpneg, by(sams90 kommun90)
save "P:\2016\79\Holder.dta", replace

* This loop creates 13 dta files, each with the sams code of a neighbor and whether that
* neighborhodd was above the tipping point or not. 

* Create 13 data sets, one for each of the areas 13 neighbors (max) and whether that neighborhood neighbor was above the TP in 1990
	forvalues i=1(1)13 {
		use "P:\2016\79\DTA files segregation\sams_neighbors.dta", clear
		rename sams SAMS
		rename kommun kommun90
		keep SAMS granne`i' kommun90
		rename granne`i' sams90
		merge m:1 sams90 using "P:\2016\79\Holder.dta"
		drop if _merge==2
		rename past_fpneg g_`i'_treat
		rename sams90 g_`i'
		keep SAMS g_`i' g_`i'_treat kommun
		save "P:\2016\79\Neigh_`i'.dta", replace
	}

* Combining the neighborhood files 
use "P:\2016\79\Neigh_1.dta", clear
	forvalues i=2(1)13 {
	merge 1:1 SAMS using "P:\2016\79\Neigh_`i'.dta"
	drop _merge
}

* Counting the number of neighbors of each area (ignoring those neighbors that dont meet our stage 1 restrictions)
egen grannar=rownonmiss(g_1_treat g_2_treat g_3_treat g_4_treat g_5_treat g_6_treat g_7_treat g_8_treat g_9_treat g_10_treat g_11_treat g_12_treat g_13_treat)

* This loop counts the number of neighbors that were above the TP
forvalues i=1(1)13 {
	replace g_`i'_treat=. if g_`i'_treat==0
}
egen treated_grannar=rownonmiss(g_1_treat g_2_treat g_3_treat g_4_treat g_5_treat g_6_treat g_7_treat g_8_treat g_9_treat g_10_treat g_11_treat g_12_treat g_13_treat)

* This command calculates the fraction of neighbors above TP
gen treated_neighbors=treated_grannar/grannar


* Displaying results in table A11: 
bysort kommun: sum treated_neighbors
bysort kommun: count if treated_neighbors==0 // divide by 85 in kommun 1280 (malmo), 167 in kommun 1 (stockholm) and 211 in kommun 1480 (gothenburg) to get the fraction shown in table A11.
bysort kommun: count if treated_neighbors==1


*************
* TABLE A12 *
*************

* Note: Currently estimates results for non-western immigrants. Change immback to 0 on row 891 to replicate the native estimates

* Collecting year 2000 outcomes 

	* Opening the data
	use "P:\2016\79\Leverans\Louisegeo2000.dta", clear

	* Imposing sample restrictions
	keep if fodar>=1948&fodar<=1958
	destring dnr201597  sams, force replace
	drop if sams==.
	
	* Eliminating duplicates 
	bysort dnr201597: gen dup=cond(_N==1,0,_n)
	tabulate dup
	drop dup

	* Renaming outcome variables
	local var "kommun loneink fink arbers sams"
	foreach x of local var {
		rename `x' `x'00
	}

	* Keeping variables of interest
	keep dnr201597 `var'
	save "P:\2016\79\DTA files segregation\Old_Cohort_2000", replace

	
* Adding new outcome variables to main analysis sample
use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
ren persid dnr201597
keep if fodar>=1948 & fodar<=1958
drop loneink* arbers*
merge 1:1 dnr201597 using "P:\2016\79\DTA files segregation\Old_Cohort_2000"
drop if _merge==2
drop _merge

* Deflating 2000 outcome variables
foreach k in loneink arbers fink {
	replace `k'00=`k'00*(280.4/260.7) 
}

* Restricting sample to main analysis sample
estimates clear 
keep if kommun90==1 | kommun90==1280 | kommun90==1480

* Dummies for missing parental characteristics
foreach i in ys90 inc_NOarbers90 {
gen miss`i'=`i'==.
replace `i'=0 if miss`i'==1
}

* Cohort and Nativity Selection
keep if immback==1
keep if fodar>=1948&fodar<=1958
keep if searchsamp==0

* Transforming outcome variables into logs 
local var "loneink00 fink00 arbers00"
foreach x of local var {
	replace `x'=ln(`x')
}

* Generating necessary polys
gen d2_fpneg=d1_fpneg*d1_fpneg
gen d3_fpneg=d1_fpneg^3
gen d4_fpneg=d1_fpneg^4

* Generating cluster variable for se
gen cluster2=round(d1_fpneg,1)

* Generating extensive margin outcomes
local var "loneink00 fink00 arbers00"
foreach x of local var {
	gen `x'_prob=1 if `x'>0 & `x'!=.
	replace `x'_prob=0 if `x'_prob!=1
}

* Running the regressions
local var "loneink00 fink00 arbers00 loneink00_prob fink00_prob arbers00_prob"
foreach x of local var {
estimates clear
regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ys90 inc_NOarbers90 miss* kon i.fodar i.kommun90, cluster(cluster2) level(90)
esttab using "P:\2016\79\TableA12.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
}


*************
* TABLE A13 *
*************

* Preliminary estimation commands
	clear
	set more off, permanently
	set mem 32m

* Retrieving the data 
	use "P:\2016\7\DTA files segregation\Tipping_Point_Data_LOUISE", clear	// (_AW2_v2)
	
* Identifying sams not present in both 1990 and 2000 
	keep if year==1990|year==2000
	keep if kommun==1|kommun==1280|kommun==1480
	bysort sams: gen sN=_N 
	gen FR=0
	replace FR=1 if sN==1 

* Identifying areas excluded from analysis due to Card et al. sample restrictions
	
		* i. Generating growth variables required for identifying TPs
		forvalues i=1990(10)2000 {	
				foreach j in N_tot N_Native N_immback_nonWest {
					gen `j'`i'=`j' if year==`i' 
					bysort sams: egen s`j'`i'=max(`j'`i') 
					bysort kommun: egen m`j'`i'=sum(`j'`i') 
				}
		}

			gen Dn1990=(sN_Native2000-sN_Native1990)/sN_tot1990
			gen Di1990=(sN_immback_nonWest2000-sN_immback_nonWest1990)/sN_tot1990
			gen Dtot_sams1990=(sN_tot2000-sN_tot1990)/sN_tot1990
			gen Dtot_mun1990=(mN_tot2000-mN_tot1990)/mN_tot1990
			gen Dn_mun1990=(mN_Native2000-mN_Native1990)/mN_tot1990
			gen Frac_nonWest=(sN_immback_nonWest1990/sN_tot1990)*100 // must be in % to fit the program codes
			gen DD1990=Dn1990-Dn_mun1990

		* ii. Growth rate in totpop in munic is 5 sd units above the growth rate in the municipality
			bysort kommun: egen sdDtot_sams1990=sd(Dtot_sams1990)
			gen SR=0
			replace SR=1 if Dtot_sams1990>=(sdDtot_sams1990*5)
			
		* iii. Sams with less than 200 inhabitants in 1990
			gen TR=0
			replace TR=1 if sN_tot1990<200				
	
		* iv. Growth rate in sams native pop exceeds the total sams pop in the base year with 500%
			*drop if Dn1990>sN_tot1990*5				
			replace Dn1990=Dn1990*100
			gen FoR=0
			replace FoR=1 if Dn1990>500		
			replace Dn1990=Dn1990/100
		
* Obtaining table with comparative statistics 
gen excluded=0
replace excluded=1 if FR==1 | SR==1 | TR==1 | FoR==1 
						
bysort excluded: summarize Dn1990 Di1990 Dtot_sams1990 Native female age ysm genuniv loneink socialbidrag


*************
* TABLE A14 *
*************

* Note: Currently estimates the individual-levle results for all. To change, make appropriate sample selection adjustments on rows 1073-1077

* Opening the data
use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
estimates clear 

* Restricting to main analysis municipalities
keep if kommun90==1 | kommun90==1280 | kommun90==1480

* Dummies for missing parental characteristics (and own characteristics for old sample) 
foreach i in ysmamma yspappa parint parage {
	gen miss`i'=`i'==.
	replace `i'=0 if miss`i'==1
	}

foreach i in ys90 inc_NOarbers90 {
	gen miss`i'=`i'==.
	replace `i'=0 if miss`i'==1
	}

* Generating necessary polys
gen d2_fpneg=d1_fpneg*d1_fpneg
gen d3_fpneg=d1_fpneg^3
gen d4_fpneg=d1_fpneg^4

* Cluster for SE
gen cluster2=round(d1_fpneg,1)

* Renaming variables
ren sams00 sams
ren kommun00 kommun

* Neighborhood quality measures
merge m:1 kommun sams using "P:\2016\79\DTA files segregation\NQuality"		// (NeighborhoodQuality3)
tab _merge
ren sams sams00
ren kommun kommun00
keep if _merge==3
drop _merge

* 2000 location variables to identify stayers and movers
preserve
use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000_partialexposure.dta", clear
ren sams sams00
ren Frac_nonWest2000 Frac_nonWest00
ren Frac_nonWest Frac_nonWest90
ren past_fpneg2000 stilltipp00
ren past_fpneg stilltipp90
keep sams00 Frac_nonWest00 stilltipp00 Frac_nonWest90 stilltipp90
tempfile holding
save `holding'
restore

merge m:1 sams00 using `holding'
keep if _merge==3
drop _merge

* Creating the two quality indicies requested by the referees
	gen Frac_imm00=sN_immback_nonWest2000/sN_tot2000
	replace female_00=female_00-.5
	gen Fem_00=abs(female_00)
	replace socbidr_00=socbidr_00*-1
	replace Frac_imm00=Frac_imm00*-1
	replace age_00=age_00*-1
	replace Fem_00=Fem_00*-1
	replace inc_00=ln(inc_00)

* Normalizing individual variable components
	estimates clear
	local var "sN_tot2000 genuniv_00 inc_00 anstalld_00 ys_00 socbidr_00 Frac_imm00 age_00 Fem_00"
	foreach x of local var {
	sum `x', detail
	replace `x'=(`x'-r(min))/(r(max)-r(min))
	}

* Generating the NQ and the SQ variables that the referees requested 
	gen NQ=inc_00+anstalld_00+ys_00
	sum NQ
	replace NQ=(NQ-r(mean))/(r(sd))
	
	gen SQ=Frac_imm00+age_00+Fem_00+socbidr_00
	sum SQ
	replace SQ=(SQ-r(mean))/(r(sd))
	
	keep if searchsamp==0
	*keep if immback==1
	*drop if sams90!=sams00 & past_fpneg>0 

* Estimating the regressions
	reg NQ past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage ys90 inc_NOarbers90 miss* kon i.fodar i.kommun90, cluster(cluster2)
	reg SQ past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage ys90 inc_NOarbers90 miss* kon i.fodar i.kommun90, cluster(cluster2)


**********************
* TABLES A15 AND A16 *
**********************

* Note: Results currently estimated for non-western immigrants (Table A15). To obtain the
* native estimates (Table A16), change immback==1 to immback==0

* Opening the data
use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
estimates clear 

* Restricting to analysis municipalities
keep if kommun90==1 | kommun90==1280 | kommun90==1480

* Creating necessary polys
gen d2_fpneg=d1_fpneg*d1_fpneg
gen d3_fpneg=d1_fpneg^3
gen d4_fpneg=d1_fpneg^4

* Dummies for missing parental characteristics
foreach i in ysmamma yspappa parint parage {
gen miss`i'=`i'==.
replace `i'=0 if miss`i'==1
}

* Cluster variable for SE
gen cluster2=round(d1_fpneg,1)

* Cohort and Nativity Selection
keep if immback==1
keep if fodar>1979

* Stratification variables 
	*  Excluding outliers
	preserve 
	drop if d1_fpneg>42 & kommun90==1
	drop if d1_fpneg>34 & kommun90==1480
	drop if d1_fpneg>35 & kommun90==1280
	gen noout=1
	tempfile tl
	save "`tl'", replace
	restore
	merge 1:1 persid using `tl'
	drop _merge
	
	* Population Density
	rename sams90 sams
	merge m:1 sams using "P:\2016\79\DTA files segregation\SAMS_areal.dta"
	drop if _merge==2
	gen density=sN_tot1990/areal
	rename sams sams90
	drop _merge

	* Dropping those whose neighbors have all tipped (file from line 1-50 in EXTENSION Neighbors_Tipping, modified to allow reverse merge)
	preserve 
	merge m:1 sams90 using "C:\Users\ifau-AleWi\Desktop\temp.dta"
	count if past_fpneg==1 & _merge==1 & (kommun90==1 | kommun90==1280 | kommun90==1480) // all matched
	drop if _merge==2
	drop _merge
	drop if treated_neighbors==1 
	gen excl1=1
	tempfile tr
	save "`tr'", replace
	restore
	merge 1:1 persid using `tr'
	drop _merge

* Final prep. 
gen argyes=arg!=.
replace argyes=. if fodar<1973|fodar>1987

keep if searchsamp==0

* Running the regressions
local var "pmeritvarde psv_ak9 ptotgymn ys11 forvers11 forvers11_prob"
foreach x of local var {
estimates clear
eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon density i.fodar i.kommun90, cluster(cluster2)
eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90 if excl1==1, cluster(cluster2)
eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90 if noout==1, cluster(cluster2)
esttab using "P:\2016\79\Young_Rob.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
}

*****************
* MIDDLE COHORT *
*****************

* Opening the data
use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
estimates clear 

* Keeping relevant municipalities
keep if kommun90==1 | kommun90==1280 | kommun90==1480

* Generating polys
gen d2_fpneg=d1_fpneg*d1_fpneg
gen d3_fpneg=d1_fpneg^3
gen d4_fpneg=d1_fpneg^4

* Dummies for missing parental characteristics
foreach i in ysmamma yspappa parint parage {
gen miss`i'=`i'==.
replace `i'=0 if miss`i'==1
}

* Cluster variable for se
gen cluster2=round(d1_fpneg,1)

* Cohort and Nativity Selection
keep if immback==1
keep if fodar>=1973&fodar<=1983

* Stratification variables
	*  Excluding outliers
	preserve 
	drop if d1_fpneg>42 & kommun90==1
	drop if d1_fpneg>34 & kommun90==1480
	drop if d1_fpneg>35 & kommun90==1280
	gen noout=1
	tempfile tl
	save "`tl'", replace
	restore
	merge 1:1 persid using `tl'
	drop _merge
	
	* Population Density
	rename sams90 sams
	merge m:1 sams using "P:\2016\79\DTA files segregation\SAMS_areal.dta"
	drop if _merge==2
	gen density=sN_tot1990/areal
	rename sams sams90
	drop _merge

	* Dropping those whose neighbors have all tipped
	preserve 
	merge m:1 sams90 using "C:\Users\ifau-AleWi\Desktop\temp.dta"
	count if past_fpneg==1 & _merge==1 & (kommun90==1 | kommun90==1280 | kommun90==1480) // all matched
	drop if _merge==2
	drop _merge
	drop if treated_neighbors==1 
	gen excl1=1
	tempfile tr
	save "`tr'", replace
	restore
	merge 1:1 persid using `tr'
	drop _merge

* Final prep. 
	gen argyes=arg!=.
	replace argyes=. if fodar<1973|fodar>1987

* Running the regressions
keep if searchsamp==0

local var "pmeritvarde psv_ak9 ptotgymn ys11 forvers11 forvers11_prob"

foreach x of local var {
estimates clear
eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon density i.fodar i.kommun90, cluster(cluster2)
eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90 if excl1==1, cluster(cluster2)
eststo: regress `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ysmamma yspappa parint parage miss* kon i.fodar i.kommun90 if noout==1, cluster(cluster2)
esttab using "P:\2016\79\Middle_Rob.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
}

**************
* OLD COHORT *
**************

* Opening the data 
use "P:\2016\79\DTA files segregation\outcome_sample9000_extended_cohorts2", clear
estimates clear 

* keeping main municipalities
keep if kommun90==1 | kommun90==1280 | kommun90==1480

* generating necessary polys
gen d2_fpneg=d1_fpneg*d1_fpneg
gen d3_fpneg=d1_fpneg^3
gen d4_fpneg=d1_fpneg^4

* Cluster variable for SE
gen cluster2=round(d1_fpneg,1)

* Dummies for missing parental characteristics
foreach i in ys90 inc_NOarbers90 {
gen miss`i'=`i'==.
replace `i'=0 if miss`i'==1
}

* Cohort and Nativity Selection
keep if immback==1
keep if fodar>=1948&fodar<=1958

* Stratification variables
	*  Excluding outliers
	preserve 
	drop if d1_fpneg>42 & kommun90==1
	drop if d1_fpneg>34 & kommun90==1480
	drop if d1_fpneg>35 & kommun90==1280
	gen noout=1
	tempfile tl
	save "`tl'", replace
	restore
	merge 1:1 persid using `tl'
	drop _merge
	
	* Population Density
	rename sams90 sams
	merge m:1 sams using "P:\2016\79\DTA files segregation\SAMS_areal.dta"
	drop if _merge==2
	gen density=sN_tot1990/areal
	rename sams sams90
	drop _merge

	* Dropping those whose neighbors have all tipped (file from line 1-50 in EXTENSION Neighbors_Tipping, modified to allow reverse merge)
	preserve 
	merge m:1 sams90 using "C:\Users\ifau-AleWi\Desktop\temp.dta"
	count if past_fpneg==1 & _merge==1 & (kommun90==1 | kommun90==1280 | kommun90==1480) // all matched
	drop if _merge==2
	drop _merge
	drop if treated_neighbors==1 
	gen excl1=1
	tempfile tr
	save "`tr'", replace
	restore
	merge 1:1 persid using `tr'
	drop _merge

* Restricting sample and running regressions
keep if searchsamp==0
replace forvers11=0 if forvers11==.  
local var "forvers11 forvers11_prob"

foreach x of local var {
estimates clear
eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg miss* kon density i.fodar i.kommun90, cluster(cluster2)
eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg miss* kon i.fodar i.kommun90 if excl1==1, cluster(cluster2)
eststo: regress  `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg miss* kon i.fodar i.kommun90 if noout==1, cluster(cluster2)
esttab using "P:\2016\79\Old_Rob.csv", append se r2 star(* 0.10 ** 0.05 *** 0.01) keep(past_fpneg) coeflabels(past_fpneg "Beyond TP")
}

*************
* FIGURE A2 *
*************

* Loading the data 
use "P:\2016\79\DTA files segregation\Event_Study_Old_Cohort_Income", clear

* Deflating the income variable 
foreach k in loneink {
replace `k'85=`k'85*(280.4/153.8)
replace `k'86=`k'86*(280.4/160.3) 
replace `k'87=`k'87*(280.4/167.0) 
replace `k'88=`k'88*(280.4/176.7) 
replace `k'89=`k'89*(280.4/188.1) 
replace `k'90=`k'90*(280.4/207.8) 
replace `k'91=`k'91*(280.4/227.2) 
replace `k'92=`k'92*(280.4/232.4)
replace `k'93=`k'93*(280.4/243.2) 
replace `k'94=`k'94*(280.4/248.5) 
replace `k'95=`k'95*(280.4/254.8) 
replace `k'96=`k'96*(280.4/256.0) 
replace `k'97=`k'97*(280.4/257.3)
replace `k'98=`k'98*(280.4/257.0) 
replace `k'99=`k'99*(280.4/258.1)
replace `k'00=`k'00*(280.4/260.7) 
replace `k'01=`k'01*(280.4/267.1) 
replace `k'02=`k'02*(280.4/272.8) 
replace `k'03=`k'03*(280.4/278.1) 
replace `k'04=`k'04*(280.4/279.2) 
replace `k'05=`k'05*(280.4/280.4) 
replace `k'06=`k'06*(280.4/284.2) 
replace `k'07=`k'07*(280.4/290.5) 
replace `k'08=`k'08*(280.4/300.6) 
replace `k'09=`k'09*(280.4/299.7) 
replace `k'10=`k'10*(280.4/299.7) 
replace `k'11=`k'11*(280.4/311.4) 
}

* Creating necessary polys
estimates clear 
gen d2_fpneg=(d1_fpneg)^2
gen d3_fpneg=(d1_fpneg)^3
gen d4_fpneg=(d1_fpneg)^4

* Cluster variable for SE
 gen cluster2=round(d1_fpneg,1)

* Dummies for missing parental characteristics
foreach i in ys90 inc_NOarbers90 {
gen miss`i'=`i'==.
replace `i'=0 if miss`i'==1
}

* Cohort and Nativity Selection
keep if immback==0
keep if kommun90==1 | kommun90==1280 | kommun90==1480
keep if searchsamp==0

* Adjustment to be consistent with main estimations. 
forvalues i=90(1)99 {
replace loneink`i'=ln(loneink`i')
replace loneink`i'=0 if loneink`i'==.
}

replace loneink00=ln(loneink00)
replace loneink00=0 if loneink00==.

forvalues j=1(1)9 {
replace loneink0`j'=ln(loneink0`j')
replace loneink0`j'=0 if  loneink0`j'==.
}
forvalues k=0(1)1 {
replace loneink1`k'=ln(loneink1`k')
replace loneink1`k'=0 if loneink1`k'==.
}

* Creating three year averages
gen AV1=(loneink90+loneink91+loneink92)/3
gen AV2=(loneink93+loneink94+loneink95)/3
gen AV3=(loneink96+loneink97+loneink98)/3
gen AV4=(loneink99+loneink00+loneink01)/3
gen AV5=(loneink02+loneink03+loneink04)/3
gen AV6=(loneink05+loneink06+loneink07)/3
gen AV7=(loneink08+loneink09+loneink10)/3
gen AV8=(loneink11)

* Creating the figure
local var "AV1 AV2 AV3 AV4 AV5 AV6 AV7 AV8"
foreach x of local var {
replace `x'=ln(`x')
estimates clear
reg `x' past_fpneg d1_fpneg d2_fpneg d3_fpneg d4_fpneg ys90 inc_NOarbers90 miss* kon i.fodar i.kommun90, cluster(cluster2) level(90)
gen Coef_`x'=_b[past_fpneg]
gen SE_`x'=_se[past_fpneg]
}

keep Coef_* SE_*
gen row=_n
keep if row<9

* Coefficient var.
gen Coef=Coef_AV1
replace Coef=Coef_AV2 if row==2
replace Coef=Coef_AV3 if row==3
replace Coef=Coef_AV4 if row==4
replace Coef=Coef_AV5 if row==5
replace Coef=Coef_AV6 if row==6
replace Coef=Coef_AV7 if row==7
replace Coef=Coef_AV8 if row==8

* SE var. 
gen SE=SE_AV1
replace SE=SE_AV2 if row==2
replace SE=SE_AV3 if row==3
replace SE=SE_AV4 if row==4
replace SE=SE_AV5 if row==5
replace SE=SE_AV6 if row==6
replace SE=SE_AV7 if row==7
replace SE=SE_AV8 if row==8

* Plotting 
serrbar Coef SE row, scale(1.96) ytitle("Coefficient estimate") xtitle("") title("Effect of tipping on immigrant employment income over time")

*************
* FIGURE A3 *
*************

* Preliminary estimation commands
	clear
	pause on
	set mem 64m
	set matsize 6000

* Loading the data
	use "P:\2016\79\DTA files segregation\[I]_TP_1990_2000.dta", clear

* Generating necessary treatment variables
	foreach type in fpneg {
			gen d1_`type'   = Frac_nonWest - `type'_search1990_mstar
			gen d2_`type'=d1_`type'^2
			gen d3_`type'=d1_`type'^3
			gen d4_`type'=d1_`type'^4
			gen past_`type'=(d1_`type'>0)
	 }
 	 
* Constraining the sample  
	keep if searchsamp==0
	keep if k2==1 | k2==8 | k2==12

* Preparing the visual displays	
		preserve
		gen TP_norm=Frac_nonWest-fpneg_search1990_mstar
	
		replace Dn1990=Dn1990*100
		rename Dn1990 DN1990
		rename TP_norm tp_norm
		gen TP_norm=round(tp_norm)
		
		forvalues i=-99(2)99 {
		replace TP_norm=TP_norm+1 if TP_norm==`i'
		}
		
		bysort TP_norm: egen Dn1990=mean(DN1990)
		egen mgrowth=mean(Dn1990)
		mkmat mgrowth, matrix(mg)
		scalar temp_mg=mg[1,1]
		local mNgr=temp_mg	
		
		gen TP_normp=TP_norm if TP_norm<=0
		gen Dn1990p=Dn1990 if TP_norm<=0
		gen TP_normpost=TP_norm if TP_norm>0
		gen Dn1990post=Dn1990 if TP_norm>0
		drop if TP_norm>40

* Creating the figures, in order from a to g		
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(1) bwidth(2)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(1) bwidth(2))
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(1) bwidth(6)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(1) bwidth(6))
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(1) bwidth(8)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(1) bwidth(8))
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(2) bwidth(4)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(2) bwidth(4))
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(2) bwidth(8)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(2) bwidth(8))
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(4) bwidth(4)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(4) bwidth(4))
		twoway (scatter Dn1990 TP_norm, xline(0) yline(7.2) ylabel(-30(10)30, angle(0))) (lpoly Dn1990p TP_normp [aw=sN_tot1990] if inrange(TP_norm,-30,0), degree(4) bwidth(8)) (lpoly Dn1990post TP_normpost [aw=sN_tot1990], degree(4) bwidth(8))


