****************
*** Figure 2 ***
****************

** Data Construction

* Start from busyness dataset with probablility weights for
* assignment (cf. appendix for data construction)
use examiner_application_weights_all
merge m:1 application using child_applications.dta
keep if _merge == 1
drop _merge

rename examiner temp_examiner

merge m:1 application using examiner_effect_dataset_v2.dta, keepus(filing_year examiner pcwordcount)
keep if _merge == 3
drop _merge

tab filing_year 
keep if filing_year >= 2001

merge m:1 examiner filing_year using examiner_aggregates_filing_year
keep if _merge == 3
drop _merge

gen actual_loo_words = (pcwordcount_sum - pcwordcount) / (non_empty - 1)
drop pcwordcount_sum pcwordcount non_empty

rename examiner actual_examiner
rename temp_examiner examiner

merge m:1 examiner filing_year using examiner_aggregates_filing_year
keep if _merge == 3
drop _merge

gen loo_words = pcwordcount_sum / non_empty
replace loo_words = actual_loo_words if examiner == actual_examiner 

keep if non_empty >= 5

gen weighted_loo_words = loo_words * p_hat_disposals

collapse (sum) weighted_loo_words p_hat_disposals (first) actual_loo_words, by(application)

replace weighted_loo_words = weighted_loo_words / p_hat_disposals

merge 1:1 application using npe_portfolio_list
keep if _merge == 1 | _merge == 3
gen npe = (_merge == 3)
drop _merge


merge m:1 application using detailed_micro_examiner_data.dta, keepus(filing_year artunit examiner)
keep if _merge == 3
drop _merge

** Analysis

egen artunit_year = group(artunit filing_year)
replace npe = 100 * npe 

* panel A 
binscatter actual_loo_words weighted_loo_words, absorb(artunit_year)
areg actual_loo_words weighted_loo_words, absorb(artunit_year)
graph save busyness_first_stage_words, replace
graph export busyness_first_stage_words.pdf, replace

* panel B
binscatter npe weighted_loo_words, absorb(artunit_year)
areg npe weighted_loo_words, absorb(artunit_year)
graph save busyness_reduced_form_words, replace
graph export busyness_reduced_form_words.pdf, replace



