****************
*** Figure 1 ***
****************

use examiner_effect_dataset_v2
merge 1:1 application using loo_grant_rates
keep if _merge == 3
drop _merge

egen examiner_id=group(examiner)
bysort examiner_id filing_year: gen grantn=_N
drop if grantn==1

foreach i in cindepclaim pcindepclaim cwordcount pcwordcount {
bysort examiner_id filing_year: egen temp=sum(`i')
gen loo_`i'=(temp-`i')/(grantn-1)
drop temp

binscatter NPE_portfolio loo_`i' [aw=grantn], reportreg absorb(year_artunit) control(loo_grant_rate) ytitle("NPE Purchase Rate")
graph save NPE_portfolio_loo_`i', replace
graph export NPE_portfolio_loo_`i'.pdf, replace  

binscatter litigated_v2 loo_`i' [aw=grantn], reportreg absorb(year_artunit) control(loo_grant_rate) ytitle("Non-NPE Litigation Rate")
graph save litigated_v2_loo_`i', replace
graph export litigated_v2_loo_`i'.pdf, replace  

binscatter nonnpe loo_`i' [aw=grantn], reportreg absorb(year_artunit) control(loo_grant_rate) ytitle("Non-NPE Purchase Rate")
graph save nonnpe_loo_`i', replace
graph export nonnpe_loo_`i'.pdf, replace  

binscatter npe_litigated loo_`i' [aw=grantn], reportreg absorb(year_artunit) control(loo_grant_rate) ytitle("NPE Litigation Rate")
graph save npe_litigated_loo_`i', replace
graph export npe_litigated_loo_`i'.pdf, replace  
}



