%% uDiffMT
%
% Calculates difference in utility between adjusting to new optimum under 
% marginal tax rate t and staying at old optimum when tax rate was t0.

function dU = uDiffMT(n, t, t0, e)
    
    uOptimal = n.*(1-t).^(e+1)./(e+1);
    uInert = n.*(1-t0).^e*(1-t) - n./(1+1/e) .* (1-t0)^(e+1);
    dU = uOptimal - uInert;
end