%% calcBunchFlex

% Returns the predicted bunching amount, given zUpper and Lower, and data
% structure containing earnings distrubtion.

function rB = calcBunchFlex(zUpper, zLower, data)
    
    % linear interpolation on empirical distribution to get probability
    hUpper = interp1(data.income, data.dist, zUpper);
    hLower = interp1(data.income, data.dist, zLower);
    
    % Bunching is max(difference, 0)
    rB = max(hUpper - hLower, 0);
    
end