
/* bunchPoolYears.do 

Calculates bunching by age, pooling as long a period (1983-1999) as possible

*/

local bwlist "800 400 1600"
local sampleList "s1Main s1Born13 s1Born16"

qui foreach sample of local sampleList {
	foreach bw of local bwlist{
			
		use "$datadir/cfopSSA_`sample'_`bw'" if ///
			inrange(age, 59, 73) & inrange(year, 1983, 1999), clear
				
		noi di " bw = `bw', sample = `sample'"
		noi table age, c(sum count)
		
		// collapse dataset to counts
		collapse (sum) count (mean) real_threshold, by(realDistanceRound age)
		gen rd1k = realDistanceRound/1000
		egen total = total(count), by(age)
		gen prob = count/total
		gen order = _n
		sort order

		local row   0
		gen b           = .
		gen bSE         = .
		gen bSEDM       = .
		gen ageGraph    = .
		
		local exclude = round(3000/`bw',1)
		foreach age of numlist 59/73 {

			// set sample
			gen sample =  age == `age' & inrange(realDistanceRound, -1e4, 3e4)
			sum real_threshold if sample
			local zstar = r(mean)
			
			local nox "nolabel"
			local noy "nolabel"

			if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
			if `age'>=69 local nox ""

			capture bunchPoly realDistanceRound prob if sample, ///
				kink(0) exclude(`exclude') bw(`bw') degree(7) ////
				keep(1) print(0) nboot(100)
			local rc = _rc

			/* fill in for graphing */
			local ++row
			replace ageGraph    = `age' in `row'
			if `rc' == 0 {
				sort order
				replace b           = r(scaledMass) in `row'
				replace bSE         = r(scaledMassBS) in `row'
				replace bSEDM      = r(scaledMassSE) in `row'
				
				# delimit ;
				twoway
					(connected prob rd1k if !missing(smoothDensity),  lcolor(navy) mcolor(navy) msize(small))
					(line smoothDensity rd1k if !missing(smoothDensity),  lcolor(cranberry)),
					title("`age'", ring(0))
					xlabel(#4, `nox' labsize(large))
					xtitle("")
					xline(0, lcolor(gs12))
					ylabel(#4, `noy' labsize(large))
					legend(off)
					graphregion(color(white))
					name(cfop`age', replace)
					nodraw
				;
				# delimit cr
				capture window manage close graph _all
				drop smoothDensity
			}
			// end if no error 
			
			if `rc' != 0 {
				local rc = _rc
				noisily di "    age = `age', y1 = `y1', bw = `bw', sample = `sample': error code: `rc'"

				// make a filler graph 
				gen zero_temp = 0 in 1
				# delimit ;
				twoway scatter zero_temp rd1k if _n==1,
					name(cfop`age', replace) legend(off) xtitle("") ytitle("") title("")
					xlabel(,nolabel) ylabel(,nolabel)
					graphregion(color(white))
					nodraw
				;
				# delimit cr
					
				replace b           = . in `row'
				replace bSE         = . in `row'
				drop zero_temp
			} /* end if error */

			drop sample 
		} /* end age loop */

		/* assemble into 15 panel graph */
		# delimit ;
		graph combine
			cfop59 cfop60 cfop61
			cfop62 cfop63 cfop64
			cfop65 cfop66 cfop67
			cfop68 cfop69 cfop70
			cfop71 cfop72 cfop73,
			cols(5)
			xsize(10) ysize(7.5) imargin(tiny)
			l1title("Percent") b1title("Real distance to kink (thousands of dollars)")
			xcommon ycommon
			graphregion(color(white))
			nodraw
		;
		# delimit cr
		graph save "$figdir/densPoly_8399_5973_`bw'_`sample'", replace
		capture window manage close graph _all

		/* outsheet results to a table */
		sort order
		outsheet ageGraph b bSE if !missing(age) using ///
			"$tabdir/ageStatsDensPoly_8399_5973_`bw'_`sample'.txt", replace

	} /* end bw loop */
	
} /* end sample loop */

