


********************************************************************************
********************************************************************************
** Figures 2 a and B
********************************************************************************
********************************************************************************

local bw 800
local exclude = round(3000/`bw',1)


use "$datadir/dens800" , clear
sort age rd1k
by age: gen realDistanceRound = -9600 if _n == 1
by age: replace realDistanceRound = realDistanceRound[_n-1] + 800 if _n > 1
gen order = _n
sort order
local row   0
gen b           = .
gen bSE         = .
gen bSEDM       = .
gen ageGraph    = .

qui forvalues age = 59/73 {
	
	local nox "nolabel"
	if `age' >= 69 local nox ""
	local noy "nolabel"
	if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
	// Calculate bunching
	gen eSample =  age == `age'

	// estimate bunching, fill in table 
	bunchPoly realDistanceRound prob if eSample, kink(0) exclude(`exclude') ///
		bw(`bw') degree(7) keep(1) print(0) nboot(100)
	local ++row
	replace ageGraph    = `age' in `row'
	sort order
	replace b          = r(scaledMass)*`bw' in `row'
	replace bSE        = r(scaledMassBS)*`bw' in `row'
	replace bSEDM      = r(scaledMassSE)*`bw' in `row'

	
	
	// plot earnings distributions
	# delimit ;
	twoway 
		(connected prob rd1k if age == `age', sort msize(small) mcolor("$blue"))
		(line smoothDensity rd1k if age == `age', sort lcolor("$red"))
		,
		title("`age'", ring(0))
		xlabel(, `nox' labsize(small))
		xtitle("")
		xline(0, lcolor(gs12))
		ylabel(, labsize(small) `noy')
		legend(off)
		graphregion(color(white))
		name(g`age', replace)
		nodraw
	;
	# delimit cr
			
	drop smoothDensity fit eSample
	
}

# delimit ;
graph combine 
	g59 g60 g61 g62 g63
	g64 g65 g66 g67 g68
	g69 g70 g71 g72 g73, ycommon
	cols(5) imargin(small)
	xsize(10) ysize(7.5)
	l1title("Probability in bin") 
	b1title("Real distance to kink (thousands of dollars)")
	title("A. Earnings distribution by age", span pos(11))
	graphregion(color(white))
;
# delimit cr
graph export "$figdir/figure2a.pdf", replace

gen upper = b + 1.96*bSE
gen lower = b - 1.96*bSE
# delimit ;
twoway
	(connected b ageGraph, lcolor("$blue"))
	(line upper ageGraph, lpattern(dash) lcolor("$red"))
	(line lower ageGraph, lpattern(dash) lcolor("$red")),
	xtitle("Age") ytitle("Normalized excess mass")
	yline(0, lcolor(gs12)) xline(62 70, lcolor(gs12))
	graphregion(color(white))
	xlabel(60(5)70) xtick(59 73)
	legend(off)		
	
;
# delimit cr
graph export "$figdir/figure2b.pdf", replace

format b upper lower %5.3f
list ageGraph b upper lower  if ~missing(ageGraph) , noobs clean

