%% compute uFric
%
% This function computes uFric, given counterfactual earnings z, the
% elasticity el, and a structure called data containing the tax parameters:
% data.zStar is the kink location, data.t0 is the tax  below the kink, and
% data.t1 the tax above.
%
% uFric is the utility associated with maintaining earnings z after the tax
% rate changes from the linear schedule with mtr t to the nonlinear
% schedule with the tax rate t0 below zStar and t1 above.
%
% Input notes:
%
% - el must always be a scalar.
% - zOld can be a vector of arbitrary length N, in which case data.t0,
%   data.t1, and data.zStar must all be scalars, and the function returns an
%   N by 1 vector.
% - if zOld is a scalar, then data.t0, data.t1, and data.zStar can be
%   vectors of any length, although they all must the same length N. In this
%   case the function returns an N by 1 vector.
function u = uFric(z,el, data)
    
    % find consumption, accounting for nonlinear taxation.
    c = z - (data.t0.*z + (data.t1-data.t0).*(z-data.zStar).*(z>data.zStar));
    
    % evlauate utility
    n = z ./(1-data.t0).^el;
    u = c - n./(1+1./el).*(z./n).^(1+1/el);
end