%% calcGmmInert
%
% compute GMM obj for the bunching problem.
% 

function [r_obj, zb1, zb0] = calcGmmInert(params, data, wMat)
    
        
    [zb1, zb0, zOpt, flag] = calcCutoffs(params, data);        
    b1Tilde = calcBFromZ(zb1, zOpt, data);
    zb1Final = zb1(data.ts==0);
    b2Tilde = calcBFromZ(zb1Final, zb0, data);        
    bSim = b1Tilde.*data.pre + b2Tilde.*(1-data.pre);
    
    % calculate objective as weighted inner product
    r_obj = 1/length(data.bunch)*(bSim - data.bunch)'*wMat*(bSim-data.bunch);
    if flag ~= 1
        r_obj = 1e8;
    end 

    
end