
global epdf = strpos("$directory", "ropbox")

/******************************************************************************/
// Robustness figures for R3
/******************************************************************************/

	// figure with bunchign by age 59-73, for bin sizes of 400 and 1600.	
	qui forvalues r = 1/9 {
		
		local bw = 800
		local exclude = 2
		local degree = 7
		
		// first set: vary excluded amount
		if `r' == 1 local exclude = 2
		if `r' == 2 local exclude = 3
		if `r' == 3 local exclude = 4
		
		// second set: vary degree
		if `r' == 4 local degree = 6
		if `r' == 5 local degree = 7
		if `r' == 6 local degree = 8
		
		// third set: vary bin width
		if `r' == 7 {
			local bw = 400
			local exclude = 7
		}
		if `r' == 8 {
			local bw = 400
			local exclude = 7
		}
		if `r' == 9 {
			local bw = 1600
			local exclude = 2
		}
		
	
		// load the data 		
		use "$datadir/cfopSSA_s1Main_`bw'" if ///
			age>=59 & age<=73 & year>=1990 & year<=1999, clear			
		
		// prepare data for bunching analysis
		local min = -1e4
		local max = 3e4
		
		collapse (sum) count (mean) real_threshold, by(realDistanceRound age)
		gen rd1k = realDistanceRound/1000
		egen total = total(count), by(age)
		gen prob = count/total
		gen dens = prob * `bw' / 1e3
		gen order = _n
		sort order

		// placeholders for bunching 
		local row   0
		gen b           = .
		gen bSE         = .
		gen bSEDM       = .
		gen ageGraph    = .		

		foreach age of numlist 59/73 {

			// set sample
			gen sample =  age == `age' & realDistanceRound>=`min' & realDistanceRound<=`max'

			local nox "nolabel"
			local noy "nolabel"

			if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
			if `age'>=69 local nox ""

			capture bunchPoly realDistanceRound prob if sample, ///
				kink(0) exclude(`exclude') bw(`bw') degree(7) keep(1) print(0) nboot(100)
			local rc = _rc

			// fill in for graphing
			local ++row
			replace ageGraph    = `age' in `row'
			if `rc' == 0{
				sort order
				replace b          = `bw'*r(scaledMass)   / 1e3 in `row'
				replace bSE        = `bw'*r(scaledMassBS) / 1e3 in `row'
				replace bSEDM      = `bw'*r(scaledMassSE) / 1e3 in `row'

				// make graph	
				replace smoothDensity = smoothDensity * `bw' /1e3
				# delimit ;
				twoway
					(connected dens rd1k if !missing(smoothDensity),
						lcolor(navy) mcolor(navy) msize(small))
					(line smoothDensity rd1k if !missing(smoothDensity), 
						lcolor(cranberry)),
					title("`age'", ring(0))
					xlabel(#4, `nox' labsize(large))
					xtitle("")
					xline(0, lcolor(gs12))
					ylabel(#4, `noy' labsize(large))
					legend(off)
					graphregion(color(white))
					name(cfop`age', replace)
				;
				# delimit cr
				capture window manage close graph _all
				drop smoothDensity
				
			} /* end if no error */
			
			if `rc' != 0 {
				local rc = _rc
				noisily di "    age = `age', y1 = `y1', bw = `bw', sample = `sample': error code: `rc'"

				// make a filler graph 
				gen zero_temp = 0 in 1
				# delimit ;
					twoway scatter zero_temp rd1k if _n==1,
					name(cfop`age', replace) legend(off) xtitle("") ytitle("") title("")
					xlabel(,nolabel) ylabel(,nolabel)
					graphregion(color(white))
				;
				# delimit cr
				replace b           = . in `row'
				replace bSE         = . in `row'
				drop zero_temp


			} /* end if error */

			drop sample 
		} /* end age loop */

		// assemble into 15 panel graph 
		# delimit ;
		graph combine
			cfop59 cfop60 cfop61
			cfop62 cfop63 cfop64
			cfop65 cfop66 cfop67
			cfop68 cfop69 cfop70
			cfop71 cfop72 cfop73,
			cols(5)
			xsize(10) ysize(7.5) imargin(tiny)
			l1title("Density") b1title("Real distance to kink (thousands of dollars)")
			xcommon ycommon
			graphregion(color(white))
		;
		# delimit cr
		graph save "$figdir/densPoly_5973_d`d'e`e'bw`bw'", replace
		capture window manage close graph _all

		// make time series plots 
		foreach stat in b {

			if "`stat'" == "el" local title "Implied Elasticity"
			if "`stat'" == "b" local title  "Normalized excess mass at kink"

			// make upper and lower confidence bounds
			gen upper = `stat'+1.96*`stat'SE
			gen lower = `stat'-1.96*`stat'SE

			local title ""
			local nox "nolabel"
			local noy "nolabel"
			if `r' == 1 {
				local title `"title(A. Vary Excluded Region)"'
				local subtitle "Exclude \$2000"
				local noy ""
			}
			if `r' == 2 {
				local subtitle "Exclude \$3000"
				local noy ""
			}
			if `r' == 3 {
				local subtitle "Exclude \$4000"
				local nox ""
				local noy ""
			}
			
			if `r' == 4 {
				local title `"title(B. Vary Degree)"'
				local subtitle "Degree 6"
			}
			if `r' == 5 local subtitle "Degree 7"
			if `r' == 6 {
				local subtitle "Degree 8"
				local nox ""
			}
						
			if `r' == 7 {
				local title `"title(C. Vary Bin Width)"'
				local subtitle "Bin width = \$400"
			}
			if `r' == 8 local subtitle "Bin width = \$800"
			if `r' == 9 {
				local subtitle "Bin width = \$1600"
				local nox 
			}
			
			// plot stats plus confidence bands 
			# delimit ;
			twoway
			(connected `stat' ageGraph if !missing(`stat'), sort 
				lcolor(edkblue) lwidth(medthick) mcolor(edkblue))
			(line upper ageGraph if !missing(`stat'), sort
				lcolor(maroon) lwidth(medthick) lpattern(dash))
			(line lower ageGraph if !missing(`stat'), sort
				lcolor(maroon) lwidth(medthick) lpattern(dash)),
			ylabel(, angle(horizontal) labsize(large) `noy')
			ytitle("")
			`title'
			subtitle("`subtitle'", ring(0))
			legend(off)
			xtitle("")
			xtick(59 73)
			xlabel(60(5)70, labsize(large) `nox')
			xline(62 70, lcolor(gs12))
			xsize(10) ysize(7.5)
			graphregion(color(white))
			name(robust`r', replace)
			;
			# delimit cr
			capture window manage close graph _all
			
			drop upper lower
		}

		// outsheet results to a table 
		sort order
		outsheet ageGraph b bSE if !missing(age) using ///
			"$tabdir/ageStatsDensPoly_5973_d`d'e`e''bw`bw'.txt", replace
	}
	
	// combine robustness graphs into a single graph with 9 panels
	# delimit ;
	graph combine
		robust1 robust4 robust7
		robust2 robust5 robust8 
		robust3 robust6 robust9,
		cols(3) l1title("Bunching") b1title("Age")
		graphregion(color(white)) xsize(10) ysize(7.5)
		imargin(small) ycommon
	;
	# delimit cr
	graph save "$figdir/robustnessTSPanel.gph", replace
	
/******************************************************************************/
// Robustness table for R3
/******************************************************************************/

	// calculate baseline bunching and then vary bw, excluded, degree
	
	// load and set up the basic data
	use "$datadir/cfopSSA_s1Main_400" if ///
		inrange(year, 1990, 1999) & inrange(age, 68, 73), clear 
	
	// collapse across yaers
	gen rdRound = realDistanceRound / 1e3
	keep if inrange(rdRound, -10, 31)
	collapse (sum) count, by(rdRound age)
	
	// fill in holes in the income distribution
	
	// counts --> probability
	egen tCount = total(count), by(age)
	gen prob = count / tCount
	
	// make three versions of round
	gen rd400 = rdRound
	gen rd800 = round(rdRound, 0.8)
	gen rd1600 = round(rdRound, 1.600)
	
	foreach bs of numlist 400 800 1600 {
		egen t`bs' = tag(rd`bs' age)
		egen prob`bs' = total(prob), by(rd`bs' age)
		gen s`bs' = inrange(rd`bs', -10, 30) & t`bs'
	}
	
	forvalues s = 1/7 {
		if `s' == 1 {
			noi di "& & & \multicolumn{5}{c}{Panel A: Baseline} \\"
			local bs = 800
			local degree = 7
			local exclude = 3
		}
		
		if `s' == 2 {
			noi di "& & & \multicolumn{5}{c}{Panel B: Robustness to BW} \\"
			local bs = 400
			local degree = 7
			local exclude = 7
		}
		
		if `s' == 3 {
			local bs = 1600
			local degree = 7
			local exclude = 2
		}
		
		if `s' == 4 {
			noi di "& & & \multicolumn{5}{c}{Panel C: Robustness to degree} \\"
			local bs = 800
			local degree = 6
			local exclude = 3
		}
		
		if `s' == 5 {
			local bs = 800
			local degree = 8
			local exclude = 3
		}
		
		
		if `s' == 6 {
			noi di "& & & \multicolumn{5}{c}{Panel D: Robustness to excluded region} \\"
			local bs = 800
			local degree = 7
			local exclude = 2
		}
		
		if `s' == 7 {
			local bs = 800
			local degree = 7
			local exclude = 4
		}
		
		local bsSmall = `bs' / 1e3
		forvalues a = 68/73 {
			capture bunchPoly rd`bs' prob`bs' if s`bs' & age == `a', /// 
				kink(0) exclude(`exclude') bw(`bsSmall') degree(`degree') ///
				keep(0) print(0) nboot(100)

			local rc = _rc
			if `rc' ~= 0 { 
				local b`a' = "`rc'"
				local b`a'SE = "E"
			}
			if `rc' == 0 {
				local b`a' = string(`r(scaledMass)' * `bs', "%5.1f")
				local b`a'SE =  string(`r(scaledMassSE)' * `bs', "%5.1f")
			}
		}
		
		noi di "`bs' & `degree' & `exclude' &  `b68'  &  `b69'  &  `b70'  &  `b71'  &  `b72' \\"
		noi di "    &   &   & (`b68SE') & (`b69SE') & (`b70SE') & (`b71SE') & (`b72SE') \\"

	}
	

