

// Calculate claiming rpboabilities: For each age and year, report: 



use "$datadir/rr2_s1Claim_800", clear
rename count nClaim
merge 1:1 realDistanceRound year age using "$datadir/rr2_s1All_800", assert(2 3) nogen
rename count nAll
gen nClaimS = inrange(realDistanceRound, -1e4, 3e4)*nClaim
gen nAllS = inrange(realDistanceRound, -1e4, 3e4)*nAll


collapse (sum) nAll nClaim nAllS nClaimS, by(age year)


gen pr1 = nClaim/nAll
gen pr2 = nClaimS/nAllS
list age year nClaim nAll pr1 nClaimS nAllS pr2 ///
	if inrange(age, 62, 72) & inrange(year, 1983, 1999), noobs clean


