


********************************************************************************
********************************************************************************
** Figure B2
********************************************************************************
********************************************************************************

local bw 800
local exclude = round(3000/`bw',1)


use "$datadir/s1Claim_9099", clear
sort age rd1k
by age: gen realDistanceRound = -9600 if _n == 1
by age: replace realDistanceRound = realDistanceRound[_n-1] + 800 if _n > 1

gen order = _n
sort order
local row   0
gen b           = .
gen bSE         = .
gen bSEDM       = .
gen ageGraph    = .

qui forvalues age = 59/73 {
	
	local nox "nolabel"
	if `age' >= 69 local nox ""
	local noy "nolabel"
	if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
	// Calculate bunching
	gen eSample =  age == `age'

	// estimate bunching, fill in table 
	bunchPoly realDistanceRound prob if eSample, kink(0) exclude(`exclude') ///
		bw(`bw') degree(7) keep(1) print(0) nboot(100)
	local ++row
	replace ageGraph    = `age' in `row'
	sort order
	replace b          = r(scaledMass)*`bw' in `row'
	replace bSE        = r(scaledMassBS)*`bw' in `row'
	replace bSEDM      = r(scaledMassSE)*`bw' in `row'

	drop smoothDensity fit eSample
	
}

gen upper = b + 1.96*bSE
gen lower = b - 1.96*bSE
# delimit ;
twoway
	(connected b ageGraph)
	(line upper ageGraph, lpattern(dash) lcolor(cranberry))
	(line lower ageGraph, lpattern(dash) lcolor(cranberry)),
	xtitle("Age") 
	ytitle("Normalized excess mass")
	yline(0, lcolor(gs12)) xline(62 70, lcolor(gs12))
	graphregion(color(white))
	xlabel(60(5)70) xtick(59 73)
	legend(off)		
	
;
# delimit cr
graph export "$figdir/figureB2.png", replace width(2000) height(1500)

