function calib_out = calib_shk;

% Calibrate autocorrelations and standard deviations for labor productivity
% shock and job separation shock following Shimer's (2005) approach

% Sample period: 1967:Q3 - 2017:Q3 for labor productivity; 1967:m7 -
% 2017:m7 for job separation rate.  A linear trend is removed from
% productivity

% Parameters for productivity shock
rho_z_q = 0.9727;
sigma_z_q = 0.0085;

% Converting productivity shock parameters from quarterly to monthly:
rho_z = rho_z_q^(1/3);
stderr_ez = sigma_z_q/sqrt(1+rho_z^2+rho_z^4);

% Paramerers for job separation shock
rho_delta = 0.9806;
stderr_edelta = 0.0020;

calib_out=[rho_z, rho_delta, stderr_ez, stderr_edelta];

