% Older Americans Would Work Longer If Jobs Were Flexible
% by Ameriks, Briggs, Caplin, Lee, Shapiro, and Tonetti
% This version: January 2019. 

% This code generates Figure 5, which illustrates the ranges of the IES and
% theta that are compatible with a direct transition into full retirement.


clear all
clc

% Calibration: Considers a person whose reference work condition is
% full-time (h_0 = 0.385). Fixed costs of work are 4% of total time and 14%
% of the labor earnings under the full time work. 
h0 = 0.385; 
chat = 0.14; hbar = 0.04; 

% Considered values of IES, and their mapping into the minimum values of
% theta to be able to generate a direct transition into no work, following
% equation (6). 
IES = 0.2:0.05:2;
gamma = IES*(h0)/(1-h0);
theta = ((1-chat)*h0*(1-1./gamma))./(((1-hbar-h0).^(1./gamma)).*(1-(1-hbar-h0).^(1-1./gamma))) - 1; 
theta2 = max(theta)*ones(size(theta)); 

figure(1)
plot(IES,theta); 
hold on
plot(IES,theta2); 
XX = [IES,fliplr(IES)];
inBetween = [theta,fliplr(theta2)];
fill(XX,inBetween,'g');
xlabel('IES')
ylabel('\theta')
axis tight

% Adding two vertical lines (one blue and one red) shown in Figure 5. 
IES_hat = 0.40; 
gamma_hat = IES_hat*(h0)/(1-h0);
theta_hat = ((1-chat)*h0*(1-1./gamma_hat))./(((1-hbar-h0).^(1./gamma_hat)).*(1-(1-hbar-h0).^(1-1./gamma_hat))) - 1; 
y = theta_hat*0.5+0.5*max(theta);
err = y-theta_hat;
errorbar(IES_hat,y,err,'r'); 

IES_hat = 1; 
gamma_hat = IES_hat*(h0)/(1-h0);
theta_hat = ((1-chat)*h0*(1-1./gamma_hat))./(((1-hbar-h0).^(1./gamma_hat)).*(1-(1-hbar-h0).^(1-1./gamma_hat))) - 1; 
y = theta_hat*0.5+0.5*max(theta);
err = y-theta_hat;
errorbar(IES_hat,y,err,'b'); 
hold off