version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global table_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Tables" // put your directory here;


use "$data_dir/final_data_AER.dta", clear;

   
foreach var of varlist 
	hh_head_literate hh_head_age total_land_inherited caste_non_marginal {;
	
	gen cm_`var' = `var';
	replace cm_`var' = 0 if `var' == .;
	
	gen msng_`var' = (`var' == .);
	
};


global hh_head_controls 
	"cm_hh_head_literate cm_hh_head_age cm_total_land_inherited cm_caste_non_marginal
	msng_hh_head_literate msng_hh_head_age msng_total_land_inherited msng_caste_non_marginal";  





foreach var of varlist ln_age_first_bw ln_first_bw_depth ln_first_bw_cost first_bw_flow {;
	gen m_`var' = 0;
	replace m_`var' = 1 if first_bw_failed ~= . & `var' == .;
	replace `var' = 1 if first_bw_failed ~= . & `var' == .;
};



gen dummy_fe = 1;


global hh_head_controls 
	"cm_hh_head_literate cm_hh_head_age cm_total_land_inherited cm_caste_non_marginal
	msng_hh_head_literate msng_hh_head_age msng_total_land_inherited msng_caste_non_marginal";

	
estimates clear;	


eststo: reghdfe first_bw_failed ln_age_first_bw ln_first_bw_depth m_ln_age_first_bw
	m_ln_first_bw_depth
	$hh_head_controls
	if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(dummy_fe) cluster(villcode);

eststo: reghdfe first_bw_failed ln_age_first_bw ln_first_bw_depth m_ln_age_first_bw
	m_ln_first_bw_depth
	$hh_head_controls
	if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode) cluster(villcode);

eststo: reghdfe first_bw_failed  ln_first_bw_depth  
	m_ln_first_bw_depth
	$hh_head_controls
	if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled) cluster(villcode);
	
	
eststo: reghdfe first_bw_failed ln_age_first_bw ln_first_bw_cost m_ln_age_first_bw
	m_ln_first_bw_cost 
	$hh_head_controls
	if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(dummy_fe) cluster(villcode);

eststo: reghdfe first_bw_failed ln_age_first_bw ln_first_bw_cost m_ln_age_first_bw
	m_ln_first_bw_cost
	$hh_head_controls
	if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode) cluster(villcode);

eststo: reghdfe first_bw_failed ln_first_bw_cost
	m_ln_first_bw_cost
	$hh_head_controls
	if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled) cluster(villcode);


esttab using "$table_dir/_TableA2 determinants of firstBW failure (AER).csv", replace
keep (ln_age_first_bw ln_first_bw_depth ln_first_bw_cost 
	cm_hh_head_literate cm_hh_head_age cm_caste_non_marginal cm_total_land_inherited)
order (ln_age_first_bw ln_first_bw_depth ln_first_bw_cost 
	cm_hh_head_literate cm_hh_head_age cm_caste_non_marginal cm_total_land_inherited)
cells(b(star fmt(%9.3f)) se(abs par fmt(%9.3f)) )
extracols(1 4)
starlevels (* 0.10 ** 0.05 *** 0.01) label
stats (r2 N, fmt(%9.3f %9.0g) labels(R-squared));	
estimates clear;
