version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global table_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Tables" // put your directory here;


use "$data_dir/final_data_AER.dta", clear;



global strformat "%8.3f";

capture program drop sig_p;
program sig_p;
   args obj_var point_est_var point_sd_var p_val row_id_var row_num;
   local point_est `point_est_var';
   local point_sd `point_sd_var';
   if `p_val' > 0.1 {;
      replace `obj_var' = string(`point_est', "$strformat") if `row_id_var' == `row_num';
      };
   if `p_val' > 0.05 & `p_val' <= 0.1  {;
      replace `obj_var' = string(`point_est', "$strformat")+"*" if `row_id_var' == `row_num';
      };
   if `p_val' > 0.01 & `p_val' <= 0.05  {;
      replace `obj_var' = string(`point_est', "$strformat")+"**" if `row_id_var' == `row_num';
      };
   if `p_val' <= 0.01 {;
      replace `obj_var' = string(`point_est', "$strformat")+"***" if `row_id_var' == `row_num';
      };
   replace `obj_var' = "[" + string(`point_sd', "$strformat") + "]" + " " if `row_id_var' == `row_num' + 1;
   end;


   
foreach var of varlist 
	hh_head_literate hh_head_age total_land_inherited caste_non_marginal {;
	
	gen cm_`var' = `var';
	replace cm_`var' = 0 if `var' == .;
	
	gen msng_`var' = (`var' == .);
	
};


global hh_head_controls 
	"cm_hh_head_literate cm_hh_head_age cm_total_land_inherited cm_caste_non_marginal
	msng_hh_head_literate msng_hh_head_age msng_total_land_inherited msng_caste_non_marginal"; 


generate row_num = _n;

	
local row = 4;
forvalues i=0(1)25 {;
	generate col`i' = "";
};

order col*;
sort row_num;
	
	
foreach var of varlist 
	k_num_jobs_avg_hh_member_a k_pct_hh_mem_ownfarm_a k_pct_hh_mem_aglabor_a 
	k_pct_hh_mem_wagelabor_a 
	k_pct_hh_mem_notworking_a {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' if bw_never ~= 1 & household_level == 1 & first_bw_failed == 0 [aw=hh_weight_norm];
	replace col2 = string(r(mean), "$strformat") if row_num == `row';
	

	reghdfe `var' first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode) cluster(villcode);
	test first_bw_failed;
	sig_p col4 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';
	
	reghdfe `var' first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_failed;
	sig_p col5 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';

	local row = `row' + 3;
	
};

foreach var of varlist 
	r_num_jobs_avg_hh_member_a r_pct_hh_mem_ownfarm_a r_pct_hh_mem_aglabor_a 
	r_pct_hh_mem_wagelabor_a 
	r_pct_hh_mem_notworking_a {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' if bw_never ~= 1 & household_level == 1 & first_bw_failed == 0 [aw=hh_weight_norm];
	replace col2 = string(r(mean), "$strformat") if row_num == `row';
	
	
	reghdfe `var' first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode) cluster(villcode);
	test first_bw_failed;
	sig_p col4 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';
	
	reghdfe `var' first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_failed;
	sig_p col5 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';
		
	local row = `row' + 3;
	
};



local row = `row' + 1;


foreach var of varlist 
	pct_hh_mem_snlmigrat_a
	k_pct_hh_mem_outvillwork r_pct_hh_mem_outvillwork_a {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' if bw_never ~= 1 & household_level == 1 & first_bw_failed == 0 [aw=hh_weight_norm];
	replace col2 = string(r(mean), "$strformat") if row_num == `row';
	
	
	reghdfe `var' first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode) cluster(villcode);
	test first_bw_failed;
	sig_p col4 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';
	
	reghdfe `var' first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_failed;
	sig_p col5 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';


		
	local row = `row' + 3;
	
};



local row = `row' + 1;


order col0-col25;
sort row_num;	


outsheet col0-col5 using "$table_dir/_Table4 labor (AER).csv" if
	row_num < `row', comma replace;

