* summarize clinical trials data

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/"

********************************************************************
* merge data sets

* product entry dates collapse and clean
use data/USdata_agg, clear
gen age_enterUS = age if t==enterUS
collapse enterUS age_enterUS, by(manufacturer product)
sort manufacturer product
tempfile temp_US   
save "`temp_US'" 
*
use data/EUdata_agg, clear
merge m:1 manufacturer product using "`temp_US'"
keep manufacturer product t j tj enterEU age USeventual enterUS age_enterUS
gen age_enterEU = age if t==enterEU
collapse (min) j enterEU enterUS USeventual age_enterEU age_enterUS, by(manufacturer product) //min j keeps non-old FE
replace age_enterEU = 1 if age_enterEU==. & enterEU~=.
replace age_enterUS = 1 if age_enterUS==. & enterUS~=.
gen EUentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterEU - age_enterEU)
gen USentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterUS - age_enterUS)
format EUentryDate USentryDate %td
* merge clinical trial data
sort manufacturer product
merge 1:m manufacturer product using "data/ClinicalTrialData", keep(match) nogen
sort j
tempfile temp1    
save "`temp1'"      
* merge Qj from demand estimates
insheet b j Qj Qj1 using "temp/Parameters_QjFE_0.csv", clear
drop b
rename qj Qj
rename qj1 Qj1
sort j
merge 1:m j using "`temp1'" , keep(match) nogen
*


********************************************************************
* summary of trials completed by EU and US approval

sort manufacturer product date
gen preEU = (date<EUentryDate)
gen preUS = (date<USentryDate)
gen all = 1

foreach entry in 0 1 {
foreach trialpre in preEU preUS all {
preserve
keep if USeventual==`entry' & `trialpre'==1
collapse (max) NpTreatment Npatients FollowUp Tfu PrimaryFU Trecruiting Tprimary , by(manufacturer product Trial)
collapse (sum) NpTreatment Npatients PrimaryFU Trecruiting Tprimary (mean) FollowUp Tfu (count) Trials=NpTreatment, by(manufacturer product)
collapse (count) N=NpTreatment (mean) Trials PrimaryFU FollowUp Tfu NpTreatment Npatients Trecruiting Tprimary (median) NpT_med=NpTreatment Np_med=Npatients Tfu_med=Tfu  Trec_med=Trecruiting Tpri_med=Tprimary
export excel "output/ClinicalTrials_sum_USe`entry'_`trialpre'.xlsx", firstrow(variables) replace
restore
}
}
preserve
keep if preEU==1
collapse (max) NpTreatment Npatients FollowUp Tfu PrimaryFU Trecruiting Tprimary , by(manufacturer product Trial)
collapse (sum) NpTreatment Npatients PrimaryFU Trecruiting Tprimary (mean) FollowUp Tfu (count) Trials=NpTreatment, by(manufacturer product)
collapse (count) N=NpTreatment (mean) Trials PrimaryFU FollowUp Tfu NpTreatment Npatients Trecruiting Tprimary (median) NpT_med=NpTreatment Np_med=Npatients Tfu_med=Tfu  Trec_med=Trecruiting Tpri_med=Tprimary
export excel "output/ClinicalTrials_sum_All_preEU.xlsx", firstrow(variables) replace
restore
*
preserve
keep if PrimaryFU==1
collapse (max) Npatients NpTreatment FollowUp Tfu PrimaryFU Trecruiting Tprimary , by(manufacturer product Trial USeventual preEU preUS)
twoway (scatter Trecruiting Npatients if Npatients<4000 & Trecruiting<1000, mcolor(navy) msymbol(Oh) )  ///
	(lfitci Trecruiting Npatients if Npatients<4000 & Trecruiting<1000, lcolor(navy) lpattern(-) lwidth(thick) ciplot(rline) blcolor(navy) blpattern(-) blwidth(thin) )  ///  
 	, legend(off) graphregion(color(white)) ///
	xtitle("Patients in Trial",size(large)) xlabel(,labsize(large)) ///
	ytitle("Time Recruiting (Days)",size(large)) ytick(0(200)1000) ylabel(0(200)1000,labsize(large)) 
graph export "output/fig_TrialTime_vs_Npatients_recruitment.pdf", replace 
twoway (scatter Trecruiting Npatients if Npatients<400, mcolor(navy) msymbol(Oh) )  ///
	(lfitci Trecruiting Npatients if Npatients<400, lcolor(navy) lpattern(-) lwidth(thick) ciplot(rline) blcolor(navy) blpattern(-) blwidth(thin) )  ///  
 	, legend(off) graphregion(color(white)) ///
	xtitle("Patients in Trial",size(large)) xlabel(,labsize(large)) ///
	ytitle("Time Recruiting (Days)",size(large)) ytick(0(200)1000) ylabel(0(200)1000,labsize(large)) 
graph export "output/fig_TrialTime_vs_Npatients_recruitment_small.pdf", replace 
twoway (scatter Trecruiting Npatients if Npatients>400 & Npatients<4000 & Trecruiting<1000, mcolor(navy) msymbol(Oh) )  ///
	(lfitci Trecruiting Npatients if Npatients>400 & Npatients<4000 & Trecruiting<1000, lcolor(navy) lpattern(-) lwidth(thick) ciplot(rline) blcolor(navy) blpattern(-) blwidth(thin) )  ///  
 	, legend(off) graphregion(color(white)) ///
	xtitle("Patients in Trial",size(large)) xlabel(,labsize(large)) ///
	ytitle("Time Recruiting (Days)",size(large)) ytick(0(200)1000) ylabel(0(200)1000,labsize(large)) 
graph export "output/fig_TrialTime_vs_Npatients_recruitment_big.pdf", replace 
restore

********************************************************************
* figure Qj vs. Trial outcomes

rename Qj Qj_preUS
rename Qj1 Qj_preEU
tab Tfu, gen(fuFE)
*
foreach random in 0 {
foreach lb in 0 {
*preserve
*keep if NpTreatment>`lb' & RCT>=`random'
*foreach outcome in MACE_V MACE_L TVR TLR LL {
foreach outcome in TVR {
*
*
replace `outcome' = log(`outcome')
reg `outcome' fuFE1-fuFE4 fuFE6-fuFE9 [w=Npatients]
predict `outcome'_r, r
replace `outcome' = exp(`outcome'_r+_b[_cons])
drop `outcome'_r
*
foreach var in preUS preEU {
preserve
keep if `var'==1
keep if Npatients>`lb' & RCT>=`random'
collapse Qj_`var' `outcome' (max) Npatients NpTreatment FollowUp Tfu PrimaryFU RCT, by(manufacturer product Trial)
*collapse Qj_`var' `outcome' FollowUp Tfu (rawsum) NpTreatment PrimaryFU (count) Trials=NpTreatment [aweight=NpTreatment], by(manufacturer product)
*
replace Qj_`var' = 4744*log(1+exp(Qj_`var')) //* (1+exp(Qj_`var'))/exp(Qj_`var')
*
su `outcome', detail
keep if `outcome'<`r(p99)' & `outcome'>`r(p1)'
su Qj_`var', detail
keep if Qj_`var'<`r(p99)' & Qj_`var'>`r(p1)'
*
*reg Qj_`var' `outcome'
twoway (lfitci Qj_`var' `outcome' [w=Npatients] if Npatients>`lb' & RCT>=`random', lcolor(navy) lwidth(thick) ciplot(rline) blcolor(navy) blwidth(thin) blpattern(-)) /// 
	(scatter Qj_`var' `outcome' [w=Npatients] if Npatients>`lb' & RCT>=`random', mcolor(navy) msymbol(Oh)) ///
	, legend(off) graphregion(color(white)) ///
	ytitle("Estimated ATE(Qj_`var') ($)",size(large)) ytick(0(200)1000) ylabel(0(200)1000,labsize(large))   ///
	xtitle("`outcome' rate from Clinical Trial Data",size(large)) xlabel(,labsize(large)) 
graph export "output/fig_Qj_`var'_`outcome'_Npmin`lb'_RCT`random'.pdf", replace 
*
gen `outcome'_`var' = `outcome'
keep manufacturer product Trial Qj_`var' `outcome'_`var' Npatients RCT
tempfile `var'   
save "`var'", replace
restore
}
*
use "preEU", clear
merge 1:1 manufacturer product Trial Npatients RCT using "preUS"
gen Qj_D = Qj_preUS - Qj_preEU
gen `outcome'_D = `outcome'_preUS - `outcome'_preEU
twoway (lfitci Qj_D `outcome'_D [w=Npatients] if Npatients>`lb' & RCT>=`random', lcolor(navy) lwidth(thick) ciplot(rline) blcolor(navy) blwidth(thin) blpattern(-)) /// 
	(scatter Qj_D `outcome'_D [w=Npatients] if Npatients>`lb' & RCT>=`random', mcolor(navy) msymbol(Oh)) ///
	, legend(off) graphregion(color(white)) ///
	ytitle("(Change in) Estimated ATE(Qj) ($)",size(large)) ytick(0(200)1000) ylabel(0(200)1000,labsize(large))   ///
	xtitle("(Change in) `outcome' rate from Clinical Trial Data",size(large)) xlabel(,labsize(large)) 
graph export "output/fig_Qj_D_`outcome'_Npmin`lb'_RCT`random'.pdf", replace 
reg Qj_D `outcome'_D [w=Npatients] if Npatients>`lb' & RCT>=`random'
*
}
*restore
}
}

/*

foreach outcome in LL {
*
*
replace `outcome' = log(`outcome')
reg `outcome' fuFE1-fuFE4 fuFE6-fuFE9 [w=Npatients]
predict `outcome'_r, r
replace `outcome' = exp(`outcome'_r+_b[_cons])
drop `outcome'_r
*
foreach var in preEU{
preserve
drop if Npatients>300
keep if `var'==1
keep if enterEU>2
collapse Qj_`var' `outcome' (max) Npatients NpTreatment FollowUp Tfu PrimaryFU RCT, by(manufacturer product Trial)
*collapse Qj_`var' `outcome' FollowUp Tfu (rawsum) NpTreatment PrimaryFU (count) Trials=NpTreatment [aweight=NpTreatment], by(manufacturer product)
*
replace Qj_`var' = 4744*log(1+exp(Qj_`var')) //* (1+exp(Qj_`var'))/exp(Qj_`var')
*
su `outcome', detail
keep if `outcome'<`r(p99)' & `outcome'>`r(p1)'
su Qj_`var', detail
keep if Qj_`var'<`r(p99)' & Qj_`var'>`r(p1)'
*
*reg Qj_`var' `outcome'
twoway (lfitci Qj_`var' `outcome' [w=Npatients] , lcolor(navy) lwidth(thick) ciplot(rline) blcolor(navy) blwidth(thin) blpattern(-)) /// 
	(scatter Qj_`var' `outcome' [w=Npatients] , mcolor(navy) msymbol(Oh)) ///
	, legend(off) graphregion(color(white)) ///
	ytitle("Estimated ATE(Qj_`var') ($)",size(large)) ytick(0(200)1000) ylabel(0(200)1000,labsize(large))   ///
	xtitle("`outcome' rate from Clinical Trial Data",size(large)) xlabel(,labsize(large)) 
graph export "output/fig_Qj_`var'_`outcome'_Npmin0_RCT0.pdf", replace 
restore
}
}




