*Learning Patterns for Selected Products

set more off

cd  "~/Dropbox/IntlMedDevMkts/"
use MGanalysis/EUdata, clear
drop if age>36

keep if product=="Costar"

* what happens to usage / quality estimates
twoway (scatter lnd t if product=="Costar", mcolor(grey) msymbol("o")) ///
	, legend(off) graphregion(color(white)) ///
	ytitle("ln(sj/s0) in EU",size(large)) ylabel(,labsize(large)) ///
	xtitle("") xlabel(25 "Jan06" 37 "Jan07" 49 "Jan08", angle(35) labsize(large) ) ///
	xline(22, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(22 "TCT 2005", add custom angle(35) labcolor(red) labsize(large)) /// 
	xline(26, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(26 "DES Summit 2006", add custom angle(35) labcolor(red) labsize(large)) ///
	xline(35, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(35 "J&J Acquires Conor", add custom angle(35) labcolor(red) labsize(large)) /// 
	xline(40, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(40 "Release Failed Trial" , add custom angle(35) labcolor(red) labsize(large))
graph export output/fig_MeanVsTime_CoStar_scatter.pdf, replace 

twoway (line lnd t if product=="Costar", lcolor(grey) lwidth(thick)) ///
	, legend(off) graphregion(color(white)) ///
	ytitle("ln(sj/s0) in EU",size(large)) ylabel(,labsize(large)) ///
	xlabel(25 "Jan06" 37 "Jan07" 49 "Jan08", angle(35) labsize(large) ) ///
	xline(22, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(22 "TCT 2005", add custom angle(35) labcolor(red) labsize(large)) /// 
	xline(26, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(26 "DES Summit 2006", add custom angle(35) labcolor(red) labsize(large)) ///
	xline(35, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(35 "J&J Acquires Conor", add custom angle(35) labcolor(red) labsize(large)) /// 
	xline(40, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(40 "Release Failed Trial" , add custom angle(35) labcolor(red) labsize(large))
graph export output/fig_MeanVsTime_CoStar.pdf, replace 


* and volatility first differences within product
sort product t
by product: gen lnd_diff = abs(lnd-lnd[_n+1])
drop if lnd_diff==.

twoway (line lnd_diff t if product=="Costar", lcolor(grey) lwidth(thick)) ///
	, legend(off) graphregion(color(white)) ///
	ytitle("Month-to-Month Difference (Absolute) in ln(sj/s0)") ///
	xtitle("Calendar Time (Months)") xlabel(25 "Jan06" 37 "Jan07" 49 "Jan08", angle(35) ) ///
	xline(22, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(22 "TCT 2005", add custom angle(35) labcolor(red)) /// 
	xline(26, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(26 "DES Summit 2006", add custom angle(35) labcolor(red)) ///
	xline(35, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(35 "J&J Acquires Conor", add custom angle(35) labcolor(red)) /// 
	xline(40, lcolor(red) lpattern(solid) lwidth(thin)) xlabel(40 "Release Failed Trial" , add custom angle(35) labcolor(red))
graph export output/fig_MeanFirstDiffVsTime_CoStar.pdf, replace 
