#!/bin/bash
#$ -j y
#$ -o logs/$JOB_NAME-$JOB_ID-$TASK_ID.log
#$ -q short.q
#$ -l m_mem_free=1G

# create array of all possible options
tasks=()

# tasks - 1 job (pEq does 31 per job in step1, and 1 job in step2)
for bs in {0..100}; do
	tasks+=( "$bs 4 7 0 1 1 1 1" ) #BASE
done
# 

# set your variables for THIS task
echo ${tasks[$SGE_TASK_ID-1]} | while read bs mod ptc us dis mc siga2 sigac2; do
    echo "$JOB_NAME bs: $bs mod: $mod paramtochange: $ptc usflag: $us discountflag: $dis mc_rob: $mc siga2: $siga2 sigac2: $sigac2 "

    # pick the job you want based on job name and task
	   echo "step2"
    matlab -nodisplay -r "clear all; cd '~/IntlMedDevMkts/code'; Master_Cfcl_Optimality_b_pEq_v3($bs, $mod, $ptc, $us, $dis, $mc, $siga2, $sigac2); exit"
	
done
