*****

global dirwork  "~/Dropbox/Research/IntlMedDevMkts/_temp-mike"
global progname     "cleaning-eu-data"


* The program and output folders are each assigned to a unique variable
global dirdocuments "$dirwork/_documents"
global dirresults   "$dirwork/_results"
global dirprograms  "$dirwork/_programs"
global dirscratch   "$dirwork/_scratch/$progname"

* The original and analysis subfolders are each assigned to separate variables
* This provides some protection against accidentally destrotying the original data
global dirodata     "$dirwork/_data/original"
global diradata     "$dirwork/_data/analysis"

* Create scratch folder if necessary
cap mkdir $dirscratch

cap log close
log using $dirscratch/log.txt, replace t

* Change working directory
cd $dirwork

set more off

*****
***** MERGE DIAGNOSTIC DATA INTO DEVICE UTILIZATION DATA
*****
	
	*** Use device usage data
	clear
	use $dirscratch/EUdevices_unclean_2013Q2.dta
	
	*** Merge to diagnostic info data
    merge m:1 lab_id yyyy mm statistics_id using $dirscratch/EUprocedures_unclean_2013Q2.dta
	drop if _merge == 2
	
	*** Check that unmerged obs. from master data correspond to dropped statistics_id's from diagnostic data, drop
	tab statistics_id if _merge==1
	* 2343 7987 8252 8548 15168 
	* list lab_id yyyy mm statistics_id if statistics_id==2343 | statistics_id==7987 | statistics_id==8252 | statistics_id==8548 | statistics_id==15168
	drop if _merge==1
	drop _merge
	
*****
***** BASIC CLEANING
*****
	
	*** Keep balloons
		keep if group=="PTCA Balloons"
		keep if balloon=="Normal"

	*** Saving dataset for merge with US
	keep lab_id mm yyyy country manufacturer q revenueus product avgprice diagnosticangiography
	rename revenueus revenue
	order lab_id mm yyyy country manufacturer product q revenue avgprice diagnosticangiography
		save $dirscratch/EUballoons.dta, replace
		
