###################################################################
# Name              : CobbDouglas_OLS_fullyinteracted.R
# 
# Description       : This program estimates Cobb Douglas production 
#                     functions for cognitive and socio-emotional 
#                     skills (full specification) where all variables 
#                     are interacted with the tretament dummy. 
###################################################################

Xnames      <- c( "kids", "kids_T")
nS = 2 

###################################################################
# Define function to estimate production function by OLS
# This function produces "naive" estimates not correcting for the 
# fact that we're using factor scores as well as adjusted 
# estimates correcting for that fact 
###################################################################
pf.ols.estim.func             <- function(scores, data, eps, mean, cov, prob, missing){
  
  # Load data
  setwd(dir_data)     
  measures <- read.csv(data, header=T)
  measures <- measures[order(measures$treat), ]
  n        <- nrow(measures)
  
  # Get estimates of measurement system Ineed for estimation of correction bias 
  totmean    <- matrix(0, nF, nG)
  for (g in 1:nG)  totmean[,g] <- prob[[g]] %*% mean[[g]]

  # Define observables 
  Zall         <- cbind(measures$meanprice_juglibros_log_st, measures$FUmeanprice_log_st, measures$tpobc_pop1993_st)
  X1           <- cbind(measures$ln_nkids0_st, measures$ln_nkids0_st*measures$treat) 
  Xnames       <- c( "kids", "kids_T")

  
  mscoresall   <- rbind(scores[[1]], scores[[2]])
  keep         <- which(complete.cases(cbind(Zall,X1, mscoresall)))
  keep1        <- which(complete.cases(cbind(Zall,X1, mscoresall)[which(measures$treat==1),]))
  keep2        <- which(complete.cases(cbind(Zall,X1, mscoresall)[which(measures$treat==2),]))
  treatnomiss  <- measures$treat[keep]
  
  if (missing=="FALSE"){
    fs   <- list()
    fs[[1]] <- scores[[1]][keep1,]
    fs[[2]] <- scores[[2]][keep2,]
  } else if (missing=="TRUE"){
    fs   <- scores
  }
  
  pos           <- c(2,4,5, 6, 7,8)
  
  # Reduced form with all 
  X           <- X1[keep,]
  
  RHSnames    <- c("treat", "cog0",  "ncog0",  "mat", "time",   "cogmo", "ncogmo", "cog0_T", "ncog0_T","mat_T","time_T","cogmo_T", "ncogmo_T", Xnames)
  
  pf.ols   <-  pf.ols.fullyinteract.func(fs, X, Xnames, treatnomiss, RHSnames, pos, totmean, mean, cov, prob, parametric=1)

  return(pf.ols)
} 

###################################################################
# Estimate production function on true data and bootstrapped samples 
# using function above 
###################################################################
for (boot in 0:Bootstrap){

    ## Estimate on true data 
  if (boot==0){  
   
       # Load input needed for function 
      setwd(dir_outputFM)
      load("trueFM.R")
      load("fs_true.R")
    
      # Estimate first stage and reduced forms 
      out_true           <- pf.ols.estim.func(list(fs_true[[5]],fs_true[[6]]), "measures.csv",  eps, mean.mix, cov.mix, prob.mix, missing="FALSE")
      
      # Rename output 
      pf_true       <- out_true[[1]]
      pfbias_true   <- out_true[[2]]
  } 

  ## Estimate on bootstrapped data
  if (boot==1 ){ 
      nof <- length(noflagFS)
 
      setwd(dir_outputFM)
      load("fs_bstrap.R")
      
      # Define output 
      pf_bstrap <- array(0, dim=c(nrow(pf_true), ncol(pf_true), nof))
      pfbias_bstrap <- array(0, dim=c(nrow(pfbias_true), ncol(pfbias_true), nof))
    
      # Estimate function on each bstrap sample
      for (b in 1:nof){
        # Estimate first stage and reduced forms 
          out_bstrap   <- pf.ols.estim.func(fs_bstrap_allBFGS[[noflag[b]]], paste("measures_b", noflag[b], ".csv", sep=""), 
                                      epsBoot[,noflag[b]],
                                      list(meanBoot[,,noflag[b],1], meanBoot[,,noflag[b],2]), 
                                      list(covBoot[,,noflag[b],1],covBoot[,,noflag[b],2]), 
                                      list(probBoot[,noflag[b],1], probBoot[,noflag[b],2]), 
                                      missing="FALSE")
          
          print(b)
          pf_bstrap[,,b]        <- out_bstrap[[1]]
          pfbias_bstrap[,,b]    <- out_bstrap[[2]]
      } 

  } 

} 

##############################################################################
# Create table of estimates (point estimate followed by bootstrapped 
# standard errors, 95% ci, p-value one tail test and p-value two tailed test)
##############################################################################

outtrue     <- list(pf_true, pfbias_true)  
outb        <- list(pf_bstrap, pfbias_bstrap) 

outtable        <- list()
for (s in 1:2) {
  npar                 <- nrow(outtrue[[s]])
  outtable[[s]]        <- matrix(0, npar*4, 2)
  for (j in 1:2){
    for (i in 1:npar){
      outtable[[s]][(i*4-3), j]  <- round(outtrue[[s]][i,j],3)
      outtable[[s]][(i*4-2),j]   <- round(sd(outb[[s]][i,j,]),3) 
      outtable[[s]][i*4-1, j]      <- paste("[", round(quantile(outb[[s]][i,j,], .025),3), ",", 
                                            round(quantile(outb[[s]][i,j,], .975),3), "]", sep="") 
      outtable[[s]][i*4, j]      <- paste("[", round(quantile(outb[[s]][i,j,], .05),3), ",", 
                                          round(quantile(outb[[s]][i,j,], .95),3), "]", sep="") 
    } 
  } 
} 



outtrue     <- list(pf_true, pfbias_true)  
outb        <- list(pf_bstrap, pfbias_bstrap) 

outtable        <- list()
for (s in 1:2) {
  npar                 <- nrow(outtrue[[s]])
  outtable[[s]]        <- matrix(0, npar*5, nS)
  
  for (i in 1:npar){
    for (j in 1:nS){
      
      mean             <- mean(outb[[s]][i,j,])
      se               <- sd(outb[[s]][i,j,])
      t_stat           <- mean/se
      t_crit           <- (outb[[s]][i,j,] - mean)/se
      p_val            <- 1 - ecdf(t_crit)(t_stat)
      p_val2           <- 1 - ecdf(t_crit^2)(t_stat^2)
      
      outtable[[s]][(i*5-4), j]  <- round(mean,3)
      outtable[[s]][(i*5-3),j]   <- round(se,3) 
      outtable[[s]][(i*5-2), j]  <- paste("[", round(quantile(outb[[s]][i,j,], .025),3), ",", 
                                          round(quantile(outb[[s]][i,j,], .975),3), "]", sep="") 
      outtable[[s]][(i*5-1), j]  <- p_val 
      outtable[[s]][i*5, j]      <- p_val2 
    } 
  } 
} 



# F-test of interactions 
indicator        <- function(condition) ifelse(condition,1,0)

ftest.func     <- function(tt, invest, bootinvest, nof){
  
  beta1          <- invest[tt,1]
  beta2          <- invest[tt,2]
  nP             <- length(tt)
  mbootcoef1   <- rowMeans(bootinvest[tt,1,], na.rm=TRUE)
  mbootcoef2   <- rowMeans(bootinvest[tt,2,], na.rm=TRUE)
  vcov1        <- array(0, dim=c(nP, nP, nof))
  vcov2        <- array(0, dim=c(nP, nP, nof))
  
  for (i in 1:nof){
    vcov1[,,i]    <- (bootinvest[tt,1,i] - mbootcoef1) %*% t(bootinvest[tt,1,i] - mbootcoef1)
    vcov2[,,i]    <- (bootinvest[tt,2,i] - mbootcoef2) %*% t(bootinvest[tt,2,i] - mbootcoef2)
  }
  
  vcov1f       <- matrix(0, nP, nP)
  vcov2f       <- matrix(0, nP, nP)
  
  for (j in 1:nP){
    for (k in 1:nP){
      vcov1f[j,k]        <- 1/nof * sum(vcov1[j,k,])
      vcov2f[j,k]        <- 1/nof * sum(vcov2[j,k,])
    }
  }
  
  tbeta1 <- matrix(beta1, length(tt),1)
  tbeta2 <- matrix(beta2, length(tt),1)
  test1 <- beta1 %*% solve(vcov1f) %*% tbeta1
  test2 <- beta2 %*% solve(vcov2f) %*% tbeta2
  
  boottest1 <- rep(0,nof)
  boottest2 <- rep(0,nof)
  for (b in 1:nof){
    boottest1[b] <- (bootinvest[tt,1,b] - beta1 )%*% solve(vcov1f) %*% matrix((bootinvest[tt,1,b] - beta1 ), length(tt), 1)
    boottest2[b] <- (bootinvest[tt,2,b] - beta2 )%*% solve(vcov2f) %*% matrix((bootinvest[tt,2,b] - beta2 ), length(tt), 1)
  }
  
  
  pvalue1          <- 1/nof * sum(indicator(boottest1>rep(test1, nof)))
  pvalue2          <- 1/nof * sum(indicator(boottest2>rep(test2, nof)))
  
  return(c(pvalue1, pvalue2))
}

out_ftest       <- rbind(ftest.func(c(9:14, 16) , pf_true, pf_bstrap, nof),ftest.func(c(2,9:14, 16) , pf_true, pf_bstrap, nof))

outtable[[1]] <- rbind(outtable[[1]], out_ftest)

# Name output rows and columns 
pfnames   <- c("TFP", "", "", "", "",
               "Treatment", "", "", "", "", 
               "Log child's cognitive skill (t)","", "", "", "", 
               "Log child's socio-emotional skill (t)", "", "", "", "", 
               "Log material investment (t+1)", "", "","", "", 
               "Log time investment (t+1)", "", "","", "", 
               "Log mother's cognitive skill (t)", "", "", "", "", 
               "Log mother's socio-emotional skill (t)", "", "", "", "", 
               "Baseline cognition * Treatment","", "", "", "", 
               "Baseline socio-emotional skills * Treatment", "", "", "", "", 
               "Material investment * Treatment", "", "","", "", 
               "Time investment * Treatment", "", "","", "", 
               "Mother's cognitive skills * Treatment", "", "", "", "", 
               "Mother's socio-emotional skill * Treatment", "", "", "", "", 
               "Log number of children", "", "","", "", 
               "Number of children in the household * Treatment", "", "","","")


rownames(outtable[[1]]) <- c(pfnames, 
"F-test (interactions, no intercept)", 
"F-test (interactions, with intercept)") 
rownames(outtable[[2]]) <- pfnames  
for (s in 1:2){
  colnames(outtable[[s]]) <- c("Cognitive skills", "Socio-emotional skills")
}


# Save output 
setwd(dir_outputPF)
save(pf_true, pfbias_true, pf_bstrap, pfbias_bstrap, outtrue, outb, outtable, file=paste("OUTPUT_OLS", ".R", sep=""))
write.csv(cbind(outtable[[1]]), file=paste("PF_OLS",  ".csv", sep=""))
write.csv(cbind(outtable[[2]]), file=paste("PFIAS_OLS",  ".csv", sep=""))


