###################################################################
# Name              : CobbDouglas_IV_parsinv_notreatment.R
#
# Description       : This program estimates the structural 
#                     parameters of the Cobb Douglas production 
#                     functions for cognitive and socio-emotional 
#                     skills with only mat investment in the cognitive 
#                     production function and only time investment 
#                     in the socio-emotional production function and 
#                     excluding treatment from the production function
###################################################################


###################################################################
# Estimate starting values 
##################################################################
if (nameFirstStage==c("FirstStage_toyprice_foodprice_conflict")){
start1      <- lm(cog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids, mat), data=regdata_true)$coef
start2      <- lm(ncog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids, time), data=regdata_true)$coef
start       <- cbind(start1, start2)
} 

if (nameFirstStage==c("FirstStage_toyprice_foodprice")){
  start1      <- lm(cog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids, mat), data=regdata_true)$coef
  start2      <- lm(ncog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids, time), data=regdata_true)$coef
  start       <- cbind(start1, start2)
} 

###################################################################
# Estimate production functions on true data 
###################################################################
pf_true         <- md.1inv.flexfunc(invest_true, rdform_true[,1], 
                                    rdform_true[,2], cogrdf_var[c(posExo, posInv), c(posExo, posInv)], ncogrdf_var[c(posExo, posInv), c(posExo, posInv)],  
                                    start, posExo, posInv, 
                                    weighting=TRUE, nInvest = 2)  


###################################################################
# Estimate production functions on bootstrapped samples 
###################################################################
pf_bstrap             <- array(0, dim=c(dim(pf_true), nof))

for (b in 1:nof){  
  
  pf_bstrap[,,b]         <- md.1inv.flexfunc(invest_bstrap[,,b], rdform_bstrap[,1,b], 
                                             rdform_bstrap[,2,b], cogrdf_var[c(posExo, posInv), c(posExo, posInv)], ncogrdf_var[c(posExo, posInv), c(posExo, posInv)], 
                                             start, posExo, posInv, weighting=TRUE, nInvest = 2)
  print(b)
  
  
} 




##############################################################################
# Create table of estimates (point estimate followed by bootstrapped 
# standard errors, 95% ci, p-value one tail test and p-value two tailed test)
##############################################################################

pf_true_new       <- matrix(0, nrow(pf_true)+1, 2)
pf_bstrap_new       <- array(0, dim=c(dim(pf_true_new), nof))

pf_true_new[1:nrow(pf_true),1]  <- pf_true[1:nrow(pf_true),1]
pf_true_new[1:(nrow(pf_true)-1), 2] <- pf_true[1:(nrow(pf_true)-1), 2]
pf_true_new[nrow(pf_true)+1, 2] <- pf_true[nrow(pf_true), 2]

pf_bstrap_new[1:nrow(pf_bstrap),1,]  <- pf_bstrap[1:nrow(pf_bstrap),1,]
pf_bstrap_new[1:(nrow(pf_bstrap)-1), 2,] <- pf_bstrap[1:(nrow(pf_bstrap)-1), 2,]
pf_bstrap_new[nrow(pf_bstrap)+1, 2,] <- pf_bstrap[nrow(pf_bstrap), 2,]



outtrue     <- list(pf_true_new)  
outb        <- list(pf_bstrap_new) 

outtable        <- list()
for (s in 1:1) {
  npar                 <- nrow(outtrue[[s]])
  outtable[[s]]        <- matrix(0, npar*5, 2)
  for (j in 1:2){
    for (i in 1:npar){
      mean             <- mean(outb[[s]][i,j,])
      se               <- sd(outb[[s]][i,j,])
      t_stat           <- mean/se
      t_crit           <- (outb[[s]][i,j,] - mean)/se
      p_val            <- try(1 - ecdf(t_crit)(t_stat))
      p_val2           <- try(1 - ecdf(t_crit^2)(t_stat^2))
      
      outtable[[s]][(i*5-4), j]  <- round(outtrue[[s]][i,j],3)
      outtable[[s]][(i*5-3),j]   <- round(sd(outb[[s]][i,j,]),3) 
      outtable[[s]][(i*5-2), j]  <- paste("[", round(quantile(outb[[s]][i,j,], .025),3), ",", 
                                          round(quantile(outb[[s]][i,j,], .975),3), "]", sep="") 
      outtable[[s]][(i*5-1), j]  <- p_val 
      outtable[[s]][(i*5), j]    <- p_val2 
    } 
  } 
} 



# Name output rows and columns 
basic    <- c("Intercept", "", "","","",
              "cog0","", "", "","",
              "ncog0", "", "", "","",
              "cogmo", "", "", "","",
              "ncogmo", "", "", "","") 

pfnames    <- basic 
for (l in 1:length(c(Xnames)))  pfnames <- c(pfnames, c(Xnames)[l], "","", "", "")
pfnames    <- c(pfnames, "mat", "", "","", "", "time", "", "","", "")  


colnames(outtable[[1]]) <- c("Cognitive skills", "Socio-emotional skills")
rownames(outtable[[1]]) <- pfnames


# Save output 
setwd(dir_outputPF)
save(pf_true, pf_bstrap, file=paste("OUTPUT_IV_notreatment_parsinv_pval", ".R", sep=""))
write.csv(cbind(outtable[[1]]), file=paste("PF_IV_notreatment_parsinv_pval", ".csv", sep=""))

