
pf.ols.fullyinteract.func                        <- function(fs, X, Xnames, treatnomiss, RHSnames , pos, totmean, mean, cov, prob, parametric){
 

  Xall       <- cbind(X)
  
  RHSnames    <- c("treat", "cog0",  "ncog0",  "mat", "time",   "cogmo", "ncogmo", "cog0_T", "ncog0_T","mat_T","time_T","cogmo_T", "ncogmo_T", Xnames)

  fmla_cog    <- as.formula(paste("cog1 ~ ", paste(RHSnames, collapse= "+")))
  fmla_ncog   <- as.formula(paste("ncog1 ~ ", paste(RHSnames, collapse= "+")))

  # Compute correction matrix 
    A             <- bartlett.correction.mixt.interacttreat.func(list(fs[[1]][,pos], fs[[2]][,pos]), Xall, treatnomiss, nG=2,nF, nFpos=ncol(fs[[1]][,pos]), 
                                                                 nX=ncol(Xall), pos, totmean, mean, cov, prob, parametric)
    regdata       <- data.frame(cbind(rbind(fs[[1]],fs[[2]]),  rbind(fs[[1]],fs[[2]]) *  treatnomiss , Xall, treatnomiss))


 # Make regression dataset
      
     colnames(regdata) <- c("cog1", "cog0", "ncog1", "ncog0", "mat", "time", "cogmo", "ncogmo", 
                            "cog1_T", "cog0_T", "ncog1_T", "ncog0_T", "mat_T", "time_T", "cogmo_T", "ncogmo_T", Xnames,"treat")
     data_Xnoint       <- regdata[,c(-1, -3, -9, -11,  -ncol(regdata))]

 # Estimate investment function and correct coefficients
     cog            <- lm(fmla_cog, data=as.data.frame(regdata))
     cog_bias       <- as.matrix(cog$coefficients)
     cogslo         <- solve(A) %*% as.vector(cog$coefficients)[c(-1, -2)]
     cogint0        <- mean(regdata[which(treatnomiss==1),]$cog1) - colMeans(data_Xnoint[which(treatnomiss==1),]) %*% cogslo
     cogint01       <- mean(regdata[which(treatnomiss==2),]$cog1) - colMeans(data_Xnoint[which(treatnomiss==2),]) %*% cogslo
     cogint1        <- cogint01 - cogint0
     cog_correct    <- rbind(cogint0, cogint1, cogslo)

     ncog            <- lm(fmla_ncog, data=as.data.frame(regdata))
     ncog_bias       <- as.matrix(ncog$coefficients)
     ncogslo         <- solve(A) %*% as.vector(ncog$coefficients)[c(-1, -2)]
     ncogint0        <- mean(regdata[which(treatnomiss==1),]$ncog1) - colMeans(data_Xnoint[which(treatnomiss==1),]) %*% ncogslo
     ncogint01       <- mean(regdata[which(treatnomiss==2),]$ncog1) - colMeans(data_Xnoint[which(treatnomiss==2),]) %*% ncogslo
     ncogint1        <- ncogint01 - ncogint0
     ncog_correct    <- rbind(ncogint0, ncogint1, ncogslo)


     # Put estimates together
     est_correct     <- cbind(cog_correct, ncog_correct)
     est_bias        <- cbind(cog_bias, ncog_bias)
     rownames(est_correct) <- c("Intercept", "Treat", "cog0", "ncog0","mat", "time", "cogmo", "ncogmo","cog0_T", "ncog0_T","mat_T", "time_T", "cogmo_T", "ncogmo_T", Xnames)
     rownames(est_bias)    <- rownames(est_correct)

     # Compute residuals for Cragg Donals test
     n                 <- length( regdata$cog1)
     cf_cog            <- as.matrix(regdata$cog1, n, 1)  - matrix(1,n, 1) %*% cogint0    -  treatnomiss %*% cogint1 - as.matrix(data_Xnoint) %*% as.matrix(cogslo)
     cf_ncog            <- as.matrix(regdata$ncog1, n, 1)  - matrix(1,n, 1) %*% ncogint0    -  treatnomiss %*% ncogint1 - as.matrix(data_Xnoint) %*% as.matrix(ncogslo)
     cf                <- cbind(cf_cog, cf_ncog)



   return(list(est_correct , est_bias, cf))
 }

