% This is a marginally modified version of the Fernandez-Villaverde's code


% RBC Model with investment specific technological change,
% capital capacity utilization, and indivisible labor.
%
% Jesus Fernandez-Villaverde
% Philadelphia, March 4, 2005

%----------------------------------------------------------------
% 0. Housekeeping
%----------------------------------------------------------------

close all;


% Number of simulations
nz=10000;
% nz=1000;
% length of a simiulation
hor = 270;



gg=1.0156^0.25;
hh=1:hor;
hh0=51:50+hor;
ddate(1)=1948;
for i=2:hor
    ddate(i)=ddate(i-1)+.25;
end;

samp=find(ddate==1948):find(ddate==2015.25); % for Total hours data


%----------------------------------------------------------------
% 1. Defining variables
%----------------------------------------------------------------

var y c k i l y_l u z1 z2;
varexo e1 e2;

parameters beta psi delta omega alpha rho1 rho2 sigma1 sigma2;

%----------------------------------------------------------------
% 2. Calibration
%----------------------------------------------------------------

alpha   = 0.33;
beta    = 0.99;
psi     = 1.75;
omega   = 1.45;
delta   = 0.0265;
rho1    = 0.95;
rho2    = 0.64;
sigma1  = (0.0022/(1-alpha));
sigma2  = 0.0022;

%----------------------------------------------------------------
% 3. Model
%----------------------------------------------------------------

model;
(1/c) = beta*(1/c(+1))*(alpha*(u(+1)^alpha)*(k^(alpha-1))*(exp(z1(+1))*l(+1))^(1-alpha)+(1-delta*(u(+1)^omega))*exp(z2-z2(+1)));
psi*c = (1-alpha)*((u*k(-1))^alpha)*(exp(z1)^(1-alpha))*(l^(-alpha));
y/k(-1) = omega*delta*(u^omega)/alpha;
c+i = y;
y = ((u*k(-1))^alpha)*(exp(z1)*l)^(1-alpha);
y_l = y/l;
k = (1-(delta*(u^omega)))*k(-1)+exp(z2)*i;
z1 = rho1*z1(-1)+e1;
z2 = rho2*z2(-1)+e2;
end;

%----------------------------------------------------------------
% 4. Computation
%----------------------------------------------------------------

initval;
k = 10;
c = 0.76;
l = 0.31;
y = 1;
i = 0.24;
u = 0.8;
z1 = 0;
z2 = 0;
end;

shocks;
var e1 = sigma1^2;
var e2 = sigma2^2;
end;

steady;



nj=0;

while nj<nz;
    nj=nj+1;
    disp(nj);
    
    
    stoch_simul(periods=355,nocorr,nofunctions,nomoments,irf=0,noprint);
    
    
    
    
    %fp
    pred=[3];
    for i=[1:5 7];
        if i==pred,
            s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',1:options_.periods-1)) ;'];% Levels
            eval(s1);
        else
            s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',2:options_.periods)) ;'];% Levels
            eval(s1);
        end;
    end;
    
    VVl=Vl;
    
    
    
    lh=log(VVl(hh0))';
    
    
    X0h=lh;
    
    
    Xbph(:,nj)=(X0h(samp)-mean(X0h(samp)))*100;
    
    
end;  % end of simulations



%% Estimating Spectral density


TT = 1024;                   % number of points in fft
nkern=13;                    % Kernel
kr = hamming(nkern);


Tsp = length((samp));                    % size of simulated data set, minus 1, before cutting

% number of points in one side of fft
Todd = logical(mod(TT,2));
if Todd
    TT2 = (TT+1)/2;
else
    TT2 = TT/2 + 1;
end

kr = kr/sum(kr);                            % normalize weights to sum to one
nkr = numel(kr);                            % length of kernel function



for nj=1:nz
    [datspecT,~] = DatSpec([Xbph(:,nj)],kr,0,TT);        % call external spectrum estimation function
    spXbpLevelh(:,nj)  = squeeze(datspecT(1,1,:));
end

spXmh=mean(spXbpLevelh,2);


save RBC2SimulatedSpectrum spXmh;

