%=========================================================================%
% BGG Model
% The financial accelerator in an estimated New Keynesian model
% Ian Christensen & Ali Dib 
% RED 2008
%=========================================================================%


% Number of simulations
nz=10000;
% nz=1000;
% length of a simulation
hor = 270;


gg=1.0156^0.25;
hh=1:hor;
hh0=51:50+hor;
ddate(1)=1948;
for i=2:hor
ddate(i)=ddate(i-1)+.25;
end;
 
samp=find(ddate==1948):find(ddate==2015.25); % for Total hours data




var xc xlambda xm xe xR xb xh xw xy xk xa xz xzeta xmu xpi xf xq xi xx xn;

varexo epsa epsb epse epsx epsR;

parameters beta eta theta delta b ppi nu Sss kon psi chi alpha gamma phi rhopi rhoy rhomu sigmaR rhoa sigmaa rhob sigmab rhoe sigmae rhox sigmax lambdac lambdam hss yss css iss fss  Rss zss; 


Ass=1;
beta=.9928;
eta=1.315;
theta=6;
delta=.025;
b=.062;
ppi=1.0079;
nu=.9728;
Sss=1.0075;
psi=0.0420;
chi=0.5882;
alpha=0.3384;
gamma=0.0598;
phi=0.7418;
rhopi=1.4059;
rhoy=0.2947;
rhomu=0.6532;
sigmaR=0.0058;
rhoa=0.7625;
sigmaa=0.0096;
rhob=0.7206;
sigmab=0.0103;
rhoe=0.6156;
sigmae=0.0073;
rhox=0.6562;
sigmax=0.0331;
kon=2;


% SS
qss=1;
zetass=(theta-1)/theta;
Rss=ppi/beta;
fss=Sss*Rss/ppi;
zss=fss-1+delta;
koy=alpha*zetass/zss;
coy=1-delta*koy;
lambdac=inv(1+b*(ppi/(ppi-beta)^(gamma-1)));
lambdam=lambdac*b*(ppi/(ppi-beta))^(gamma);
whlambda=(1-alpha)*lambdac*zetass/coy;
hss=whlambda/(eta+whlambda);
yss=Ass*hss*koy^(alpha/(1-alpha));
kss=koy*yss;
css=coy*yss;
iss=delta*kss;
nss=inv(kon)*kss;

model;
((1-gamma)*lambdac-1)*xc = gamma*xlambda + lambdam*(Rss-1)/Rss * (xb + (gamma-1)*xm) - gamma*xe;
gamma/(Rss-1) * xR = xb + xc - xm;
hss*xh = (1-hss) * (xw+xlambda);
xy = alpha*xk(-1) + (1-alpha)*xh + (1-alpha)*xa;
yss*xy = css*xc + iss*xi;
xw = xy + xzeta - xh;
xz = xy + xzeta - xk;
xmu = xm - xm(-1) + xpi;
xR = rhopi*xpi + rhomu*xmu + rhoy*xy + epsR;
xf = zss/fss*xz + (1-delta)/fss*xq - xq(-1);
xq = chi*(xi-xk(-1)) - xx;
xpi = beta*xpi(+1) + (1-beta*phi)*(1-phi)/phi*xzeta;
xlambda(+1) = xlambda - xR + xpi(+1);
xk = delta*xi + delta*xx + (1-delta)*xk(-1);
xf(+1) = xR - xpi(+1) + psi*(xq+xk-xn);
xn/(nu*fss) = kon*xf - (kon-1)*(xR(-1)-xpi) - psi*(kon-1)*(xk(-1) +xq(-1))+ (psi*(kon-1)+1)*xn(-1);
xx=rhox*xx(-1)+sigmax*epsx;
xa=rhoa*xa(-1)+sigmaa*epsa;
xb=rhob*xb(-1)+sigmab*epsb;
xe=rhoe*xe(-1)+sigmae*epse;
end;


initval;
xc = 0;
xlambda = 0;
xm = 0;
xe = 0;
xR = 0;
xb = 0;
xh = 0;
xw = 0;
xy = 0;
xk = 0;
xa = 0;
xz = 0;
xzeta = 0;
xmu = 0;
xpi = 0;
xf = 0;
xq = 0;
xi = 0;
xx = 0;
xn= 0;
end;


check;
steady;




shocks;
var epsa; stderr 1;
var epsb; stderr 1;
var epse; stderr 1;
var epsx; stderr 1;
var epsR; stderr 1;
end;



%% Stochastic simulations

nj=0;

while nj<nz;
    nj=nj+1;
    disp(nj);
    

stoch_simul(order=1,periods=355,nocorr,nofunctions,nomoments,irf=0,noprint);

    
for i=[7];
    s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',2:options_.periods)) ;'];% Levels
    eval(s1);
end;


X0=Vxh(hh0);
Xbp(:,nj)=(X0(samp)-mean(X0(samp)))*100;
    
end;  % end of simulations


%% Estimating Spectral density

TT = 1024;                   % number of points in fft
nkern=13;                    % Kernel
kr = hamming(nkern);

Tsp = length((samp));                    % size of simulated data set, minus 1, before cutting

% number of points in one side of fft
Todd = logical(mod(TT,2));
if Todd
    TT2 = (TT+1)/2;
else
    TT2 = TT/2 + 1;
end

kr = kr/sum(kr);                            % normalize weights to sum to one
nkr = numel(kr);                            % length of kernel function



for nj=1:nz
    [datspecT,~] = DatSpec([Xbp(:,nj)],kr,0,TT);        % call external spectrum estimation function
    spXbpLevel(:,nj)  = squeeze(datspecT(1,1,:));
end

spXm=mean(spXbpLevel,2);

spXmh=spXm;

save BGGSimulatedSpectrum spXmh;






