## ======================================
## Replicates all tables and figures
## ======================================

  rm(list=ls())
  
  #Assume base R is running
  my.wd <- getSrcDirectory(function(x){x})
  
  #Check for errors
  if(grepl("error", tolower(class(my.wd)[1])) | my.wd==""){
    #Try to access working directory through R Studio API
    my.wd <- tryCatch(dirname(rstudioapi::getActiveDocumentContext()$path),
                      error = function(e) e)
    
  }
  
  #Set working directory
  setwd(my.wd)
  
## ======================================
## Run replication
## ======================================
  #Replication files
  my.files <- list.files(".", pattern = "[1-9]")
  
  #Run all scripts
  for(this.file in my.files){
    print(paste0("Running ", this.file, "..."))
    source(this.file)
  }

