## ======================================
## Table 2: Comparison of illness rates from 1994-1999 between LA and Orange County
## ======================================

  rm(list=ls())
  
  #Assume base R is running
  my.wd <- getSrcDirectory(function(x){x})
  
  #Check for errors
  if(grepl("error", tolower(class(my.wd)[1])) | my.wd==""){
    #Try to access working directory through R Studio API
    my.wd <- tryCatch(dirname(rstudioapi::getActiveDocumentContext()$path),
                      error = function(e) e)
    
  }
  
  #Set working directory
  setwd(my.wd)
  
## ==========================
## Read in data
## ==========================  

  #County population
  county.pop.1964.2015 <- read.csv("../Data/county_population_1964_2015.csv", stringsAsFactors = FALSE)
  
  #Salmonella notifiables
  salm.notif.cty.yr.1964.2015 <- read.csv("../Data/illness_salm_1964_2015.csv", stringsAsFactors = FALSE)

##================================
## Isolate OC and LA salmonella counts and population
## ===============================
  #Years of data
  years <- 1993:1999
  
  #Notifiables time series
  la.series.notif <- as.vector(as.matrix(salm.notif.cty.yr.1964.2015[2,which(gsub("X", "", names(salm.notif.cty.yr.1964.2015))%in%years)]))
  oc.series.notif <- as.vector(as.matrix(salm.notif.cty.yr.1964.2015[3,which(gsub("X", "", names(salm.notif.cty.yr.1964.2015))%in%years)]))
  
  #Population
  la.pop <- county.pop.1964.2015[county.pop.1964.2015$year%in%years & county.pop.1964.2015$Name=="Los Angeles","pop"]
  oc.pop <- county.pop.1964.2015[county.pop.1964.2015$year%in%years & county.pop.1964.2015$Name=="Orange","pop"]
  
  #Calculate rates
  la.rates <- 100000*la.series.notif/la.pop
  oc.rates <- 100000*oc.series.notif/oc.pop
  
  #Calculate change in rates  
  la.change <- cbind((la.rates[2:length(la.rates)]-la.rates[1:(length(la.rates)-1)])/la.rates[1:(length(la.rates)-1)])
  oc.change <- cbind((oc.rates[2:length(oc.rates)]-oc.rates[1:(length(oc.rates)-1)])/oc.rates[1:(length(oc.rates)-1)])
    
##================================
## Output: Table
## ===============================
  
  #Table 
  print("Table 2: Comparison of illness rates from 1994-1999 between LA and Orange County")
  print(data.frame(year = years[c(2:7)], 
            la.rate = round(la.rates[c(2:7)], 1), 
            oc.rate = round(oc.rates[c(2:7)], 1), 
            la.change = round(la.change*100, 1), 
            oc.change = round(oc.change*100, 1)))

  
  
 