function param = calibrate_income_process(rho, std, Nstate, param)
% Discretization using Rouwenhorst (1995) method
[states, transition_p]	= rouwenhorst(rho,std,Nstate);
transition_p			= transition_p';

% Find ergodic distribution over discretized space
freq_s = zeros(Nstate,1); freq_s(1)=1;
while max(abs(transition_p*freq_s-freq_s))>1e-10
    freq_s = transition_p*freq_s;
end

% Normalization so that ymean=1
% Equivalent to substracting std^2/(2*(1-rho^2)) 
% in the limit where Nstate=inf so shocks are normal
states			= states - log(exp(states)*freq_s); 
states			= exp(states)';
yh				= max(states);
ymean			= states'*freq_s;

param.Nstate	= Nstate;
param.pp		= transition_p;
param.ppcum		= cumsum(param.pp);
param.ss		= states;
param.ssmean	= ymean;
param.yh		= yh;
end