%% Replication of Figure 1 for "Monetary Policy, Bounded Rationality, and Incomplete Markets"
% by Emmanuel Farhi and Iv�n Werning
% 
% Written and prepared by Mikel Petri
% Sunday June 23, 2019

T	= 17;	% Horizon in the graph
K	= 1;	% Max K in the graph 

%% Create and store simulations
param5			= param;
param5.lambda	= 1;	% Calvo fraction NOT adjusting prices

sigmas			= linspace(0.3, 0.9, 7);		% 0.3 <= CRRA <= 0.9 /// 3.34 > IES > 1.1
sigmas			= [sigmas, linspace(1, 4, 7)];	% Add 4 >= CRRA >= 1 /// 0.25 <= IES <= 1

betas_high		= 0.9942*ones(1,7);
betas_high		= [betas_high, 0.99*ones(1,7)];

for i=1:length(sigmas)
    param5.sigma		= sigmas(i);
	param5.beta_high	= betas_high(i);
	
	% HA
    file_name = ['./simulations/fig5/simul_sigma', num2str(sigmas(i)*10,'%03.0f'), '_rigid_T17'];
	if exist(fullfile(pwd, [file_name, '.mat']), 'file') == 0
        disp([newline, 'Fig 5: Calculating HA response for IES=', num2str(1/sigmas(i),'%02.1f')]);
		econ = DynamicsReducedForm(param5);
		econ.one_period_shock(17,1/1.01,17+20,7);
		save([file_name, '.mat'], 'econ', 'param5');
	end
	
	% RA
	file_name = ['./simulations/fig5/simul_RA_sigma', num2str(sigmas(i)*10,'%03.0f'), '_rigid_T17'];
    if exist(fullfile(pwd, [file_name, '.mat']), 'file') == 0
        disp([newline, 'Fig 5: Calculating RA response for IES=', num2str(1/sigmas(i),'%02.1f')]);
        econ = DynamicsReducedFormRA(param5);
        econ.one_period_shock(17,1/1.01,17+20,7);
        save([file_name, '.mat'], 'econ', 'param5');
    end
end
%% Load and collect data from simulations
files = dir(['./simulations/fig5/simul_sigma*_rigid_T', num2str(T,'%02.0f'), '.mat'])';

y1_HA		= zeros(length(files),K);
y1_RA		= y1_HA;
y1_HA_RE	= zeros(length(files),1);
y1_RA_RE	= y1_HA_RE;

sigmas = ones(length(files),1)*NaN;

for i_file=1:length(files)
	load(['./simulations/fig5/', files(i_file).name]);
	y1_HA(i_file,:)		= (econ.Yt(1,2:(K+1))/econ.Y-1)/(econ.R/econ.Rt(T)-1);
	y1_HA_RE(i_file)	= (econ.Yt(1,end)/econ.Y-1)/(econ.R/econ.Rt(T)-1);
	sigmas(i_file)		= 1/econ.sigma;
end

files = dir(['./simulations/fig5/simul_RA_sigma*_rigid_T', num2str(T,'%02.0f'), '.mat'])';
% files = files(1:21);

for i_file=1:length(files)
    load(['./simulations/fig5/', files(i_file).name]);
	y1_RA(i_file,:) = (econ.Yt(1,2:(K+1))/econ.Y-1)/(econ.R/econ.Rt(T)-1);
	y1_RA_RE(i_file) = (econ.Yt(1,end)/econ.Y-1)/(econ.R/econ.Rt(T)-1);
end

ratio_RA	= y1_RA(:,1)./y1_RA_RE;
ratio_HA	= y1_HA(:,1)./y1_HA_RE;

%% Create plots
figure('position',[.1 .1 1000 800]) %1400 800 if 2x3

% NORMAL SCALE
subplot(2,1,1)
co = get(gca,'colororder');
marker = {'o', '^', 'x', 'd'};
leg = {'RA $k=\infty$', 'RA $k=1$', 'HA $k=\infty$','HA $k=1$'};
for k=1:K
    plot(sigmas, y1_RA_RE(:,k), strcat('-.k', ''), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
	hold on;
	plot(sigmas, y1_RA(:,k), strcat('-.', ''), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
	set(gca, 'ColorOrderIndex', k);
	
	plot(sigmas, y1_HA_RE(:,k), strcat('-k', ''), 'LineWidth', 2, 'MarkerSize', 4, 'MarkerFaceColor', 'k');
	plot(sigmas, y1_HA(:,k), strcat('-', ''), 'LineWidth', 2, 'MarkerSize', 4, 'MarkerFaceColor', co(k,:));
end

h = legend(leg(1:2*(K+1)),'Interpreter','Latex','Location','northwest','NumColumns',2);

ylim([0 3]);
xlim([0.3 3]);
xticks([0.3 1:0.5:3])
ylabel('$$\epsilon_{16}^k$$', 'Interpreter','Latex', 'FontSize', 20)
xlabel('$\sigma$', 'Interpreter','Latex', 'FontSize', 20)

set(gca, 'Color', 'none');
set(h, 'Color', 'w');
grid on
set(gca, 'XGrid', 'off')

% LOG SCALE
subplot(2,1,2)
for k=1:K
    semilogy(sigmas, y1_RA_RE(:,k), strcat('-.k', ''), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
	hold on;
	semilogy(sigmas, y1_RA(:,k), strcat('-.', ''), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
	set(gca, 'ColorOrderIndex', k);
	
	semilogy(sigmas, y1_HA_RE(:,k), strcat('-k', ''), 'LineWidth', 2, 'MarkerSize', 4, 'MarkerFaceColor', 'k');
	hold on;
	semilogy(sigmas, y1_HA(:,k), strcat('-', ''), 'LineWidth', 2, 'MarkerSize', 4, 'MarkerFaceColor', co(k,:));
end

h = legend(leg(1:2*(K+1)),'Interpreter','Latex','Location','northwest','NumColumns',2);

ylim([0.09 3]);
xlim([0.3 3]);
yticks([0.1, 1, 3])
xticks([0.3 1:0.5:3])
ylabel('$$\epsilon_{16}^k$$ (log scale)', 'Interpreter','Latex', 'FontSize', 20)
xlabel('$\sigma$', 'Interpreter','Latex', 'FontSize', 20)
set(gca, 'Color', 'none');

set(h, 'Color', 'w');
grid on
set(gca, 'XGrid', 'off')

export_fig ('./figures/fig5.pdf', '-transparent');

clearvars -except param