%% Replication of Figure 1 for "Monetary Policy, Bounded Rationality, and Incomplete Markets"
% by Emmanuel Farhi and Iv�n Werning
% 
% Written and prepared by Mikel Petri
% Sunday June 23, 2019

T	= 17;	% Max horizon in the graph
K	= 3;	% Max K in the graph

%% Create and store simulations
param1			= param;
param1.lambda	= 1;	% Calvo fraction NOT adjusting prices

% Heterogeneous Agents
econ			= DynamicsReducedForm(param1);
file_name		= './simulations/fig1/simul_RF_rigid_T';
for t = 1:T
    if exist(fullfile(pwd, [file_name, num2str(t,'%02.0f'), '.mat']), 'file') == 0
        display([newline, 'Fig 1: Calculating HA response for shock at T=', num2str(t)]);
        econ.one_period_shock(t,1/1.01,t+20,K);
        save([file_name, num2str(t,'%02.0f'), '.mat'], 'econ', 'param1');
    end
end

% Representative Agent
econ			= DynamicsReducedFormRA(param1);
file_name		= './simulations/fig1/simul_RF_RA_rigid_T';
for t = 1:T
    if exist(fullfile(pwd, [file_name, num2str(t,'%02.0f'), '.mat']), 'file') == 0
        display([newline, 'Fig 1: Calculating RA response for shock at T=', num2str(t)]);
        econ.one_period_shock(t,1/1.01,t+20,K);
        save([file_name, num2str(t,'%02.0f'), '.mat'], 'econ', 'param1');
    end
end

%% Load and collect data from simulations
y1_HA	= zeros(T,K); 
y1_RA	= y1_HA; 

% HA
file_name		= './simulations/fig1/simul_RF_rigid_T';
for t = 1:T
    load([file_name, num2str(t,'%02.0f'), '.mat'], 'econ');
    y1_HA(t,:) = (econ.Yt(1,2:(K+1))/econ.Y-1)/(econ.R/econ.Rt(t)-1);
end

% RA
file_name		= './simulations/fig1/simul_RF_RA_rigid_T';
for t = 1:T
    load([file_name, num2str(t,'%02.0f'), '.mat'], 'econ');
    y1_RA(t,:) = (econ.Yt(1,2:(K+1))/econ.Y-1)/(econ.R/econ.Rt(t)-1);
end

%% Plot graph
figure('position',[.1 .1 1000 400])
co = get(gca,'colororder');
plot(0:16,ones(17,1),'-','Color', 'k','LineWidth',2);	% RE responde
set(gca, 'ColorOrderIndex', 1);
hold on;
marker = {'o', '^', 'x', 'd'};
leg = cell(2*K+1, 1);
leg{1} = '$k=\infty$ (RE)';
for k=1:K
    plot(0:16, y1_RA(:,k), strcat('--', marker{k}), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
    set(gca, 'ColorOrderIndex', k);
    plot(0:16, y1_HA(:,k), strcat('- ', marker{k}), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
	leg(2*k:2*k+1) = {['RA $$k=', num2str(k), '$$'], ['HA $$k=', num2str(k), '$$']};
end

h = legend(leg(1:2*K+1), 'Interpreter', 'Latex', 'Location', 'southwest', 'NumColumns', K+1);
h.AutoUpdate = 'off';
h.PlotChildren = h.PlotChildren([2:7, 1]);
set(h, 'Color', 'w');

ylim([0 1.2]);
xlim([0 16]);
ylabel('$\epsilon^k_{\tau}$', 'Interpreter','Latex', 'FontSize', 20)
xlabel('$\tau$', 'Interpreter','Latex', 'FontSize', 20)

set(gca, 'Color', 'none');
grid on
set(gca, 'XGrid', 'off')

export_fig ('./figures/fig1.pdf', '-transparent');

clearvars -except param