(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     19112,        428]
NotebookOptionsPosition[     17837,        399]
NotebookOutlinePosition[     18203,        415]
CellTagsIndexPosition[     18160,        412]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"REPLICATION", " ", "OF", " ", "FIGURE", " ", "2"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"ro", ",", "sigma", ",", "MeanSEforFFH"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Distribution", " ", "of", " ", "lying", " ", "costs"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"x_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"TruncatedDistribution", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "sigma"}], "]"}]}], "]"}], ",", "x"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Highest", " ", "report"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"K", ":=", "5"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Probability", " ", "of", " ", "observing", " ", "report", " ", "x", " ",
       "under", " ", "no", " ", "reputational", " ", "concerns", " ", 
      RowBox[{"(", 
       RowBox[{"eta", "=", "0"}], ")"}]}], ",", " ", 
     RowBox[{"see", " ", 
      RowBox[{"ReadMe", ".", "pdf"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProbRepNRC", "[", 
      RowBox[{"x_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "==", "K"}], ",", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"K", "+", "1"}], ")"}]}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"F", "[", 
             RowBox[{
              RowBox[{"K", "-", "y"}], ",", "sigma"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "0", ",", 
              RowBox[{"K", "-", "1"}]}], "}"}]}], "]"}], "+", "1"}], ")"}]}], 
       ",", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"K", "+", "1"}], ")"}]}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"K", "-", "x"}], ",", "sigma"}], "]"}]}], ")"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Mean", " ", "squared", " ", "error", " ", "with", " ", "respect", " ", 
      "to", " ", "the", " ", "experimental", " ", "data", " ", "in", " ", 
      "Fischbacher", " ", "and", " ", "F\[ODoubleDot]llmi"}], "-", 
     RowBox[{"Heusi", " ", "2013"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MeanSEforFFH", "[", "sigma_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRepNRC", "[", 
             RowBox[{"0", ",", "sigma"}], "]"}], "*", "100"}], "-", "6.43"}], 
          ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRepNRC", "[", 
             RowBox[{"1", ",", "sigma"}], "]"}], "*", "100"}], "-", "7.20"}], 
          ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRepNRC", "[", 
             RowBox[{"2", ",", "sigma"}], "]"}], "*", "100"}], "-", "11.57"}],
           ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRepNRC", "[", 
             RowBox[{"3", ",", "sigma"}], "]"}], "*", "100"}], "-", "12.60"}],
           ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRepNRC", "[", 
             RowBox[{"4", ",", "sigma"}], "]"}], "*", "100"}], "-", "27.25"}],
           ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRepNRC", "[", 
             RowBox[{"5", ",", "sigma"}], "]"}], "*", "100"}], "-", "34.96"}],
           ")"}], "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"K", "+", "1"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Minimizing", " ", "the", " ", "mean", " ", "squared", " ", "error", " ", 
     "with", " ", "respect", " ", "to", " ", "sigma"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"NMinimize", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"MeanSEforFFH", "[", "sigma", "]"}], ",", " ", 
       RowBox[{"sigma", ">", "0"}]}], "  ", "}"}], ",", "sigma"}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6653218905473633`*^9, 3.665322139759886*^9}, {
   3.6653221923859386`*^9, 3.6653223420429335`*^9}, {3.6653224318717318`*^9, 
   3.665322439081876*^9}, {3.6653225492410793`*^9, 3.665322566823431*^9}, {
   3.6653228446309905`*^9, 3.665322856452227*^9}, {3.6653229045491896`*^9, 
   3.665322911129321*^9}, {3.665322972730554*^9, 3.665323003834178*^9}, 
   3.6653230545081916`*^9, {3.6653233051012077`*^9, 3.6653233171284504`*^9}, {
   3.6653233587722836`*^9, 3.665323471444538*^9}, {3.665323555598222*^9, 
   3.665323673180974*^9}, {3.6653237116957445`*^9, 3.665323711755746*^9}, {
   3.665323753108573*^9, 3.665323759058692*^9}, {3.665377462360238*^9, 
   3.6653774794465294`*^9}, {3.6653776312023864`*^9, 
   3.6653776397899446`*^9}, {3.6653776759243307`*^9, 
   3.6653777443114915`*^9}, {3.665378141798388*^9, 3.665378222400388*^9}, {
   3.6653783273953876`*^9, 3.665378354386388*^9}, {3.6653783933073883`*^9, 
   3.665378448451388*^9}, {3.665378480010388*^9, 3.665378484632388*^9}, {
   3.665380030084114*^9, 3.665380082731315*^9}, {3.6653801250756083`*^9, 
   3.6653801405319695`*^9}, {3.6653801810509644`*^9, 
   3.6653801835837107`*^9}, {3.665381106544634*^9, 3.6653811099599752`*^9}, {
   3.665381864911468*^9, 3.6653818815171285`*^9}, {3.6653831080268097`*^9, 
   3.66538315496481*^9}, {3.66538319977281*^9, 3.66538319995581*^9}, {
   3.6653834216101365`*^9, 3.6653834485828333`*^9}, {3.665383487388714*^9, 
   3.6653834879157662`*^9}, {3.7269152108855906`*^9, 3.7269152734052167`*^9}, 
   3.7269154338478255`*^9, {3.726915495230441*^9, 3.72691554193091*^9}, {
   3.7571418437996626`*^9, 3.7571418453930397`*^9}, {3.757143098524267*^9, 
   3.757143102400547*^9}, {3.757143143075894*^9, 3.7571431722505655`*^9}, {
   3.757162414169341*^9, 3.757162636298018*^9}, {3.7571627657332444`*^9, 
   3.757162801683863*^9}, {3.757162859924965*^9, 3.7571628751046324`*^9}, {
   3.7571629091905046`*^9, 3.7571630511895733`*^9}, {3.7571630894856987`*^9, 
   3.757163128092335*^9}, {3.7571729628756495`*^9, 3.757172975582226*^9}, {
   3.757173125741542*^9, 3.7571731890252004`*^9}, {3.7571732330956135`*^9, 
   3.7571732845597677`*^9}, {3.757173315518761*^9, 3.7571733414899263`*^9}, {
   3.7571733916560197`*^9, 3.7571734382667556`*^9}, {3.757173473505392*^9, 
   3.7571734736617594`*^9}, {3.757176257456459*^9, 3.7571763519806366`*^9}, {
   3.757176469796834*^9, 3.7571767286633067`*^9}, {3.7571767843903694`*^9, 
   3.757176792609517*^9}, {3.75717689194084*^9, 3.757176966243521*^9}, {
   3.7571772873305397`*^9, 3.7571773276123066`*^9}, {3.75717737211786*^9, 
   3.7571774126881323`*^9}, 3.757177450617428*^9, {3.757177495179057*^9, 
   3.7571775654239745`*^9}, {3.7571778004932604`*^9, 
   3.7571778112767396`*^9}, {3.7571778608146286`*^9, 3.7571779479774895`*^9}, 
   3.7571779826864576`*^9, {3.757179096468257*^9, 3.757179165454647*^9}, {
   3.757179461850109*^9, 3.757179526435774*^9}, {3.757179562104854*^9, 
   3.757179643580569*^9}, {3.757179779639081*^9, 3.757179837032166*^9}, {
   3.757179948799305*^9, 3.757180005195004*^9}, {3.7572293422939816`*^9, 
   3.757229405812361*^9}, {3.757235661011888*^9, 3.7572356610743732`*^9}, {
   3.7572357787038107`*^9, 3.757235786373478*^9}, {3.75723585901731*^9, 
   3.7572358595927477`*^9}, {3.757235908155158*^9, 3.757235908530155*^9}, {
   3.7574256650746584`*^9, 3.7574256653402205`*^9}, {3.7574266685266485`*^9, 
   3.7574267005614243`*^9}, {3.7574267415169635`*^9, 
   3.7574267422707443`*^9}, {3.7574267739097066`*^9, 
   3.7574268856514807`*^9}, {3.7574273398603635`*^9, 3.757427340391262*^9}, {
   3.7574282074804544`*^9, 3.7574282152793818`*^9}, {3.757428280589263*^9, 
   3.7574283278441353`*^9}, {3.757428987290638*^9, 3.757428987774673*^9}, {
   3.757701303222204*^9, 3.75770131187993*^9}, {3.757701510811076*^9, 
   3.757701513438842*^9}, {3.7577030908929186`*^9, 3.75770315929437*^9}, {
   3.7577400976927567`*^9, 3.757740116104406*^9}, 3.7577402410348444`*^9, {
   3.7577606095302124`*^9, 3.7577606201944494`*^9}, {3.7578349681724463`*^9, 
   3.7578349705781403`*^9}, {3.757835040170579*^9, 3.757835040857933*^9}, {
   3.7578550714031854`*^9, 3.7578550718834867`*^9}, {3.7579128222557015`*^9, 
   3.7579128228961744`*^9}, 
   3.7579132350826797`*^9},ExpressionUUID->"64db59db-1322-4079-bfed-\
52ca5fae514f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"29.89516272601459`", ",", 
   RowBox[{"{", 
    RowBox[{"sigma", "\[Rule]", "9.674214203940773`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.7571798662587185`*^9, 3.757180013321623*^9, {3.75722938951621*^9, 
   3.7572294068059025`*^9}, 3.757235661974571*^9, 3.7572357876576853`*^9, {
   3.7572359035554266`*^9, 3.7572359094649534`*^9}, 3.757412157631353*^9, 
   3.757426886401108*^9, 3.757428917663045*^9, {3.7574289501736717`*^9, 
   3.757428997274269*^9}, 3.757740119309497*^9, 3.757740241587526*^9, 
   3.757760613214493*^9, 3.7578328290238256`*^9, 3.7579128668297977`*^9, 
   3.757913235843689*^9, 
   3.7579133029274235`*^9},ExpressionUUID->"02779c0e-cafd-4ee9-a50a-\
6da3c8d60e2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Substituting", " ", "the", " ", "obtained", " ", "parameter", " ", 
    "value"}], "*)"}], " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"sigma", "=", "9.67421"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Predicted reporting frequencies:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Calculating", " ", "the", " ", "resulting", " ", "theoretical", " ", 
     "reporting", " ", "frequencies"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"x", "=", "0"}], ",", 
     RowBox[{"x", "\[LessEqual]", "5"}], ",", 
     RowBox[{"x", "++"}], ",", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<x=\>\"", ",", "x", ",", "\"\<: \>\"", ",", 
       RowBox[{"ProbRepNRC", "[", 
        RowBox[{"x", ",", "sigma"}], "]"}]}], "]"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.757175960644486*^9, 3.757175969861082*^9}, {
   3.7571760047831745`*^9, 3.757176067687707*^9}, {3.7571761255251875`*^9, 
   3.7571761325435543`*^9}, {3.757177999174612*^9, 3.7571780556748457`*^9}, {
   3.757179871632471*^9, 3.7571798954485245`*^9}, 3.7571800206375475`*^9, 
   3.757229418890918*^9, {3.7572356702019787`*^9, 3.7572356754120536`*^9}, {
   3.757235739266541*^9, 3.757235739422532*^9}, {3.757235799789011*^9, 
   3.7572358001639214`*^9}, {3.757426704968341*^9, 3.757426727752592*^9}, {
   3.7574269111235485`*^9, 3.757426911295383*^9}, 3.7574269465053835`*^9, {
   3.7574270563646584`*^9, 3.757427070704053*^9}, 3.7577031695078316`*^9, {
   3.7577401239135222`*^9, 3.7577401251293716`*^9}, {3.757912860990355*^9, 
   3.7579128638463554`*^9}, {3.757912900410223*^9, 
   3.7579129006913757`*^9}},ExpressionUUID->"9894e37d-49e8-41f4-8198-\
ab9d19929b32"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Predicted reporting frequencies:\"\>"], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, {
   3.757179888352917*^9, 3.7571798961356916`*^9}, 3.7571800213405013`*^9, 
   3.757229419499928*^9, {3.757235672633284*^9, 3.7572356760328407`*^9}, 
   3.757235721756339*^9, 3.7572358007887535`*^9, 3.757426947973556*^9, 
   3.757740126217608*^9, 3.7578328338590074`*^9, 3.757912870766399*^9, 
   3.757912901269365*^9, 
   3.7579133064289956`*^9},ExpressionUUID->"94a13308-7e65-4052-bce8-\
76a26acbcafb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.10087820064193873`"}],
  SequenceForm["x=", 0, ": ", 0.10087820064193873`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, {
   3.757179888352917*^9, 3.7571798961356916`*^9}, 3.7571800213405013`*^9, 
   3.757229419499928*^9, {3.757235672633284*^9, 3.7572356760328407`*^9}, 
   3.757235721756339*^9, 3.7572358007887535`*^9, 3.757426947973556*^9, 
   3.757740126217608*^9, 3.7578328338590074`*^9, 3.757912870766399*^9, 
   3.757912901269365*^9, 
   3.7579133064289956`*^9},ExpressionUUID->"fd69ab38-a728-4466-b3b0-\
5cff5a2b0200"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.11321032754429623`"}],
  SequenceForm["x=", 1, ": ", 0.11321032754429623`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, {
   3.757179888352917*^9, 3.7571798961356916`*^9}, 3.7571800213405013`*^9, 
   3.757229419499928*^9, {3.757235672633284*^9, 3.7572356760328407`*^9}, 
   3.757235721756339*^9, 3.7572358007887535`*^9, 3.757426947973556*^9, 
   3.757740126217608*^9, 3.7578328338590074`*^9, 3.757912870766399*^9, 
   3.757912901269365*^9, 
   3.7579133064289956`*^9},ExpressionUUID->"0f72176f-f1e5-412b-bc23-\
aa13a60644a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.12608045871874682`"}],
  SequenceForm["x=", 2, ": ", 0.12608045871874682`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, {
   3.757179888352917*^9, 3.7571798961356916`*^9}, 3.7571800213405013`*^9, 
   3.757229419499928*^9, {3.757235672633284*^9, 3.7572356760328407`*^9}, 
   3.757235721756339*^9, 3.7572358007887535`*^9, 3.757426947973556*^9, 
   3.757740126217608*^9, 3.7578328338590074`*^9, 3.757912870766399*^9, 
   3.757912901269365*^9, 
   3.757913306444603*^9},ExpressionUUID->"ae80d066-f991-4ad4-b51d-\
37bfa3d86a18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.13936944075349234`"}],
  SequenceForm["x=", 3, ": ", 0.13936944075349234`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, {
   3.757179888352917*^9, 3.7571798961356916`*^9}, 3.7571800213405013`*^9, 
   3.757229419499928*^9, {3.757235672633284*^9, 3.7572356760328407`*^9}, 
   3.757235721756339*^9, 3.7572358007887535`*^9, 3.757426947973556*^9, 
   3.757740126217608*^9, 3.7578328338590074`*^9, 3.757912870766399*^9, 
   3.757912901269365*^9, 
   3.757913306444603*^9},ExpressionUUID->"c373a31b-d779-4645-bbfa-\
672146ce6419"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.1529452025208403`"}],
  SequenceForm["x=", 4, ": ", 0.1529452025208403],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, {
   3.757179888352917*^9, 3.7571798961356916`*^9}, 3.7571800213405013`*^9, 
   3.757229419499928*^9, {3.757235672633284*^9, 3.7572356760328407`*^9}, 
   3.757235721756339*^9, 3.7572358007887535`*^9, 3.757426947973556*^9, 
   3.757740126217608*^9, 3.7578328338590074`*^9, 3.757912870766399*^9, 
   3.757912901269365*^9, 
   3.757913306444603*^9},ExpressionUUID->"fb07e0ff-7688-476b-8a9f-\
92ea9c84df6d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.3675163698206855`"}],
  SequenceForm["x=", 5, ": ", 0.3675163698206855],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, {
   3.757179888352917*^9, 3.7571798961356916`*^9}, 3.7571800213405013`*^9, 
   3.757229419499928*^9, {3.757235672633284*^9, 3.7572356760328407`*^9}, 
   3.757235721756339*^9, 3.7572358007887535`*^9, 3.757426947973556*^9, 
   3.757740126217608*^9, 3.7578328338590074`*^9, 3.757912870766399*^9, 
   3.757912901269365*^9, 
   3.757913306444603*^9},ExpressionUUID->"088f7553-9d06-45f6-b56e-\
21e4f8392af6"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1780, 944},
WindowMargins->{{40, Automatic}, {4, Automatic}},
Magnification->2.,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 9156, 199, 991, "Input",ExpressionUUID->"64db59db-1322-4079-bfed-52ca5fae514f"],
Cell[9739, 223, 740, 15, 90, "Output",ExpressionUUID->"02779c0e-cafd-4ee9-a50a-6da3c8d60e2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10516, 243, 1819, 37, 340, "Input",ExpressionUUID->"9894e37d-49e8-41f4-8198-ab9d19929b32"],
Cell[CellGroupData[{
Cell[12360, 284, 615, 9, 44, "Print",ExpressionUUID->"94a13308-7e65-4052-bce8-76a26acbcafb"],
Cell[12978, 295, 805, 15, 44, "Print",ExpressionUUID->"fd69ab38-a728-4466-b3b0-5cff5a2b0200"],
Cell[13786, 312, 805, 15, 44, "Print",ExpressionUUID->"0f72176f-f1e5-412b-bc23-aa13a60644a1"],
Cell[14594, 329, 803, 15, 44, "Print",ExpressionUUID->"ae80d066-f991-4ad4-b51d-37bfa3d86a18"],
Cell[15400, 346, 803, 15, 44, "Print",ExpressionUUID->"c373a31b-d779-4645-bbfa-672146ce6419"],
Cell[16206, 363, 800, 15, 44, "Print",ExpressionUUID->"fb07e0ff-7688-476b-8a9f-92ea9c84df6d"],
Cell[17009, 380, 800, 15, 44, "Print",ExpressionUUID->"088f7553-9d06-45f6-b56e-21e4f8392af6"]
}, Open  ]]
}, Open  ]]
}
]
*)

